/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bigface;

import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.data.FaceDbBean;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.appbase.resource.file.ResDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.hiyo.channel.base.callback.bigface.IGetFaceResCallBack;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class FaceResManager {
    private static final String TAG = "BigFace_ResDownloader";
    private static final String PROJECTS_DIR_NAME = "BigFace";
    private final ArrayList<MyDownloader> mMyDownloaders = new ArrayList(2);
    private IQueueTaskExecutor mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();

    public static FaceResManager getInstance() {
        return SingleHolder.INSTANCE;
    }

    private FaceResManager() {
    }

    private static synchronized File isResExist(FaceDbBean item) {
        String[] files;
        File resItem = new File(FaceResManager.getProjectsDir(), item.getMd5());
        if (resItem.exists() && resItem.isDirectory() && (files = resItem.list()) != null && files.length > 0) {
            return resItem;
        }
        return null;
    }

    public void preloadRes(final FaceDbBean item) {
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                FaceResManager.this.preloadResInner(item);
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadResInner(FaceDbBean item) {
        if (item == null || StringUtils.isEmpty((String)item.getMd5()) || StringUtils.isEmpty((String)item.getSvgaurl())) {
            MLog.error((Object)TAG, (String)"preload params error : %s!", (Object[])new Object[]{item == null ? "null" : item.getFaceId()});
            return;
        }
        if (FaceResManager.isResExist(item) != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"res already exist : %s!", (Object[])new Object[]{item.getFaceId()});
            }
            return;
        }
        MyDownloader downloader = this.find(item);
        if (downloader == null) {
            final MyDownloader fDownloader = MyDownloader.create(item);
            fDownloader.addCallBack(new IDownloadCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onComplete(Downloader downloader) {
                    ArrayList arrayList = FaceResManager.this.mMyDownloaders;
                    synchronized (arrayList) {
                        FaceResManager.this.mMyDownloaders.remove(fDownloader);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onError(Downloader downloader, int errorType, String errorInfo) {
                    ArrayList arrayList = FaceResManager.this.mMyDownloaders;
                    synchronized (arrayList) {
                        FaceResManager.this.mMyDownloaders.remove(fDownloader);
                    }
                }

                public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
                }

                public void onStart(Downloader downloader) {
                }
            });
            ArrayList<MyDownloader> arrayList = this.mMyDownloaders;
            synchronized (arrayList) {
                this.mMyDownloaders.add(fDownloader);
            }
            fDownloader.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MyDownloader find(FaceDbBean item) {
        ArrayList<MyDownloader> arrayList = this.mMyDownloaders;
        synchronized (arrayList) {
            for (MyDownloader downloader : this.mMyDownloaders) {
                if (downloader == null || !StringUtils.equal((String)downloader.zipMd5, (String)item.getMd5()) || !StringUtils.equal((String)downloader.zipUrl, (String)item.getSvgaurl())) continue;
                return downloader;
            }
        }
        return null;
    }

    public synchronized void getResPath(FaceDbBean item, String resName, IGetFaceResCallBack callback2) {
        if (item == null || StringUtils.isEmpty((String)resName)) {
            if (callback2 != null) {
                callback2.onError(-1, "param error!");
            }
            return;
        }
        ArrayList<String> resItems = new ArrayList<String>(1);
        resItems.add(resName);
        this.getResPath(item, resItems, callback2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getResPathInner(final FaceDbBean item, final ArrayList<String> resItems, final IGetFaceResCallBack callback2) {
        if (item == null || StringUtils.isEmpty((String)item.getMd5()) || resItems == null || resItems.size() <= 0) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback2 != null) {
                        callback2.onError(-1, "param error!");
                    }
                }
            });
            return;
        }
        boolean success = this.getResPathFromCache(item, resItems, callback2);
        if (success) {
            return;
        }
        MyDownloader downloader = this.find(item);
        if (downloader == null) {
            downloader = MyDownloader.create(item);
            ArrayList<MyDownloader> arrayList = this.mMyDownloaders;
            synchronized (arrayList) {
                this.mMyDownloaders.add(downloader);
            }
        }
        final MyDownloader fDownloader = downloader;
        IDownloadCallback downloadCallback = new IDownloadCallback(){

            public void onComplete(Downloader downloader) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ArrayList arrayList = FaceResManager.this.mMyDownloaders;
                        synchronized (arrayList) {
                            FaceResManager.this.mMyDownloaders.remove(fDownloader);
                        }
                        FaceResManager.this.getResPathFromCache(item, resItems, callback2);
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Downloader downloader, int errorType, String errorInfo) {
                ArrayList arrayList = FaceResManager.this.mMyDownloaders;
                synchronized (arrayList) {
                    FaceResManager.this.mMyDownloaders.remove(fDownloader);
                }
                if (callback2 != null) {
                    callback2.onError(errorType, errorInfo);
                }
            }

            public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
            }

            public void onStart(Downloader downloader) {
            }
        };
        downloader.addCallBack(downloadCallback);
        downloader.start();
    }

    public synchronized void getResPath(final FaceDbBean item, final ArrayList<String> resItems, final IGetFaceResCallBack callback2) {
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                FaceResManager.this.getResPathInner(item, resItems, callback2);
            }
        }, 0L);
    }

    private boolean getResPathFromCache(FaceDbBean item, ArrayList<String> resItems, final IGetFaceResCallBack callback2) {
        File resDir = FaceResManager.isResExist(item);
        if (resDir == null) {
            return false;
        }
        if (callback2 != null) {
            File resFile = null;
            final HashMap<String, String> resValue = new HashMap<String, String>(2);
            for (String res : resItems) {
                if (res == null) continue;
                resFile = new File(resDir, res);
                if (resFile.exists() && resFile.isFile()) {
                    resValue.put(res, resFile.getAbsolutePath());
                    continue;
                }
                MLog.error((Object)TAG, (String)"get res error, dir:%s exist but fileName:%s not exist!", (Object[])new Object[]{resDir.getAbsolutePath(), res});
                return false;
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback2 != null) {
                        callback2.onSuccess(resValue);
                    }
                }
            });
        }
        return true;
    }

    private static synchronized boolean unzip(File file, File unzipDir) {
        if (file == null || unzipDir == null) {
            return false;
        }
        try {
            if (unzipDir.exists()) {
                YYFileUtils.deleteFile((File)unzipDir);
            }
            YYFileUtils.unZip((String)file.getAbsolutePath(), (String)unzipDir.getAbsolutePath(), (String)"");
            YYFileUtils.deleteFile((File)file);
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"unizp %s", (Object[])new Object[]{file, e});
            try {
                if (unzipDir.exists()) {
                    YYFileUtils.deleteFile((File)unzipDir);
                }
                YYFileUtils.unZip((String)file.getAbsolutePath(), (String)unzipDir.getAbsolutePath(), (String)"");
                YYFileUtils.deleteFile((File)file);
                return true;
            }
            catch (Exception e2) {
                YYFileUtils.deleteFile((File)unzipDir);
                MLog.error((Object)"BigFace_ResDownloader_FileUtilUnzip_", (Throwable)e2);
                return false;
            }
        }
    }

    private static File getProjectsDir() {
        if (RuntimeContext.sIsDebuggable) {
            return FileStorageUtils.getInstance().getDir(false, PROJECTS_DIR_NAME);
        }
        return FileStorageUtils.getInstance().getDir(true, PROJECTS_DIR_NAME);
    }

    private static class MyDownloader
    implements IDownloadCallback {
        public Downloader downloader;
        public String zipUrl;
        public String zipMd5;
        public String name;
        public ArrayList<IDownloadCallback> callbacks = new ArrayList(1);
        private volatile boolean started;

        public synchronized void addCallBack(IDownloadCallback callback2) {
            this.callbacks.add(callback2);
        }

        public File getFile() {
            return new File(FaceResManager.getProjectsDir().getAbsolutePath(), this.zipMd5 + ".zip");
        }

        public File getUnzipDir() {
            return new File(FaceResManager.getProjectsDir().getAbsolutePath(), this.zipMd5);
        }

        public static MyDownloader create(FaceDbBean item) {
            MyDownloader myDownloader = new MyDownloader();
            myDownloader.zipMd5 = item.getMd5();
            myDownloader.zipUrl = item.getSvgaurl();
            Downloader.Builder builder = new Downloader.Builder(myDownloader.zipUrl, myDownloader.getFile());
            builder.setPriority(150);
            builder.setCallBack((IDownloadCallback)myDownloader);
            builder.setFileEtagCheckContent("md5", myDownloader.zipMd5);
            builder.setSupportContinueTransfer(true);
            builder.setTaskGroup(DownloadBussinessGroup.BIGFACE_RES);
            builder.setTaskSubGroup(item.getFaceId());
            if (!NAB.A.equals((Object)NewABDefine.RESOURCE_LIMITED_SPEED.getTest())) {
                builder.setTaskSpeedLimitPerMicsecondValue(ResDefine.Companion.getLimitSpeed(0L));
            }
            myDownloader.downloader = builder.build();
            return myDownloader;
        }

        public synchronized void start() {
            if (this.started) {
                return;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)FaceResManager.TAG, (String)"start %s md5:%s url:%s ", (Object[])new Object[]{this.name, this.zipMd5, this.zipUrl});
            }
            this.downloader.start();
            this.started = true;
        }

        public synchronized void stop() {
            if (!this.started) {
                return;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)FaceResManager.TAG, (String)"stop %s md5:%s url:%s ", (Object[])new Object[]{this.name, this.zipMd5, this.zipUrl});
            }
            this.downloader.delete();
            this.started = false;
        }

        public void onComplete(final Downloader downloader) {
            YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    File file = this.getFile();
                    long size = file.length();
                    File unzipDir = this.getUnzipDir();
                    boolean success = FaceResManager.unzip(file, unzipDir);
                    if (success) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)FaceResManager.TAG, (String)"onComplete %s fileSize:%d md5:%s url:%s ", (Object[])new Object[]{name, (int)size, zipMd5, zipUrl});
                        }
                        YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                MyDownloader myDownloader = this;
                                synchronized (myDownloader) {
                                    for (IDownloadCallback callback2 : callbacks) {
                                        callback2.onComplete(downloader);
                                    }
                                }
                            }
                        });
                    } else {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)FaceResManager.TAG, (String)"onError %s fileSize:%d md5:%s url:%s ", (Object[])new Object[]{name, (int)size, zipMd5, zipUrl});
                        }
                        YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                MyDownloader myDownloader = this;
                                synchronized (myDownloader) {
                                    for (IDownloadCallback callback2 : callbacks) {
                                        callback2.onError(downloader, -2, "unzip error!");
                                    }
                                }
                            }
                        });
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Downloader downloader, int errorType, String errorInfo) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)FaceResManager.TAG, (String)"onError %s md5:%s url:%s ", (Object[])new Object[]{this.name, this.zipMd5, this.zipUrl});
            }
            MyDownloader myDownloader = this;
            synchronized (myDownloader) {
                for (IDownloadCallback callback2 : this.callbacks) {
                    callback2.onError(downloader, errorType, errorInfo);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
            MyDownloader myDownloader = this;
            synchronized (myDownloader) {
                for (IDownloadCallback callback2 : this.callbacks) {
                    callback2.onProgressChange(downloader, totalSize, curSize);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStart(Downloader downloader) {
            MyDownloader myDownloader = this;
            synchronized (myDownloader) {
                for (IDownloadCallback callback2 : this.callbacks) {
                    callback2.onStart(downloader);
                }
            }
        }
    }

    private static final class SingleHolder {
        private static final FaceResManager INSTANCE = new FaceResManager();

        private SingleHolder() {
        }
    }
}

