/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bigface;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.PopupWindow;
import androidx.core.widget.PopupWindowCompat;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAParser;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.data.FaceDbBean;
import com.yy.appbase.extension.EasyExtensionKt;
import com.yy.appbase.extensions.CommonExtensionsKt;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.callback.bigface.IGetFaceResCallBack;
import com.yy.hiyo.channel.component.bigface.FacePreviewWindow;
import com.yy.hiyo.channel.component.bigface.FaceResManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/yy/hiyo/channel/component/bigface/FacePreviewWindow;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "bubble", "Landroid/view/View;", "kotlin.jvm.PlatformType", "mViewWidth", "", "mViewWidthCenter", "popupWindow", "Landroid/widget/PopupWindow;", "svgaImageView", "Lcom/opensource/svgaplayer/SVGAImageView;", "dismiss", "", "showPopupWindow", "anchor", "data", "Lcom/yy/appbase/data/FaceDbBean;", "showSvga", "showSvgaInner", "svgaFile", "Ljava/io/File;", "channel-components_release"})
public final class FacePreviewWindow {
    private final View bubble;
    private final SVGAImageView svgaImageView;
    private PopupWindow popupWindow;
    private final int mViewWidthCenter;
    private final int mViewWidth;
    private final Context context;

    public final void showPopupWindow(@NotNull View anchor, @NotNull FaceDbBean data) {
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.showSvga(data);
        PopupWindow popupWindow = this.popupWindow;
        if (EasyExtensionKt.isTrue((Boolean)(popupWindow != null ? Boolean.valueOf(popupWindow.isShowing()) : null))) {
            return;
        }
        if (this.popupWindow == null) {
            PopupWindow window = new PopupWindow(this.bubble, -2, -2);
            window.setOutsideTouchable(true);
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            window.setOnDismissListener(new PopupWindow.OnDismissListener(this){
                final /* synthetic */ FacePreviewWindow this$0;

                public final void onDismiss() {
                    if (FacePreviewWindow.access$getSvgaImageView$p(this.this$0).isAnimating()) {
                        FacePreviewWindow.access$getSvgaImageView$p(this.this$0).stopAnimation();
                    }
                }
                {
                    this.this$0 = facePreviewWindow;
                }
            });
            this.popupWindow = window;
        }
        PopupWindow popupWindow2 = this.popupWindow;
        if (popupWindow2 == null) {
            Intrinsics.throwNpe();
        }
        PopupWindowCompat.showAsDropDown((PopupWindow)popupWindow2, (View)anchor, (int)CommonExtensionsKt.dp2Px((Number)-25).intValue(), (int)CommonExtensionsKt.dp2Px((Number)-150).intValue(), (int)81);
    }

    public final void dismiss() {
        block1: {
            if (this.svgaImageView.isAnimating()) {
                this.svgaImageView.stopAnimation();
            }
            PopupWindow popupWindow = this.popupWindow;
            if (popupWindow == null) break block1;
            popupWindow.dismiss();
        }
    }

    private final void showSvga(FaceDbBean data) {
        FaceResManager.getInstance().preloadRes(data);
        String name = data.getFaceId() + ".svga";
        FaceResManager.getInstance().getResPath(data, name, new IGetFaceResCallBack(this, name){
            final /* synthetic */ FacePreviewWindow this$0;
            final /* synthetic */ String $name;

            public void onSuccess(@Nullable HashMap<String, String> resValue) {
                if (resValue != null) {
                    String filePath = resValue.get(this.$name);
                    if (!TextUtils.isEmpty((CharSequence)filePath)) {
                        File file = new File(filePath);
                        YYTaskExecutor.execute((Runnable)new Runnable(this, file){
                            final /* synthetic */ showSvga.1 this$0;
                            final /* synthetic */ File $file;

                            public final void run() {
                                FacePreviewWindow.access$showSvgaInner(this.this$0.this$0, this.$file);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$file = file;
                            }
                        });
                    } else {
                        MLog.error((Object)"FacePreviewWindow", (String)"filePath is empty", (Object[])new Object[0]);
                    }
                } else {
                    MLog.error((Object)"FacePreviewWindow", (String)"resValue is null", (Object[])new Object[0]);
                }
            }

            public void onError(int errorType, @Nullable String errorInfo) {
                MLog.error((Object)"FacePreviewWindow", (String)"showSvga: errorType:%d, errorInfo: %s", (Object[])new Object[]{errorType, errorInfo});
            }
            {
                this.this$0 = $outer;
                this.$name = $captured_local_variable$1;
            }
        });
    }

    private final void showSvgaInner(File svgaFile) {
        SVGAParser svgaParser = new SVGAParser(this.context);
        InputStream inputStream = null;
        if (svgaFile.exists()) {
            try {
                inputStream = new FileInputStream(svgaFile);
            }
            catch (FileNotFoundException e) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FacePreviewWindow", (String)"\u5927\u8868\u60c5 svga \u89e3\u6790 inputStream \u51fa\u9519", (Object[])new Object[0]);
                }
                e.printStackTrace();
            }
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FacePreviewWindow", (String)"\u5927\u8868\u60c5 svga \u6587\u4ef6\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        if (inputStream == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FacePreviewWindow", (String)"\u5927\u8868\u60c5 svga  \u7684 inputstream is null", (Object[])new Object[0]);
            }
            return;
        }
        String string2 = svgaFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"svgaFile.name");
        SVGAParser.parse$default((SVGAParser)svgaParser, (InputStream)inputStream, (String)string2, (SVGAParser.ParseCompletion)new SVGAParser.ParseCompletion(this){
            final /* synthetic */ FacePreviewWindow this$0;

            public void onComplete(@NotNull SVGAVideoEntity videoItem) {
                Intrinsics.checkParameterIsNotNull((Object)videoItem, (String)"videoItem");
                if (FacePreviewWindow.access$getSvgaImageView$p(this.this$0).isAnimating()) {
                    FacePreviewWindow.access$getSvgaImageView$p(this.this$0).stopAnimation();
                }
                SVGADrawable drawable2 = new SVGADrawable(videoItem);
                FacePreviewWindow.access$getSvgaImageView$p(this.this$0).setImageDrawable((Drawable)drawable2);
                FacePreviewWindow.access$getSvgaImageView$p(this.this$0).setLoopCount(-1);
                FacePreviewWindow.access$getSvgaImageView$p(this.this$0).startAnimation();
            }

            public void onError() {
                MLog.error((Object)"FacePreviewWindow", (String)"\u5927\u8868\u60c5 svga parser fail", (Object[])new Object[0]);
            }
            {
                this.this$0 = $outer;
            }
        }, (boolean)false, (int)8, null);
    }

    public FacePreviewWindow(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.bubble = View.inflate((Context)this.context, (int)R.layout.layout_big_face_preview_bubble, null);
        View view = this.bubble.findViewById(R.id.bigFacePreView);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"bubble.findViewById(R.id.bigFacePreView)");
        this.svgaImageView = (SVGAImageView)view;
        this.mViewWidthCenter = CommonExtensionsKt.dp2Px((Number)-50).intValue();
        this.mViewWidth = CommonExtensionsKt.dp2Px((Number)-100).intValue();
    }

    public static final /* synthetic */ SVGAImageView access$getSvgaImageView$p(FacePreviewWindow $this) {
        return $this.svgaImageView;
    }

    public static final /* synthetic */ void access$showSvgaInner(FacePreviewWindow $this, File svgaFile) {
        $this.showSvgaInner(svgaFile);
    }
}

