/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.base.util;

import android.content.Intent;
import android.net.Uri;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/yy/hiyo/channel/component/base/util/HyperLinkUtil;", "", "()V", "TAG", "", "interceptHyperLink", "", "tv", "Landroid/widget/TextView;", "clickCallback", "Lcom/yy/appbase/common/Callback;", "", "CustomUrlSpan", "channel-components_release"})
public final class HyperLinkUtil {
    @NotNull
    public static final String TAG = "HyperLinkUtil";
    public static final HyperLinkUtil INSTANCE;

    public final void interceptHyperLink(@NotNull TextView tv, @Nullable Callback<Boolean> clickCallback) {
        Intrinsics.checkParameterIsNotNull((Object)tv, (String)"tv");
        CharSequence text = tv.getText();
        if (text instanceof Spannable) {
            int end = text.length();
            CharSequence charSequence = tv.getText();
            if (charSequence == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.text.Spannable");
            }
            Spannable spannable = (Spannable)charSequence;
            URLSpan[] urlSpans = (URLSpan[])spannable.getSpans(0, end, URLSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)urlSpans, (String)"urlSpans");
            URLSpan[] uRLSpanArray = urlSpans;
            boolean bl = false;
            if (uRLSpanArray.length == 0) {
                return;
            }
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(text);
            URLSpan[] uRLSpanArray2 = urlSpans;
            int n = uRLSpanArray2.length;
            for (int i = 0; i < n; ++i) {
                String url;
                URLSpan uri;
                URLSpan uRLSpan = uri = uRLSpanArray2[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)uRLSpan, (String)"uri");
                String string2 = url = uRLSpan.getURL();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url");
                if (!StringsKt.startsWith$default((String)string2, (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null)) continue;
                CustomUrlSpan customUrlSpan = new CustomUrlSpan(url, clickCallback);
                int startIndex = spannable.getSpanStart((Object)uri);
                int endIndex = spannable.getSpanEnd((Object)uri);
                if (startIndex < 0 || endIndex < 0 || startIndex > endIndex || startIndex > text.length() || end > text.length()) continue;
                spannableStringBuilder.setSpan((Object)customUrlSpan, startIndex, endIndex, 17);
            }
            tv.setText((CharSequence)spannableStringBuilder);
        }
    }

    public static /* synthetic */ void interceptHyperLink$default(HyperLinkUtil hyperLinkUtil, TextView textView, Callback callback2, int n, Object object) {
        if ((n & 2) != 0) {
            callback2 = null;
        }
        hyperLinkUtil.interceptHyperLink(textView, (Callback<Boolean>)callback2);
    }

    private HyperLinkUtil() {
    }

    static {
        HyperLinkUtil hyperLinkUtil;
        INSTANCE = hyperLinkUtil = new HyperLinkUtil();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/yy/hiyo/channel/component/base/util/HyperLinkUtil$CustomUrlSpan;", "Landroid/text/style/ClickableSpan;", "url", "", "callback", "Lcom/yy/appbase/common/Callback;", "", "(Ljava/lang/String;Lcom/yy/appbase/common/Callback;)V", "isInnerUrl", "onClick", "", "widget", "Landroid/view/View;", "channel-components_release"})
    public static final class CustomUrlSpan
    extends ClickableSpan {
        private final String url;
        private Callback<Boolean> callback;

        public void onClick(@NotNull View widget) {
            block2: {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
                    if (!this.isInnerUrl(this.url)) break block1;
                    IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                    if (iServiceManager == null) {
                        Intrinsics.throwNpe();
                    }
                    ((IYYUriService)iServiceManager.getService(IYYUriService.class)).handleUriString(this.url);
                    Callback<Boolean> callback2 = this.callback;
                    if (callback2 == null) break block2;
                    callback2.onResponse((Object)true);
                    break block2;
                }
                Uri uri = Uri.parse((String)this.url);
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                intent.addFlags(0x10000000);
                RuntimeContext.sApplicationContext.startActivity(intent);
                Callback<Boolean> callback3 = this.callback;
                if (callback3 == null) break block2;
                callback3.onResponse((Object)false);
            }
        }

        private final boolean isInnerUrl(String url) {
            boolean innerUrl = false;
            if (StringUtils.isNotEmpty((String)url)) {
                Uri parse;
                Uri uri = parse = Uri.parse((String)url);
                Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"parse");
                String host = uri.getHost();
                if (StringUtils.isNotEmpty((String)host) && URLUtils.isOurHost((String)host)) {
                    innerUrl = true;
                }
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)HyperLinkUtil.TAG, (String)"isInnerUrl url:%s, inner:%b", (Object[])new Object[]{url, innerUrl});
            }
            return innerUrl;
        }

        public CustomUrlSpan(@NotNull String url, @Nullable Callback<Boolean> callback2) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            this.url = url;
            this.callback = callback2;
        }

        public /* synthetic */ CustomUrlSpan(String string2, Callback callback2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                callback2 = null;
            }
            this(string2, (Callback<Boolean>)callback2);
        }
    }
}

