/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.base;

import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.mvp.base.AppLifeCycleOwner;
import com.yy.hiyo.mvp.base.callback.IDestroyable;

public class ChainTask {
    private static final String TAG = "ChainTask";
    private Task mHead;
    private Task mTail;
    private MutableLiveData<Boolean> isFinished = new MutableLiveData();

    private ChainTask() {
        this.mTail = this.mHead = new Task(this);
    }

    public static ChainTask of(final IDestroyable destroyable) {
        final ChainTask task2 = new ChainTask();
        Observer<Boolean> destroyObserver = new Observer<Boolean>(){

            public void onChanged(@Nullable Boolean isDestroy) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ChainTask.TAG, (String)"destroyable onChanged: %s", (Object[])new Object[]{isDestroy});
                }
                if (Boolean.TRUE.equals(isDestroy)) {
                    if (!Boolean.TRUE.equals(task2.isFinished.getValue())) {
                        task2.stopAllTask();
                    }
                    destroyable.isDestroyData().removeObserver((Observer)this);
                    task2.isFinished.removeObservers(AppLifeCycleOwner.get());
                }
            }
        };
        destroyable.isDestroyData().observe(AppLifeCycleOwner.get(), (Observer)destroyObserver);
        task2.isFinished.observe(AppLifeCycleOwner.get(), (Observer)new Observer<Boolean>((Observer)destroyObserver, task2){
            final /* synthetic */ Observer val$destroyObserver;
            final /* synthetic */ ChainTask val$task;
            {
                this.val$destroyObserver = observer2;
                this.val$task = chainTask;
            }

            public void onChanged(@Nullable Boolean isFinished) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ChainTask.TAG, (String)"isFinished onChanged: %s", (Object[])new Object[]{isFinished});
                }
                if (Boolean.TRUE.equals(isFinished)) {
                    destroyable.isDestroyData().removeObserver(this.val$destroyObserver);
                    this.val$task.isFinished.removeObserver((Observer)this);
                }
            }
        });
        return task2;
    }

    public ChainTask onUi(Runnable runnable2) {
        return this.onUi("", runnable2);
    }

    public ChainTask onIdle(String name, Runnable runnable2) {
        this.append(Task.of(this, ThreadType.IDLE, new NamedTask(name, runnable2)));
        return this;
    }

    public ChainTask onIdle(Runnable runnable2) {
        this.onIdle("", runnable2);
        return this;
    }

    public ChainTask onUi(String name, Runnable runnable2) {
        this.append(Task.of(this, ThreadType.MAIN, new NamedTask(name, runnable2)));
        return this;
    }

    public ChainTask onWork(Runnable runnable2) {
        return this.onWork("", runnable2);
    }

    public ChainTask onWork(String name, Runnable runnable2) {
        this.append(Task.of(this, ThreadType.WORK, new NamedTask(name, runnable2)));
        return this;
    }

    @MainThread
    public void stopAllTask() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"stopAllTask", (Object[])new Object[0]);
        }
        Task task2 = this.mHead;
        while (task2 != null) {
            YYTaskExecutor.removeTask((Runnable)task2);
            Task next = task2.mNext;
            task2.mNext = null;
            task2 = next;
        }
        this.isFinished.setValue((Object)true);
        this.isFinished.removeObservers(AppLifeCycleOwner.get());
    }

    public void run() {
        this.mHead.run();
    }

    private void append(Task task2) {
        this.mTail.mNext = task2;
        this.mTail = task2;
    }

    private static enum ThreadType {
        MAIN,
        WORK,
        IDLE;

    }

    private static class NamedTask
    implements Runnable {
        private String mName;
        private Runnable mRunnable;

        private NamedTask(String name, Runnable runnable2) {
            this.mName = name;
            this.mRunnable = runnable2;
        }

        public String toString() {
            return "Name: " + this.mName + ", hash@" + this.hashCode();
        }

        @Override
        public void run() {
            this.mRunnable.run();
        }
    }

    private static class Task
    implements Runnable {
        private ThreadType mThreadType = ThreadType.MAIN;
        private Runnable mNode;
        private Task mNext;
        private ChainTask chainTask;

        private Task(ChainTask chainTask) {
            this.chainTask = chainTask;
        }

        private Task(ChainTask chainTask, ThreadType type, NamedTask runnable2) {
            this(chainTask);
            this.mThreadType = type;
            this.mNode = runnable2;
        }

        private static Task of(ChainTask chainTask, ThreadType type, NamedTask runnable2) {
            Task task2 = new Task(chainTask, type, runnable2);
            return task2;
        }

        @Override
        public void run() {
            if (this.mNode != null) {
                long begin = System.nanoTime();
                if (this.mNode != null) {
                    this.mNode.run();
                }
                long use = (System.nanoTime() - begin) / 1000000L;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ChainTask.TAG, (String)"end task %s, execute %d ms", (Object[])new Object[]{this.mNode, use});
                }
            }
            if (this.mNext != null) {
                switch (this.mNext.mThreadType) {
                    case IDLE: {
                        YYTaskExecutor.postIdleRunnableToMainThread((Runnable)this.mNext);
                        break;
                    }
                    case WORK: {
                        if (YYTaskExecutor.isMainThread()) {
                            YYTaskExecutor.execute((Runnable)this.mNext);
                            break;
                        }
                        this.mNext.run();
                        break;
                    }
                    default: {
                        if (YYTaskExecutor.isMainThread()) {
                            this.mNext.run();
                            break;
                        }
                        YYTaskExecutor.postToMainThread((Runnable)this.mNext);
                        break;
                    }
                }
            } else {
                this.chainTask.isFinished.postValue((Object)true);
            }
        }
    }
}

