/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.act.rightbanner.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.act.rightbanner.ui.BaseRoomActivityView;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.RoomActivityAction;

public class ActImageView
extends BaseRoomActivityView {
    private static final String TAG = "ActImageView";
    private RoundImageView mRoundImg;
    private RoomActivityAction mData;

    public ActImageView(Context context) {
        super(context);
        this.mRoundImg = new RoundImageView(context);
        this.mRoundImg.setScaleType(ImageView.ScaleType.CENTER_CROP);
        int radius = ResolutionUtils.dip2Px((float)3.0f);
        this.mRoundImg.setBorderRadius(radius);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.addView((View)this.mRoundImg, lp);
    }

    @Override
    public void setData(RoomActivityAction data) {
        if (data != null && data.pictureType == ActivityAction.PictureType.IMAGE) {
            this.mData = data;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"iconUrl=%s", (Object[])new Object[]{this.mData.iconUrl});
            }
            this.loadImage(data, R.drawable.yylite_launcher);
            this.setViewSize((View)this.mRoundImg, data);
        }
    }

    @Override
    public RoomActivityAction getData() {
        return this.mData;
    }

    @Override
    public View getView() {
        return this.mRoundImg;
    }

    @Override
    protected void setViewSizePost(View view, final RoomActivityAction roomActivityAction) {
        super.setViewSizePost(view, roomActivityAction);
        if (roomActivityAction == null) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                ActImageView.this.loadImage(roomActivityAction, R.drawable.yylite_launcher);
            }
        });
    }

    private void loadImage(RoomActivityAction roomActivityAction, int errorId) {
        String thumb = YYImageUtils.getThumb((int)Math.max(roomActivityAction.width / 2, 75), (int)Math.max(roomActivityAction.height / 2, 75));
        ImageLoader.loadImage((RecycleImageView)this.mRoundImg, (String)(roomActivityAction.iconUrl + thumb), (int)0, (int)errorId);
    }
}

