/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.act.rightbanner.ui;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.web.IWebManager;
import com.yy.appbase.service.web.IWebManagerCallBack;
import com.yy.appbase.service.web.SimpleWebManagerCallBack;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.component.act.rightbanner.ui.BaseRoomActivityView;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.RoomActivityAction;
import com.yy.webservice.webwindow.webview.base.YYWebView;

public class ActEmbedWebView
extends BaseRoomActivityView {
    private WebView mWebView;
    private RoomActivityAction mData;
    private IWebManager mWebManager;
    private boolean isOwner = false;
    private String mLastUrl = "";
    private boolean isResume;
    private IWebManagerCallBack mWebManagerCallBack = new SimpleWebManagerCallBack(){

        public void showLoading() {
            super.showLoading();
        }

        public void showNetError(String originUrl, int errorCode, String description, String url) {
            super.showNetError(originUrl, errorCode, description, url);
        }

        public void hideStatusView() {
            super.hideStatusView();
        }

        public Activity getActivity() {
            Context context = ActEmbedWebView.this.getContext();
            if (context instanceof ContextThemeWrapper) {
                Context base = ((ContextThemeWrapper)context).getBaseContext();
                if (base instanceof Activity) {
                    return (Activity)base;
                }
                if (context instanceof Activity) {
                    return (Activity)context;
                }
            }
            return null;
        }

        public int from() {
            return 2;
        }

        public void onRefreshComplete(String originUrl, String url) {
            super.onRefreshComplete(originUrl, url);
        }
    };

    public ActEmbedWebView(Context context) {
        super(context);
        try {
            this.mWebView = new YYWebView(context);
            this.mWebView.setBackgroundColor(0);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
            this.addView((View)this.mWebView, lp);
        }
        catch (Exception e) {
            MLog.error((Object)"ActEmbedWebView", (Throwable)e);
        }
    }

    @Override
    public void setData(RoomActivityAction data) {
        if (data != null && data.pictureType == ActivityAction.PictureType.H5) {
            this.mData = data;
            if (!TextUtils.isEmpty((CharSequence)data.iconUrl)) {
                this.gotoWeb(data.iconUrl);
            }
            if (data.isUpdateSize) {
                this.setViewSize((View)this.mWebView, data);
            }
        }
    }

    @Override
    public RoomActivityAction getData() {
        return this.mData;
    }

    @Override
    public View getView() {
        return this.mWebView;
    }

    public void setIsOwner(boolean isOwner) {
        this.isOwner = isOwner;
    }

    private void gotoWeb(String url) {
        if (this.mWebView != null && !TextUtils.isEmpty((CharSequence)url) && !url.equals(this.mLastUrl)) {
            this.mLastUrl = url;
            url = url.indexOf("?") > 0 ? url + "&isOwner=" + this.isOwner : url + "?isOwner=" + this.isOwner;
            if (this.mWebManager == null) {
                this.mWebManager = ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).createWebManager(this.mWebManagerCallBack, this.mWebView);
            }
            this.mWebManager.loadUrl(url);
        }
    }

    public boolean isSameWeb(RoomActivityAction data) {
        if (data == this.mData) {
            return true;
        }
        if (data != null && !TextUtils.isEmpty((CharSequence)data.iconUrl) && this.mData != null) {
            return this.mData.id == data.id && data.iconUrl.equals(this.mData.iconUrl);
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public void onResume() {
        if (this.mWebManager != null && !this.isResume) {
            this.isResume = true;
            this.mWebManager.onResume();
        }
    }

    public void onPause() {
        if (this.mWebManager != null && this.isResume) {
            this.isResume = false;
            this.mWebManager.onPause();
        }
    }

    public void onDestroy() {
        this.removeAllViews();
        if (this.mWebView != null) {
            this.mWebManager.destroy();
        }
    }
}

