/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.db;

import com.yy.appbase.data.BaseCImMsgBean;
import com.yy.appbase.data.CMsgSectionBean;
import com.yy.appbase.data.ChannelMsgsBean;
import com.yy.appbase.db.ChannelMsgDb;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.base.db.ChannelMsgData;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsgWrap;
import java.util.ArrayList;
import java.util.List;

public class ChannelMsgLocal
extends ChannelMsgDb {
    private static final String TAG = "ChannelMsgLocal";
    private ICallBack callback;

    public ChannelMsgLocal(long uid) {
        super(uid);
    }

    public void addGroupMsgData(String groupId, ChannelMsgData data) {
        ChannelMsgsBean bean = new ChannelMsgsBean();
        bean.lastNotHiidenMsgId = data.lastNotHiidenMsgId;
        bean.groupId = groupId;
        bean.unreadNum = data.unreadNum;
        bean.lastReadMsgId = data.lastReadMsgId;
        super.addGroupMsgData(groupId, bean);
    }

    public void deleteGroup(String groupId) {
        super.deleteGroup(groupId);
    }

    public ChannelMsgData getGroupMsgData(String groupId) {
        ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
        if (groupMsgsBean == null) {
            return null;
        }
        try {
            int size;
            ChannelMsgData groupMsgData = new ChannelMsgData();
            groupMsgData.lastMsgId = groupMsgsBean.lastMsgId;
            groupMsgData.lastNotHiidenMsgId = groupMsgsBean.lastNotHiidenMsgId;
            groupMsgData.lastReadMsgId = groupMsgsBean.lastReadMsgId;
            groupMsgData.unreadNum = groupMsgsBean.unreadNum;
            groupMsgData.totalMsgNum = size = super.getMsgsSize(groupMsgsBean);
            if (size <= 0) {
                groupMsgData.msgs = new ArrayList<BaseImMsg>();
                return groupMsgData;
            }
            int index = size - 50 > 0 ? size - 50 : 0;
            List msgBeans = this.getMsgs(groupMsgsBean, index, size);
            if (msgBeans == null || msgBeans.size() <= 0) {
                groupMsgData.msgs = new ArrayList<BaseImMsg>();
                return groupMsgData;
            }
            groupMsgData.msgs = new ArrayList<BaseImMsg>(msgBeans.size());
            for (BaseCImMsgBean msgBean : msgBeans) {
                BaseImMsg baseImMsg;
                if (msgBean == null || (baseImMsg = this.obtain(msgBean)) == null || this.callback == null) continue;
                groupMsgData.msgs.add(this.callback.transformMsgItem(baseImMsg.getMsgId(), baseImMsg));
            }
            return groupMsgData;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            return null;
        }
    }

    public void setCallBack(ICallBack callBack) {
        this.callback = callBack;
    }

    private BaseImMsg obtain(BaseCImMsgBean baseImMsgBean) {
        List sectionBeans;
        ArrayList<MsgSection> sections = new ArrayList<MsgSection>();
        BaseImMsgWrap imMsg = new BaseImMsgWrap();
        imMsg.setMsgState(baseImMsgBean.msgState);
        imMsg.setMsgId(baseImMsgBean.msgId);
        imMsg.setTs(baseImMsgBean.ts);
        imMsg.setCseq(baseImMsgBean.cseq);
        imMsg.setFlags(baseImMsgBean.flags);
        imMsg.setFrom(baseImMsgBean.from);
        imMsg.setCid(baseImMsgBean.cid);
        imMsg.setRole(baseImMsgBean.role);
        imMsg.setId(baseImMsgBean.id);
        imMsg.setPid(baseImMsgBean.pid);
        imMsg.setChannelName(baseImMsgBean.cname);
        imMsg.setNick(baseImMsgBean.nick);
        imMsg.setAvatarUrl(baseImMsgBean.avatar);
        imMsg.setSex(baseImMsgBean.sex);
        int sectionSize = this.getSectionSize(baseImMsgBean);
        if (sectionSize > 0 && (sectionBeans = this.getSections(baseImMsgBean, sectionSize)) != null && sectionBeans.size() > 0) {
            for (CMsgSectionBean sectionBean : sectionBeans) {
                MsgSection section = this.obtain(sectionBean);
                if (section == null) continue;
                sections.add(section);
            }
        }
        imMsg.setSections(sections);
        return imMsg;
    }

    private MsgSection obtain(CMsgSectionBean sectionBean) {
        MsgSection section = null;
        if (sectionBean != null) {
            section = new MsgSection();
            section.setColor(sectionBean.color);
            section.setContent(sectionBean.content);
            section.setExtention(sectionBean.extention);
            section.setJump(sectionBean.jump);
            section.setType(sectionBean.type);
        }
        return section;
    }

    private BaseCImMsgBean obtain(BaseImMsg imMsg) {
        int sectionSize;
        BaseCImMsgBean baseImMsgBean = new BaseCImMsgBean();
        baseImMsgBean.msgState = imMsg.getMsgState();
        baseImMsgBean.msgId = imMsg.getMsgId();
        baseImMsgBean.cseq = imMsg.getCseq();
        baseImMsgBean.flags = imMsg.getFlags();
        baseImMsgBean.cid = imMsg.getCid();
        baseImMsgBean.role = imMsg.getRole();
        baseImMsgBean.ts = imMsg.getTs();
        baseImMsgBean.from = imMsg.getFrom();
        baseImMsgBean.pid = imMsg.getPid();
        baseImMsgBean.cname = imMsg.getChannelName();
        baseImMsgBean.avatar = imMsg.getAvatarUrl();
        baseImMsgBean.sex = imMsg.getSex();
        baseImMsgBean.nick = imMsg.getNick();
        int n = sectionSize = imMsg.getSections() != null ? imMsg.getSections().size() : 0;
        if (sectionSize > 0) {
            for (MsgSection section : imMsg.getSections()) {
                CMsgSectionBean sectionBean = this.obtain(section);
                if (sectionBean == null) continue;
                super.addSection(baseImMsgBean, sectionBean);
            }
        }
        return baseImMsgBean;
    }

    private CMsgSectionBean obtain(MsgSection section) {
        CMsgSectionBean sectionBean = null;
        if (section != null) {
            sectionBean = new CMsgSectionBean();
            sectionBean.color = section.getColor();
            sectionBean.content = section.getContent();
            sectionBean.extention = section.getExtention();
            sectionBean.jump = section.getJump();
            sectionBean.type = section.getType();
        }
        return sectionBean;
    }

    public void updateGroupMsgDataNotIncludeMsg(String groupId, ChannelMsgData data) {
        ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
        if (groupMsgsBean == null) {
            return;
        }
        super.updateGroupMsgDataNotIncludeMsg(groupId, data.unreadNum, data.lastReadMsgId, data.lastMsgId, data.lastNotHiidenMsgId);
    }

    public boolean deleteMsg(String groupId, long id2) {
        if (id2 < 0L) {
            return false;
        }
        try {
            ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
            if (groupMsgsBean == null) {
                return false;
            }
            boolean result = false;
            int msgSize = super.getMsgsSize(groupMsgsBean);
            if (msgSize > 0) {
                result = super.removeMsgById(groupMsgsBean, id2);
                super.saveMsgs(groupId, groupMsgsBean);
            }
            if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"deleteMsg id:%s,result:%d", (Object[])new Object[]{id2, result ? 1 : 0});
            }
            return result;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            return false;
        }
    }

    public BaseImMsg find(String groupId, String msgid) {
        try {
            List msgBeans;
            ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
            if (groupMsgsBean == null) {
                return null;
            }
            int size = super.getMsgsSize(groupMsgsBean);
            BaseCImMsgBean item = null;
            if (size > 0 && (msgBeans = super.getMsgs(groupMsgsBean, 0, size)) != null && msgBeans.size() > 0) {
                for (int i = msgBeans.size() - 1; i >= 0; --i) {
                    item = (BaseCImMsgBean)msgBeans.get(i);
                    if (StringUtils.equal((String)item.msgId, (String)msgid)) break;
                }
            }
            if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"find cid:%s, msgId:%s,item:%s", (Object[])new Object[]{groupId, msgid, item != null ? item.toString() : ""});
            }
            if (item != null) {
                return this.obtain(item);
            }
            return null;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            return null;
        }
    }

    public List<BaseImMsg> findAll(String groupId) {
        ArrayList<BaseImMsg> msgs = new ArrayList<BaseImMsg>();
        try {
            List msgBeans;
            ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
            if (groupMsgsBean == null) {
                return null;
            }
            int size = super.getMsgsSize(groupMsgsBean);
            Object item = null;
            if (size > 0 && (msgBeans = super.getMsgs(groupMsgsBean, 0, size)) != null && !msgBeans.isEmpty()) {
                ArrayList copy = new ArrayList(msgBeans);
                for (BaseCImMsgBean msgBean : copy) {
                    msgs.add(this.obtain(msgBean));
                }
            }
            if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"find cid:%s, item:%s", (Object[])new Object[]{groupId, item != null ? item.toString() : ""});
            }
            return msgs;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            return msgs;
        }
    }

    public BaseImMsg replace(String groupId, String msgid, BaseImMsg newMsg) {
        try {
            ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
            if (groupMsgsBean == null) {
                return null;
            }
            BaseCImMsgBean item = null;
            int size = super.getMsgsSize(groupMsgsBean);
            if (size > 0) {
                List msgBeans = super.getMsgs(groupMsgsBean, 0, size);
                int index = -1;
                if (msgBeans != null && msgBeans.size() > 0) {
                    int i = msgBeans.size() - 1;
                    while (i >= 0) {
                        item = (BaseCImMsgBean)msgBeans.get(i);
                        index = i--;
                        if (StringUtils.equal((String)item.msgId, (String)msgid)) break;
                    }
                }
                if (item != null) {
                    super.removeMsg(groupMsgsBean, item);
                    super.addMsg(groupMsgsBean, index, this.obtain(newMsg));
                }
            }
            if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"replace msgId:%s,item:%d,newItem:%s", (Object[])new Object[]{msgid, item != null ? item.toString() : "", newMsg.toString()});
            }
            if (item != null) {
                this.saveMsgs(groupId, groupMsgsBean);
            }
            if (item != null) {
                return this.obtain(item);
            }
            return null;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            return null;
        }
    }

    public boolean deleteMsg(String groupId, String msgId) {
        try {
            ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
            if (groupMsgsBean == null) {
                return false;
            }
            boolean result = false;
            int size = super.getMsgsSize(groupMsgsBean);
            if (size > 0) {
                List msgBeans = super.getMsgs(groupMsgsBean, 0, size);
                BaseCImMsgBean item = null;
                if (msgBeans != null && msgBeans.size() > 0) {
                    for (int i = msgBeans.size() - 1; i >= 0; --i) {
                        item = (BaseCImMsgBean)msgBeans.get(i);
                        if (StringUtils.equal((String)item.msgId, (String)msgId)) break;
                    }
                }
                if (item != null) {
                    result = true;
                    super.removeMsg(groupMsgsBean, item);
                }
            }
            if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"deleteMsg msgId:%s,result:%d", (Object[])new Object[]{msgId, result ? 1 : 0});
            }
            if (result) {
                this.saveMsgs(groupId, groupMsgsBean);
            }
            return result;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            return false;
        }
    }

    public void updateMsg(String groupId, BaseImMsg section) {
        this.updateMsg(groupId, section, null, -1L);
    }

    public void updateMsg(String groupId, BaseImMsg section, String clientID, long uid) {
        if (section == null || section.getDBId() < 0L) {
            if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"updateMsg msg:%s,dbID:%s", (Object[])new Object[]{section != null ? section.toString() : "", String.valueOf(section.getDBId())});
            }
            return;
        }
        try {
            ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
            if (groupMsgsBean == null) {
                return;
            }
            int size = super.getMsgsSize(groupMsgsBean);
            if (size <= 0) {
                return;
            }
            int index = -1;
            if (section.getDBId() > 0L) {
                index = super.indexOfId(groupMsgsBean, section.getDBId());
            }
            if (index < 0) {
                boolean clientNotEmpty = StringUtils.isNotEmpty((String)clientID);
                List msgBeans = super.getMsgs(groupMsgsBean, 0, size);
                BaseCImMsgBean item = null;
                if (msgBeans != null && msgBeans.size() > 0) {
                    for (int i = msgBeans.size() - 1; i >= 0; --i) {
                        item = (BaseCImMsgBean)msgBeans.get(i);
                        if (clientNotEmpty && item.from == section.getFrom() && StringUtils.equal((String)item.cseq, (String)section.getCseq())) {
                            index = i;
                            break;
                        }
                        if (!StringUtils.equal((String)item.msgId, (String)section.getMsgId())) continue;
                        index = i;
                        break;
                    }
                }
            }
            if (index >= 0) {
                BaseCImMsgBean bean = this.obtain(section);
                this.removeMsgByIndex(groupMsgsBean, index);
                super.addMsg(groupMsgsBean, index, bean);
                if (bean.id > 0L) {
                    section.setId(bean.id);
                }
                this.saveMsgs(groupId, groupMsgsBean);
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void addMsg(String groupId, BaseImMsg section) {
        try {
            ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
            if (groupMsgsBean == null) {
                return;
            }
            int size = super.getMsgsSize(groupMsgsBean);
            BaseCImMsgBean bean = null;
            if (size > 0) {
                if (size > 500) {
                    if (groupMsgsBean.unreadNum <= 500L) {
                        this.removeMsgByIndex(groupMsgsBean, 0);
                    } else if ((long)size > groupMsgsBean.unreadNum) {
                        this.removeMsgByIndex(groupMsgsBean, 0);
                    } else if (size > 500) {
                        this.removeMsgByIndex(groupMsgsBean, 0);
                    }
                }
                bean = this.obtain(section);
                super.addMsg(groupMsgsBean, bean);
                section.setId(bean.id);
                this.saveMsgs(groupId, groupMsgsBean);
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public ArrayList<BaseImMsg> getMsgAheadList(String groupId, long fromID, int pullNum) {
        try {
            int end;
            ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
            if (groupMsgsBean == null || fromID < 0L) {
                return null;
            }
            int size = super.getMsgsSize(groupMsgsBean);
            if (size <= 0) {
                return null;
            }
            int findIndex = super.indexOfId(groupMsgsBean, fromID);
            if (findIndex < 0) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("cid:" + groupId + ",fromId:%s" + fromID + " not find fromID!");
                }
                return null;
            }
            int index = findIndex - pullNum < 0 ? 0 : findIndex - pullNum;
            List msgBeans = super.getMsgs(groupMsgsBean, index, end = findIndex);
            if (msgBeans == null || msgBeans.size() <= 0) {
                return null;
            }
            ArrayList<BaseImMsg> baseMsgs = new ArrayList<BaseImMsg>(msgBeans.size());
            for (BaseCImMsgBean msgBean : msgBeans) {
                BaseImMsg baseImMsg;
                if (msgBean == null || (baseImMsg = this.obtain(msgBean)) == null || this.callback == null) continue;
                baseMsgs.add(this.callback.transformMsgItem(baseImMsg.getMsgId(), baseImMsg));
            }
            return baseMsgs;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            return null;
        }
    }

    public ArrayList<BaseImMsg> getMsgAheadList(String groupId, String fromMsgID, int pullNum) {
        try {
            int end;
            ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
            if (groupMsgsBean == null || StringUtils.isEmpty((String)fromMsgID)) {
                return null;
            }
            int size = super.getMsgsSize(groupMsgsBean);
            if (size <= 0) {
                return null;
            }
            int findIndex = -1;
            List msgBeans = super.getMsgs(groupMsgsBean, 0, size);
            BaseCImMsgBean item = null;
            if (msgBeans != null && msgBeans.size() > 0) {
                for (int i = msgBeans.size() - 1; i >= 0; --i) {
                    item = (BaseCImMsgBean)msgBeans.get(i);
                    if (!StringUtils.equal((String)item.msgId, (String)fromMsgID)) continue;
                    findIndex = i;
                    break;
                }
            }
            if (findIndex < 0) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("cid:" + groupId + ",fromId:" + fromMsgID + " not find fromID!");
                }
                return null;
            }
            int index = findIndex - pullNum < 0 ? 0 : findIndex - pullNum;
            msgBeans = super.getMsgs(groupMsgsBean, index, end = findIndex);
            if (msgBeans == null || msgBeans.size() <= 0) {
                return null;
            }
            ArrayList<BaseImMsg> baseMsgs = new ArrayList<BaseImMsg>(msgBeans.size());
            for (BaseCImMsgBean msgBean : msgBeans) {
                BaseImMsg baseImMsg;
                if (msgBean == null || (baseImMsg = this.obtain(msgBean)) == null || this.callback == null) continue;
                baseMsgs.add(this.callback.transformMsgItem(baseImMsg.getMsgId(), baseImMsg));
            }
            return baseMsgs;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            return null;
        }
    }

    public ArrayList<BaseImMsg> getMsgLastList(String groupId, int pullNum) {
        try {
            ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
            if (groupMsgsBean == null) {
                return null;
            }
            int size = super.getMsgsSize(groupMsgsBean);
            if (size <= 0) {
                return null;
            }
            int index = pullNum >= size ? 0 : size - pullNum;
            List msgBeans = super.getMsgs(groupMsgsBean, index, size);
            if (msgBeans == null || msgBeans.size() <= 0) {
                return null;
            }
            ArrayList<BaseImMsg> baseMsgs = new ArrayList<BaseImMsg>(msgBeans.size());
            for (BaseCImMsgBean msgBean : msgBeans) {
                BaseImMsg baseImMsg;
                if (msgBean == null || (baseImMsg = this.obtain(msgBean)) == null || this.callback == null) continue;
                baseMsgs.add(this.callback.transformMsgItem(baseImMsg.getMsgId(), baseImMsg));
            }
            return baseMsgs;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            return null;
        }
    }

    public void loginOut() {
        super.loginOut();
    }

    public void destroy() {
        super.destroy();
    }

    public static interface ICallBack {
        public BaseImMsg transformMsgItem(String var1, BaseImMsg var2);
    }
}

