/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.bean;

import android.text.Spanned;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import biz.ChannelCarouselType;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.Base64Utils;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.bbs.base.bean.TagBean;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.CInterregion;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.bean.SameCityInfo;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import java.util.HashSet;
import java.util.Set;

@DontProguardClass
public class MyJoinChannelItem {
    private static final String TAG = "MyJoinChannelItem";
    private final Object lock = new Object();
    public String cid = "";
    public String name = "";
    public long ownerUid;
    public int roomType;
    public long time;
    public ChannelUser myRoleData;
    @Nullable
    public ChannelPluginData mPluginData;
    public long unreadMsgNum;
    public long lastReadMsgTime;
    public long lastestUnReadMsgTs;
    public int permissionRole = 1;
    public int version;
    public String channelAvatar = "";
    @SerializedName(value="lastMsgTips")
    private String lastStorageMsgTips;
    private boolean isLastTipHtml = false;
    public boolean isPrivate = false;
    @Expose
    private transient CharSequence lastShowMsgTips;
    public String cvid = "";
    public TagBean tag;
    public CInterregion region;
    public String source = "";
    public String indieGameId;
    public String indieGameName;
    public int firstType;
    public int secondType;
    public long roleCount;
    public long roleLimit;
    public SameCityInfo sameCityInfo;
    public int roomShowType = 0;
    public int carouselType = ChannelCarouselType.CCT_NONE.getValue();
    public Set<Long> videoAnchors = new HashSet<Long>();
    public String playingPid = "";
    public boolean transClient = false;

    public boolean isGroupParty() {
        return this.roomShowType == 2;
    }

    public boolean isVideoAnchor(long uid) {
        return this.videoAnchors.contains(uid);
    }

    public MyJoinChannelItem() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                MyJoinChannelItem.this.getLastMsgTips();
            }
        }, (long)500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getLastMsgTips() {
        if (this.lastShowMsgTips == null) {
            if (!TextUtils.isEmpty((CharSequence)this.lastStorageMsgTips)) {
                Object object = this.lock;
                synchronized (object) {
                    if (Base64Utils.ifBASE((String)this.lastStorageMsgTips)) {
                        this.lastStorageMsgTips = Base64Utils.getFromBase64((String)this.lastStorageMsgTips);
                    }
                    this.lastShowMsgTips = this.isLastTipHtml || this.lastStorageMsgTips.startsWith("<p dir") ? StringUtils.fromHtml((String)this.lastStorageMsgTips) : this.lastStorageMsgTips;
                }
            } else {
                this.lastShowMsgTips = this.getDefaultLastShowTips(false);
            }
        }
        return this.lastShowMsgTips;
    }

    public String getLastStorageMsgTips() {
        return this.lastStorageMsgTips;
    }

    public void setLastMsgTips(CharSequence lastMsgTips, boolean hasMsg) {
        if (lastMsgTips == null) {
            MLog.error((Object)TAG, (String)"setLastMsgTips cid: %s, name: %s", (Object[])new Object[]{this.cid, this.name});
            lastMsgTips = this.getDefaultLastShowTips(hasMsg);
        }
        this.isLastTipHtml = false;
        this.lastShowMsgTips = lastMsgTips;
        if (lastMsgTips instanceof String) {
            this.lastStorageMsgTips = (String)lastMsgTips;
        } else if (lastMsgTips instanceof Spanned) {
            final CharSequence finalLastMsgTips = lastMsgTips;
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    MyJoinChannelItem.this.isLastTipHtml = true;
                    String html = StringUtils.toHtml((Spanned)((Spanned)finalLastMsgTips));
                    html = html.replaceAll("<br>", "");
                    html = html.replaceAll("</br>", "");
                    html = html.replaceAll("\\n\\r", "");
                    MyJoinChannelItem.this.lastStorageMsgTips = Base64Utils.getBase64((String)html);
                }
            });
        } else if (RuntimeContext.sIsDebuggable) {
            throw new IllegalArgumentException("lastMsgTips is illegal " + lastMsgTips.getClass());
        }
    }

    private String getDefaultLastShowTips(boolean hasMsg) {
        if (this.version == 0 || hasMsg) {
            return ResourceUtils.getString((int)R.string.tips_new_unread_channel_msg);
        }
        return "";
    }

    public String toString() {
        if (ChannelDefine.sUnEnableLog) {
            return "";
        }
        return "MyJoinChannelItem{cid='" + this.cid + '\'' + ", name='" + this.name + '\'' + ", ownerUid='" + this.ownerUid + '\'' + ", roomType='" + this.roomType + '\'' + ", time='" + this.time + '\'' + ", unreadMsgNum='" + this.unreadMsgNum + '\'' + ", lastReadMsgTime='" + this.lastReadMsgTime + '\'' + ", lastestUnReadMsgTs='" + this.lastestUnReadMsgTs + '\'' + ", msgReceiveMode='" + (this.myRoleData != null ? this.myRoleData.msgReceiveMode : 1) + '\'' + ", roleType='" + (this.myRoleData != null ? this.myRoleData.roleType : -1) + '\'' + ", pluginData='" + (Object)((Object)this.mPluginData) + '\'' + ", version='" + this.version + '\'' + ", source='" + this.source + '\'' + '}';
    }

    public boolean isFamily() {
        return "hago.family".equals(this.source);
    }

    public boolean isCrawler() {
        return "crawler".equals(this.source);
    }

    public void setPlayingPid(String playingPid) {
    }
}

