/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base;

import androidx.lifecycle.MutableLiveData;
import com.squareup.wire.AndroidMessage;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.ChannelLabelBox;
import com.yy.hiyo.channel.base.ChannelLabelBoxKt;
import com.yy.hiyo.channel.base.bean.ActivityLabel;
import com.yy.hiyo.channel.base.bean.RrecTagMeta;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.room.api.rrec.GetAllLabelMetasReq;
import net.ihago.room.api.rrec.GetAllLabelMetasRes;
import net.ihago.room.api.rrec.Label;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00050\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u0012\u001a\u00020\u0010H\u0002J0\u0010\u0013\u001a\u00020\u00102\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0016j\b\u0012\u0004\u0012\u00020\f`\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/yy/hiyo/channel/base/ChannelLabelBox;", "", "()V", "getLabelList", "Landroidx/lifecycle/MutableLiveData;", "", "Lcom/yy/hiyo/channel/base/bean/ActivityLabel;", "getLabelUrl", "", "id", "", "getTagConfig", "Lcom/yy/hiyo/channel/base/bean/RrecTagMeta;", "", "getTagList", "getTasksConfig", "", "initConfig", "loadFromLocal", "saveToFile", "data", "tagList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "channel-base_release"})
public final class ChannelLabelBox {
    public static final ChannelLabelBox INSTANCE;

    @NotNull
    public final MutableLiveData<List<ActivityLabel>> getLabelList() {
        return ChannelLabelBoxKt.access$getLabelList$p();
    }

    @NotNull
    public final MutableLiveData<List<RrecTagMeta>> getTagList() {
        return ChannelLabelBoxKt.access$getTagList$p();
    }

    public final void initConfig() {
        if (ChannelLabelBoxKt.access$getHasLoadTasksConfig$p()) {
            return;
        }
        ChannelLabelBoxKt.access$setHasLoadTasksConfig$p(true);
        this.loadFromLocal();
        YYTaskExecutor.postToMainThread((Runnable)initConfig.1.INSTANCE, (long)5000L);
    }

    @NotNull
    public final String getLabelUrl(int id2) {
        String label = "";
        List list = (List)ChannelLabelBoxKt.access$getLabelList$p().getValue();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ActivityLabel it = (ActivityLabel)element$iv;
                boolean bl = false;
                if (it.getId() != id2) continue;
                label = it.getUrl();
                return label;
            }
        }
        return label;
    }

    @Nullable
    public final RrecTagMeta getTagConfig(long id2) {
        List list = (List)ChannelLabelBoxKt.access$getTagList$p().getValue();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RrecTagMeta it = (RrecTagMeta)element$iv;
                boolean bl = false;
                if (it.getId() != id2) continue;
                return it;
            }
        }
        return null;
    }

    private final void getTasksConfig() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"ChannelLabelBox", (String)"getTasksConfig", (Object[])new Object[0]);
        }
        GetAllLabelMetasReq req = new GetAllLabelMetasReq.Builder().build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetAllLabelMetasRes>(){

            public boolean retryWhenTimeout(boolean canRetry) {
                ChannelLabelBoxKt.access$setHasLoadTasksConfig$p(false);
                return true;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                ChannelLabelBoxKt.access$setHasLoadTasksConfig$p(false);
                return true;
            }

            public void onResponse(@NotNull GetAllLabelMetasRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"ChannelLabelBox", (String)("getTasksConfig onResponse code:" + code + " size:" + message.labels.size()), (Object[])new Object[0]);
                }
                if (ProtoManager.isSuccessCode((long)code)) {
                    ArrayList<ActivityLabel> list = new ArrayList<ActivityLabel>();
                    ArrayList<RrecTagMeta> tags = new ArrayList<RrecTagMeta>();
                    List list2 = message.labels;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"message.labels");
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Label msgItem = (Label)element$iv;
                        boolean bl = false;
                        Integer n = msgItem.id;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"msgItem.id");
                        int n2 = n;
                        String string2 = msgItem.url;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"msgItem.url");
                        list.add(new ActivityLabel(n2, string2));
                    }
                    List list3 = message.tags;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"message.tags");
                    $this$forEach$iv = list3;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        net.ihago.room.api.rrec.RrecTagMeta it = (net.ihago.room.api.rrec.RrecTagMeta)element$iv;
                        boolean bl = false;
                        Long l = it.id;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"it.id");
                        long l2 = l;
                        String string3 = it.icon_url;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.icon_url");
                        Map map = it.icon_msg;
                        String string4 = it.cover;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it.cover");
                        tags.add(new RrecTagMeta(l2, string3, map, string4));
                    }
                    ChannelLabelBoxKt.access$getLabelList$p().setValue(list);
                    ChannelLabelBoxKt.access$getTagList$p().setValue(tags);
                    ChannelLabelBox.access$saveToFile(ChannelLabelBox.INSTANCE, list, tags);
                }
            }

            public boolean needToken() {
                return true;
            }
        });
    }

    private final void saveToFile(List<ActivityLabel> data, ArrayList<RrecTagMeta> tagList2) {
        if (MLog.isLogLevelBlowInfo()) {
            List<ActivityLabel> list = data;
            MLog.info((Object)"ChannelLabelBox", (String)("saveToFile data = " + (list != null ? Integer.valueOf(list.size()) : null) + "\uff0c tagList = " + tagList2.size()), (Object[])new Object[0]);
        }
        YYTaskExecutor.execute((Runnable)new Runnable(data, tagList2){
            final /* synthetic */ List $data;
            final /* synthetic */ ArrayList $tagList;

            public final void run() {
                String fileData = JsonParser.toJson((Object)this.$data);
                String tagFile = JsonParser.toJson((Object)this.$tagList);
                FileStorageUtils.getInstance().saveToFile(true, tagFile, "video_list_task");
                FileStorageUtils.getInstance().saveToFile(true, fileData, "room_list_task");
            }
            {
                this.$data = list;
                this.$tagList = arrayList;
            }
        });
    }

    private final void loadFromLocal() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"ChannelLabelBox", (String)"loadFromLocal", (Object[])new Object[0]);
        }
        YYTaskExecutor.execute((Runnable)loadFromLocal.1.INSTANCE);
    }

    private ChannelLabelBox() {
    }

    static {
        ChannelLabelBox channelLabelBox;
        INSTANCE = channelLabelBox = new ChannelLabelBox();
    }

    public static final /* synthetic */ void access$getTasksConfig(ChannelLabelBox $this) {
        $this.getTasksConfig();
    }

    public static final /* synthetic */ void access$saveToFile(ChannelLabelBox $this, List data, ArrayList tagList2) {
        $this.saveToFile(data, tagList2);
    }
}

