/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera.utils.cropper.cropwindow.edge;

import android.graphics.Rect;
import android.view.View;
import com.yy.hiyo.camera.camera.utils.cropper.util.a;

public enum Edge {
    LEFT,
    TOP,
    RIGHT,
    BOTTOM;

    public static final int MIN_CROP_LENGTH_PX = 40;
    private float mCoordinate;

    public void setCoordinate(float f2) {
        this.mCoordinate = f2;
    }

    public void offset(float f2) {
        this.mCoordinate += f2;
    }

    public float getCoordinate() {
        return this.mCoordinate;
    }

    public void adjustCoordinate(float f2, float f3, Rect rect, float f4, float f5) {
        switch (this) {
            case LEFT: {
                this.mCoordinate = Edge.adjustLeft(f2, rect, f4, f5);
                break;
            }
            case TOP: {
                this.mCoordinate = Edge.adjustTop(f3, rect, f4, f5);
                break;
            }
            case RIGHT: {
                this.mCoordinate = Edge.adjustRight(f2, rect, f4, f5);
                break;
            }
            case BOTTOM: {
                this.mCoordinate = Edge.adjustBottom(f3, rect, f4, f5);
                break;
            }
        }
    }

    public void adjustCoordinate(float f2) {
        float f3 = LEFT.getCoordinate();
        float f4 = TOP.getCoordinate();
        float f5 = RIGHT.getCoordinate();
        float f6 = BOTTOM.getCoordinate();
        switch (this) {
            case LEFT: {
                this.mCoordinate = a.b(f4, f5, f6, f2);
                break;
            }
            case TOP: {
                this.mCoordinate = a.c(f3, f5, f6, f2);
                break;
            }
            case RIGHT: {
                this.mCoordinate = a.d(f3, f4, f6, f2);
                break;
            }
            case BOTTOM: {
                this.mCoordinate = a.e(f3, f4, f5, f2);
                break;
            }
        }
    }

    public boolean isNewRectangleOutOfBounds(Edge edge, Rect rect, float f2) {
        float f3 = edge.snapOffset(rect);
        switch (this) {
            case LEFT: {
                if (edge.equals((Object)TOP)) {
                    float f4 = rect.top;
                    float f5 = BOTTOM.getCoordinate() - f3;
                    float f6 = RIGHT.getCoordinate();
                    float f7 = a.b(f4, f6, f5, f2);
                    return this.isOutOfBounds(f4, f7, f5, f6, rect);
                }
                if (!edge.equals((Object)BOTTOM)) break;
                float f8 = rect.bottom;
                float f9 = TOP.getCoordinate() - f3;
                float f10 = RIGHT.getCoordinate();
                float f11 = a.b(f9, f10, f8, f2);
                return this.isOutOfBounds(f9, f11, f8, f10, rect);
            }
            case TOP: {
                if (edge.equals((Object)LEFT)) {
                    float f12 = rect.left;
                    float f13 = RIGHT.getCoordinate() - f3;
                    float f14 = BOTTOM.getCoordinate();
                    float f15 = a.c(f12, f13, f14, f2);
                    return this.isOutOfBounds(f15, f12, f14, f13, rect);
                }
                if (!edge.equals((Object)RIGHT)) break;
                float f16 = rect.right;
                float f17 = LEFT.getCoordinate() - f3;
                float f18 = BOTTOM.getCoordinate();
                float f19 = a.c(f17, f16, f18, f2);
                return this.isOutOfBounds(f19, f17, f18, f16, rect);
            }
            case RIGHT: {
                if (edge.equals((Object)TOP)) {
                    float f20 = rect.top;
                    float f21 = BOTTOM.getCoordinate() - f3;
                    float f22 = LEFT.getCoordinate();
                    float f23 = a.d(f22, f20, f21, f2);
                    return this.isOutOfBounds(f20, f22, f21, f23, rect);
                }
                if (!edge.equals((Object)BOTTOM)) break;
                float f24 = rect.bottom;
                float f25 = TOP.getCoordinate() - f3;
                float f26 = LEFT.getCoordinate();
                float f27 = a.d(f26, f25, f24, f2);
                return this.isOutOfBounds(f25, f26, f24, f27, rect);
            }
            case BOTTOM: {
                if (edge.equals((Object)LEFT)) {
                    float f28 = rect.left;
                    float f29 = RIGHT.getCoordinate() - f3;
                    float f30 = TOP.getCoordinate();
                    float f31 = a.e(f28, f30, f29, f2);
                    return this.isOutOfBounds(f30, f28, f31, f29, rect);
                }
                if (!edge.equals((Object)RIGHT)) break;
                float f32 = rect.right;
                float f33 = LEFT.getCoordinate() - f3;
                float f34 = TOP.getCoordinate();
                float f35 = a.e(f33, f34, f32, f2);
                return this.isOutOfBounds(f34, f33, f35, f32, rect);
            }
        }
        return true;
    }

    private boolean isOutOfBounds(float f2, float f3, float f4, float f5, Rect rect) {
        return f2 < (float)rect.top || f3 < (float)rect.left || f4 > (float)rect.bottom || f5 > (float)rect.right;
    }

    public float snapToRect(Rect rect) {
        float f2 = this.mCoordinate;
        switch (this) {
            case LEFT: {
                this.mCoordinate = rect.left;
                break;
            }
            case TOP: {
                this.mCoordinate = rect.top;
                break;
            }
            case RIGHT: {
                this.mCoordinate = rect.right;
                break;
            }
            case BOTTOM: {
                this.mCoordinate = rect.bottom;
                break;
            }
        }
        float f3 = this.mCoordinate - f2;
        return f3;
    }

    public float snapOffset(Rect rect) {
        float f2;
        float f3 = f2 = this.mCoordinate;
        switch (this) {
            case LEFT: {
                f3 = rect.left;
                break;
            }
            case TOP: {
                f3 = rect.top;
                break;
            }
            case RIGHT: {
                f3 = rect.right;
                break;
            }
            case BOTTOM: {
                f3 = rect.bottom;
                break;
            }
        }
        float f4 = f3 - f2;
        return f4;
    }

    public void snapToView(View view) {
        switch (this) {
            case LEFT: {
                this.mCoordinate = 0.0f;
                break;
            }
            case TOP: {
                this.mCoordinate = 0.0f;
                break;
            }
            case RIGHT: {
                this.mCoordinate = view.getWidth();
                break;
            }
            case BOTTOM: {
                this.mCoordinate = view.getHeight();
                break;
            }
        }
    }

    public static float getWidth() {
        return RIGHT.getCoordinate() - LEFT.getCoordinate();
    }

    public static float getHeight() {
        return BOTTOM.getCoordinate() - TOP.getCoordinate();
    }

    public boolean isOutsideMargin(Rect rect, float f2) {
        boolean bl = false;
        switch (this) {
            case LEFT: {
                bl = this.mCoordinate - (float)rect.left < f2;
                break;
            }
            case TOP: {
                bl = this.mCoordinate - (float)rect.top < f2;
                break;
            }
            case RIGHT: {
                bl = (float)rect.right - this.mCoordinate < f2;
                break;
            }
            case BOTTOM: {
                bl = (float)rect.bottom - this.mCoordinate < f2;
                break;
            }
        }
        return bl;
    }

    public boolean isOutsideFrame(Rect rect) {
        double d2 = 0.0;
        boolean bl = false;
        switch (this) {
            case LEFT: {
                bl = (double)(this.mCoordinate - (float)rect.left) < d2;
                break;
            }
            case TOP: {
                bl = (double)(this.mCoordinate - (float)rect.top) < d2;
                break;
            }
            case RIGHT: {
                bl = (double)((float)rect.right - this.mCoordinate) < d2;
                break;
            }
            case BOTTOM: {
                bl = (double)((float)rect.bottom - this.mCoordinate) < d2;
                break;
            }
        }
        return bl;
    }

    private static float adjustLeft(float f2, Rect rect, float f3, float f4) {
        float f5 = f2;
        if (f2 - (float)rect.left < f3) {
            f5 = rect.left;
        } else {
            float f6 = Float.POSITIVE_INFINITY;
            float f7 = Float.POSITIVE_INFINITY;
            if (f2 >= RIGHT.getCoordinate() - 40.0f) {
                f6 = RIGHT.getCoordinate() - 40.0f;
            }
            if ((RIGHT.getCoordinate() - f2) / f4 <= 40.0f) {
                f7 = RIGHT.getCoordinate() - 40.0f * f4;
            }
            f5 = Math.min(f5, Math.min(f6, f7));
        }
        return f5;
    }

    private static float adjustRight(float f2, Rect rect, float f3, float f4) {
        float f5 = f2;
        if ((float)rect.right - f2 < f3) {
            f5 = rect.right;
        } else {
            float f6 = Float.NEGATIVE_INFINITY;
            float f7 = Float.NEGATIVE_INFINITY;
            if (f2 <= LEFT.getCoordinate() + 40.0f) {
                f6 = LEFT.getCoordinate() + 40.0f;
            }
            if ((f2 - LEFT.getCoordinate()) / f4 <= 40.0f) {
                f7 = LEFT.getCoordinate() + 40.0f * f4;
            }
            f5 = Math.max(f5, Math.max(f6, f7));
        }
        return f5;
    }

    private static float adjustTop(float f2, Rect rect, float f3, float f4) {
        float f5 = f2;
        if (f2 - (float)rect.top < f3) {
            f5 = rect.top;
        } else {
            float f6 = Float.POSITIVE_INFINITY;
            float f7 = Float.POSITIVE_INFINITY;
            if (f2 >= BOTTOM.getCoordinate() - 40.0f) {
                f7 = BOTTOM.getCoordinate() - 40.0f;
            }
            if ((BOTTOM.getCoordinate() - f2) * f4 <= 40.0f) {
                f6 = BOTTOM.getCoordinate() - 40.0f / f4;
            }
            f5 = Math.min(f5, Math.min(f7, f6));
        }
        return f5;
    }

    private static float adjustBottom(float f2, Rect rect, float f3, float f4) {
        float f5 = f2;
        if ((float)rect.bottom - f2 < f3) {
            f5 = rect.bottom;
        } else {
            float f6 = Float.NEGATIVE_INFINITY;
            float f7 = Float.NEGATIVE_INFINITY;
            if (f2 <= TOP.getCoordinate() + 40.0f) {
                f6 = TOP.getCoordinate() + 40.0f;
            }
            if ((f2 - TOP.getCoordinate()) * f4 <= 40.0f) {
                f7 = TOP.getCoordinate() + 40.0f / f4;
            }
            f5 = Math.max(f5, Math.max(f7, f6));
        }
        return f5;
    }
}

