/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.text.Layout;
import android.text.StaticLayout;
import android.widget.TextView;
import androidx.lifecycle.LifecycleOwner;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.data.WealthDataService;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page.AbsPreparePanelPage;
import java.util.LinkedList;
import java.util.List;

public class ReadyPanelPage
extends AbsPreparePanelPage {
    private PageCallback mCallback;
    private Runnable mRuleFlipperSwitchRunable;
    private int mNextRuleTextIndex = 0;
    private List<String> mRuleTextList = new LinkedList<String>();

    public void setCallback(PageCallback callback) {
        this.mCallback = callback;
    }

    @Override
    protected void onInitViews() {
        boolean isRoomOwner = WealthDataService.INSTANCE.getWealthDataModel().isRoomOwner();
        this.mTvTips.setVisibility(8);
        this.mRuleTextSwitcher.setVisibility(0);
        this.mReadyBtn.setVisibility(0);
        this.mReadyBtn.setOnClickListener(v -> {
            if (this.mCallback == null) {
                return;
            }
            Boolean readyRequesting = (Boolean)WealthDataService.INSTANCE.getWealthDataModel().getReadyRequestingData().getValue();
            if (readyRequesting != null && readyRequesting.booleanValue()) {
                return;
            }
            Boolean hasReady = (Boolean)WealthDataService.INSTANCE.getWealthDataModel().getSelfJoinStatus().getValue();
            if (hasReady != null && hasReady.booleanValue()) {
                this.mCallback.onCancelReadyClick();
            } else {
                this.mCallback.onReadyClick();
            }
        });
        this.mStartBtn.setVisibility(isRoomOwner ? 0 : 8);
        if (isRoomOwner) {
            this.mStartBtn.setOnClickListener(v -> {
                if (this.mCallback == null) {
                    return;
                }
                Boolean startRequesting = (Boolean)WealthDataService.INSTANCE.getWealthDataModel().getStartRequestingData().getValue();
                if (startRequesting != null && startRequesting.booleanValue()) {
                    return;
                }
                Boolean canStart = (Boolean)WealthDataService.INSTANCE.getWealthDataModel().getCanStart().getValue();
                if (canStart != null && canStart.booleanValue()) {
                    this.mCallback.onStartClick();
                } else {
                    ToastUtils.showToast((Context)v.getContext(), (int)R.string.tips_bocai_not_enough_player);
                }
            });
        }
        this.initRuleFlipper();
        this.initObservers();
    }

    private void initObservers() {
        WealthDataService.INSTANCE.getWealthDataModel().getSelfJoinStatus().observe((LifecycleOwner)this.mLifeCycleOwner, joined -> {
            if (joined != null && joined.booleanValue()) {
                this.mReadyBtn.setText(R.string.btn_bocai_cancel_ready);
            } else {
                this.mReadyBtn.setText(R.string.btn_bocai_ready);
            }
        });
        WealthDataService.INSTANCE.getWealthDataModel().getReadyRequestingData().observe((LifecycleOwner)this.mLifeCycleOwner, result -> {
            if (result != null && result.booleanValue()) {
                this.mReadyBtn.setLoading(true);
            } else {
                this.mReadyBtn.setLoading(false);
            }
        });
        boolean isRoomOwner = WealthDataService.INSTANCE.getWealthDataModel().isRoomOwner();
        if (isRoomOwner) {
            WealthDataService.INSTANCE.getWealthDataModel().getCanStart().observe((LifecycleOwner)this.mLifeCycleOwner, canStart -> {
                if (this.mStartBtn.getBackground() instanceof GradientDrawable) {
                    if (canStart != null && canStart.booleanValue()) {
                        this.mStartBtn.setTextColor(-1);
                        this.mStartBtn.setBackgroundResource(R.drawable.shape_bocai_start_btn);
                    } else {
                        this.mStartBtn.setBackgroundResource(R.drawable.shape_bocai_start_btn_diable);
                        this.mStartBtn.setTextColor(Color.parseColor((String)"#4CFFFFFF"));
                    }
                }
            });
            WealthDataService.INSTANCE.getWealthDataModel().getStartRequestingData().observe((LifecycleOwner)this.mLifeCycleOwner, result -> {
                if (result != null && result.booleanValue()) {
                    this.mStartBtn.setLoading(true);
                } else {
                    this.mStartBtn.setLoading(false);
                }
            });
        }
    }

    private void initRuleFlipper() {
        this.mRuleTextList.clear();
        this.mRuleTextList.addAll(this.splitRuleText(ResourceUtils.getString((int)R.string.tips_bocai_rule_flipper, (Object[])new Object[]{WealthDataService.INSTANCE.getWealthDataModel().getMaxDiamond()})));
        this.mNextRuleTextIndex = 0;
        this.ruleFlipperSwitch();
    }

    private List<String> splitRuleText(String ruleText) {
        LinkedList<String> strList = new LinkedList<String>();
        if (!(this.mRuleTextSwitcher.getChildAt(0) instanceof TextView)) {
            return strList;
        }
        TextView textView = (TextView)this.mRuleTextSwitcher.getChildAt(0);
        int width = ResolutionUtils.getScreenWidth((Context)this.mRuleTextSwitcher.getContext()) - ResolutionUtils.dip2Px((float)60.0f);
        StaticLayout staticLayout = new StaticLayout((CharSequence)ruleText, textView.getPaint(), width, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
        for (int i = 0; i < staticLayout.getLineCount(); ++i) {
            int start = staticLayout.getLineStart(i);
            int end = staticLayout.getLineEnd(i);
            strList.add(ruleText.substring(start, end));
        }
        return strList;
    }

    private void ruleFlipperSwitch() {
        if (this.mRuleTextList.size() == 0) {
            return;
        }
        if (this.mNextRuleTextIndex < 0 || this.mNextRuleTextIndex >= this.mRuleTextList.size()) {
            return;
        }
        if (this.mRuleTextSwitcher == null) {
            return;
        }
        String text = this.mRuleTextList.get(this.mNextRuleTextIndex);
        this.mRuleTextSwitcher.setText((CharSequence)text);
        this.mNextRuleTextIndex = (this.mNextRuleTextIndex + 1) % this.mRuleTextList.size();
        if (this.mRuleFlipperSwitchRunable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRuleFlipperSwitchRunable);
        }
        this.mRuleFlipperSwitchRunable = () -> this.ruleFlipperSwitch();
        YYTaskExecutor.postToMainThread((Runnable)this.mRuleFlipperSwitchRunable, (long)3000L);
    }

    @Override
    protected void onRemoveViews() {
        if (this.mRuleFlipperSwitchRunable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRuleFlipperSwitchRunable);
        }
        this.mRuleFlipperSwitchRunable = null;
    }

    public static interface PageCallback {
        public void onReadyClick();

        public void onCancelReadyClick();

        public void onStartClick();
    }
}

