/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.data.model;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.featurelog.FeatureLog;
import com.yy.hiyo.channel.base.bean.SeatData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.plugins.bocai.data.bean.GameResultInfo;
import com.yy.hiyo.channel.plugins.bocai.data.bean.WealthConfigData;
import com.yy.hiyo.channel.plugins.bocai.seat.bean.WealthSeatItem;
import java.util.ArrayList;
import java.util.List;

public class WealthDataModel {
    private int minMember;
    private int maxMember;
    private List<Long> currentJoinMemberList = new ArrayList<Long>();
    private long recordId;
    private WealthConfigData mConfigData;
    private MutableLiveData<Boolean> mSelfJoin = new MutableLiveData();
    private List<GameResultInfo> mGameResultInfoList = new ArrayList<GameResultInfo>();
    private IChannel mRoomData;
    private MutableLiveData<Boolean> mCanStart = new MutableLiveData();
    private int mGameStatus;
    private int mMaxDiamond;
    private long mResultBeginTime;
    private MutableLiveData<WealthSeatItem> mSeatInfoLiveData = new MutableLiveData();
    private MutableLiveData<Integer> mSeatPrepareIndexData = new MutableLiveData();
    private MutableLiveData<Boolean> mStartRequestingData = new MutableLiveData();
    private MutableLiveData<Boolean> mReadRequestingData = new MutableLiveData();

    public WealthDataModel() {
        this.mCanStart.setValue((Object)false);
    }

    public int getMinMember() {
        return this.minMember;
    }

    public void setMemberLimit(int min, int max) {
        this.maxMember = max;
        this.minMember = min;
    }

    public boolean isRoomOwner() {
        if (this.mRoomData == null) {
            return false;
        }
        return this.mRoomData.getSeatService().isInFirstSeat(AccountUtil.getUid());
    }

    public int getMaxMember() {
        return this.maxMember;
    }

    public WealthConfigData getConfigData() {
        return this.mConfigData;
    }

    public void setConfigData(WealthConfigData data) {
        this.mConfigData = data;
    }

    public void setRecordId(long id2) {
        this.recordId = id2;
    }

    public long getRecordId() {
        return this.recordId;
    }

    public void setCurrentJoinMembers(List<Long> uids) {
        this.currentJoinMemberList.clear();
        if (uids != null) {
            this.currentJoinMemberList.addAll(uids);
        }
        if (this.currentJoinMemberList.size() > 0) {
            this.mCanStart.setValue((Object)true);
        } else {
            this.mCanStart.setValue((Object)false);
        }
    }

    public List<Long> getCurrentJoinMemberList() {
        return this.currentJoinMemberList;
    }

    public LiveData<Boolean> getSelfJoinStatus() {
        return this.mSelfJoin;
    }

    public void setSelfJoin(boolean isJoin) {
        if (this.mSelfJoin != null) {
            this.mSelfJoin.setValue((Object)isJoin);
        }
    }

    public void setGameResult(List<GameResultInfo> memberInfos) {
        this.mGameResultInfoList.clear();
        this.mGameResultInfoList.addAll(memberInfos);
    }

    public List<GameResultInfo> getGameResult() {
        return this.mGameResultInfoList;
    }

    public void setRoomData(IChannel roomData) {
        this.mRoomData = roomData;
    }

    public SeatData getSeatData() {
        if (this.mRoomData == null || this.mRoomData.getSeatService().getSeatData() == null) {
            return null;
        }
        return this.mRoomData.getSeatService().getSeatData();
    }

    public String getRoomId() {
        if (this.mRoomData == null) {
            return "";
        }
        return this.mRoomData.getChannelId();
    }

    public void setGameStatus(int gameStatus) {
        this.mGameStatus = gameStatus;
        FeatureLog.d((String)"FTWealth", (String)"setGameStatus:%s", (Object[])new Object[]{gameStatus});
    }

    public int getGameStatus() {
        return this.mGameStatus;
    }

    public boolean isInSeat(long uid) {
        if (this.mRoomData == null) {
            return false;
        }
        return this.mRoomData.getSeatService().getSeatData().isInSeat(uid);
    }

    public void setMaxDiamond(int diamond) {
        this.mMaxDiamond = diamond;
    }

    public int getMaxDiamond() {
        return this.mMaxDiamond;
    }

    public boolean isFullSeat() {
        if (this.mRoomData == null || this.mRoomData.getSeatService().getSeatData() == null) {
            return true;
        }
        return this.mRoomData.getSeatService().getSeatData().isSeatFullWithLocked();
    }

    public void setResultBeginTime(long resultBeginTime) {
        this.mResultBeginTime = resultBeginTime;
    }

    public long getResultBeginTime() {
        return this.mResultBeginTime;
    }

    public LiveData<Boolean> getCanStart() {
        return this.mCanStart;
    }

    public LiveData<WealthSeatItem> getWealthSeatItemLiveData() {
        return this.mSeatInfoLiveData;
    }

    public void setWealthSeatItemLiveData(WealthSeatItem wealthSeatItem) {
        this.mSeatInfoLiveData.setValue((Object)wealthSeatItem);
    }

    public LiveData<Integer> getPrepareIndex() {
        return this.mSeatPrepareIndexData;
    }

    public void setSeatPrepareIndex(int index) {
        this.mSeatPrepareIndexData.setValue((Object)index);
    }

    public void setStartRequestingData(boolean status) {
        this.mStartRequestingData.setValue((Object)status);
    }

    public LiveData<Boolean> getStartRequestingData() {
        return this.mStartRequestingData;
    }

    public void setReadyRequestingData(boolean status) {
        this.mReadRequestingData.setValue((Object)status);
    }

    public LiveData<Boolean> getReadyRequestingData() {
        return this.mReadRequestingData;
    }
}

