/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.seat;

import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.tools.ISeatLocationProvider;
import com.yy.hiyo.channel.component.seat.SeatLocationPresenter;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.seatview.NormalSeatViewWrapper;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.data.WealthDataService;
import com.yy.hiyo.channel.plugins.bocai.data.bean.GameResultInfo;
import com.yy.hiyo.channel.plugins.bocai.seat.ISeatViewManager;
import com.yy.hiyo.channel.plugins.bocai.seat.WealthSeatItemHolder;
import com.yy.hiyo.channel.plugins.bocai.seat.bean.WealthSeatItem;
import com.yy.hiyo.channel.plugins.bocai.ui.view.animation.AnimationManager;
import com.yy.hiyo.channel.plugins.voiceroom.AbsRoomPage;
import com.yy.hiyo.mvp.base.SimpleLifeCycleOwner;
import java.util.ArrayList;
import java.util.List;
import me.drakeet.multitype.ItemViewBinder;

public class WealthSeatPresenter
extends SeatPresenter<NormalSeatViewWrapper>
implements ISeatViewManager,
AnimationManager.ISeatAnimationCallback {
    private SimpleLifeCycleOwner mLifeCycleOwner = new SimpleLifeCycleOwner();
    private IGameResultAnimationCallback mCallback;
    private List<WealthSeatItem> mWealthSeatItems = new ArrayList<WealthSeatItem>();
    private AnimationManager mAnimationManager;
    private boolean mIsFromResume = false;
    private List<GameResultInfo> mResultGameList = new ArrayList<GameResultInfo>();
    private IChannelPageContext mRoomPageContext;
    private int mCurrentMaxDiamond = -1;

    @Override
    public void initAdapter(IChannelPageContext roomPageContext) {
        this.mAnimationManager = new AnimationManager(roomPageContext, this);
        if (roomPageContext == null) {
            return;
        }
        this.mRoomPageContext = roomPageContext;
        FeatureLog.i((String)"FTWealthRoomPageContext", (String)"SeatViewManager roomPageContext hashCode:%s", (Object[])new Object[]{this.mRoomPageContext.hashCode()});
        if (this.mRoomPageContext.isDestroy()) {
            FeatureLog.i((String)"FTWealth", (String)"SeatViewManager roomPageContext destroy", (Object[])new Object[0]);
            return;
        }
    }

    @Override
    public void updateSeat(List<Long> memberList) {
        if (this.mRoomPageContext.isDestroy()) {
            FeatureLog.i((String)"FTWealth", (String)"updateSeat roomPageContext destroy", (Object[])new Object[0]);
            return;
        }
        if (this.mSeatViewWrapper == null) {
            FeatureLog.e((String)"FTWealth", (String)"updateSeat seatview wrapper is null!", (Object[])new Object[0]);
            return;
        }
        this.mWealthSeatItems.clear();
        List wealthSeatItemList = ((NormalSeatViewWrapper)this.mSeatViewWrapper).getAdapter().getItems();
        if (wealthSeatItemList.size() > 0 && !(wealthSeatItemList.get(0) instanceof WealthSeatItem)) {
            FeatureLog.i((String)"FTWealth", (String)"updateSeat type not right:%s", (Object[])new Object[]{wealthSeatItemList});
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("updateSeat type not right");
            }
            return;
        }
        ArrayList tempDataList = new ArrayList();
        int size = wealthSeatItemList.size();
        for (int i = 0; i < size; ++i) {
            if (!(wealthSeatItemList.get(i) instanceof WealthSeatItem)) continue;
            tempDataList.add(wealthSeatItemList.get(i));
        }
        if (memberList == null || memberList.size() == 0) {
            for (WealthSeatItem seatItem : tempDataList) {
                if (seatItem == null) continue;
                seatItem.setDiamond(0);
                seatItem.setReady(false);
                tempDataList.set(tempDataList.indexOf((Object)seatItem), seatItem);
                this.mWealthSeatItems.add(seatItem);
            }
            FeatureLog.i((String)"FTWealth", (String)"memberList null update seat:%s", (Object[])new Object[]{wealthSeatItemList});
            ((NormalSeatViewWrapper)this.mSeatViewWrapper).getAdapter().notifyDataSetChanged();
            return;
        }
        for (WealthSeatItem seatItem : tempDataList) {
            if (seatItem == null) continue;
            seatItem.setDiamond(0);
            seatItem.setReady(false);
            if (memberList.contains(seatItem.uid)) {
                seatItem.setReady(true);
                tempDataList.set(tempDataList.indexOf((Object)seatItem), seatItem);
                this.mWealthSeatItems.add(seatItem);
                continue;
            }
            tempDataList.set(tempDataList.indexOf((Object)seatItem), seatItem);
            this.mWealthSeatItems.add(seatItem);
        }
        FeatureLog.i((String)"FTWealth", (String)"update seat:%s", (Object[])new Object[]{tempDataList});
        ((NormalSeatViewWrapper)this.mSeatViewWrapper).getAdapter().notifyDataSetChanged();
    }

    @Override
    public void destroy() {
        FeatureLog.i((String)"FTWealth", (String)"SeatViewManager destroy", (Object[])new Object[0]);
        if (this.mRoomPageContext.isDestroy()) {
            FeatureLog.i((String)"FTWealth", (String)"destroy roomPageContext destroy", (Object[])new Object[0]);
            return;
        }
        this.mAnimationManager.clear();
        this.mWealthSeatItems.clear();
        WealthDataService.INSTANCE.getWealthDataModel().setWealthSeatItemLiveData(null);
        this.mLifeCycleOwner.onEvent(Lifecycle.Event.ON_PAUSE);
        this.mLifeCycleOwner.onEvent(Lifecycle.Event.ON_STOP);
        this.mLifeCycleOwner.onEvent(Lifecycle.Event.ON_DESTROY);
    }

    @Override
    public void showResult(IGameResultAnimationCallback callback) {
        this.mCurrentMaxDiamond = -1;
        if (this.mRoomPageContext.isDestroy()) {
            FeatureLog.i((String)"FTWealth", (String)"showResult roomPageContext destroy", (Object[])new Object[0]);
            return;
        }
        this.mWealthSeatItems.clear();
        List<WealthSeatItem> wealthSeatItemList = this.updateSeatResultData();
        if (wealthSeatItemList != null) {
            this.mAnimationManager.setGameResult(wealthSeatItemList);
            if (wealthSeatItemList.size() > 0) {
                this.mAnimationManager.showSeatAnimation(wealthSeatItemList.get(0));
            }
        }
        ((NormalSeatViewWrapper)this.mSeatViewWrapper).getAdapter().notifyDataSetChanged();
        this.mCallback = callback;
    }

    private List<WealthSeatItem> updateSeatResultData() {
        if (this.mRoomPageContext.isDestroy()) {
            FeatureLog.i((String)"FTWealth", (String)"updateSeatResultData roomPageContext destroy", (Object[])new Object[0]);
            return null;
        }
        List<GameResultInfo> gameResultInfoList = WealthDataService.INSTANCE.getWealthDataModel().getGameResult();
        List wealthSeatItemList = ((NormalSeatViewWrapper)this.mSeatViewWrapper).getAdapter().getItems();
        if (wealthSeatItemList.size() > 0 && !(wealthSeatItemList.get(0) instanceof WealthSeatItem)) {
            FeatureLog.i((String)"FTWealth", (String)"updateSeatResultData type not right:%s", (Object[])new Object[]{wealthSeatItemList});
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("updateSeatResultData type not right");
            }
            return null;
        }
        FeatureLog.i((String)"FTWealth", (String)"showResult:%s", (Object[])new Object[]{gameResultInfoList});
        ArrayList tempDataList = new ArrayList();
        int size = wealthSeatItemList.size();
        for (int i = 0; i < size; ++i) {
            if (!(wealthSeatItemList.get(i) instanceof WealthSeatItem)) continue;
            tempDataList.add(wealthSeatItemList.get(i));
        }
        ArrayList<WealthSeatItem> tempList = new ArrayList<WealthSeatItem>();
        if (tempDataList != null) {
            block1: for (WealthSeatItem wealthSeatItem : tempDataList) {
                int size2 = gameResultInfoList.size();
                for (int i = 0; i < size2; ++i) {
                    GameResultInfo gameResultInfo = gameResultInfoList.get(i);
                    if (wealthSeatItem.uid != gameResultInfo.getUid()) continue;
                    wealthSeatItem.setHasShowResult(false);
                    wealthSeatItem.setDiamond(gameResultInfo.getPrice());
                    wealthSeatItem.setGameResultInfo(gameResultInfo);
                    wealthSeatItem.setFirstNumber(false);
                    this.mWealthSeatItems.add(wealthSeatItem);
                    tempList.add(wealthSeatItem);
                    continue block1;
                }
            }
        }
        return tempList;
    }

    @Override
    public void resume(IChannelPageContext pageContext, IGameResultAnimationCallback callback) {
        this.mCurrentMaxDiamond = -1;
        FeatureLog.i((String)"FTWealth", (String)"resume", (Object[])new Object[0]);
        this.mCallback = callback;
        if (this.mRoomPageContext.isDestroy()) {
            FeatureLog.i((String)"FTWealth", (String)"resume roomPageContext destroy", (Object[])new Object[0]);
            return;
        }
        this.mLifeCycleOwner.onEvent(Lifecycle.Event.ON_RESUME);
        this.mIsFromResume = true;
    }

    private List<WealthSeatItem> resumeUpdateData(List<WealthSeatItem> wealthSeatItemList) {
        FeatureLog.i((String)"FTWealth", (String)"resumeData, init currentDiamond:%s", (Object[])new Object[]{this.mCurrentMaxDiamond});
        this.mWealthSeatItems.clear();
        long resultBeginTime = WealthDataService.INSTANCE.getWealthDataModel().getResultBeginTime();
        if (resultBeginTime > 0L) {
            long serviceCurrentTime = TimeUtils.getServiceRealTime() / 1000L;
            int timeSpace = (int)((serviceCurrentTime - resultBeginTime) / 6L);
            FeatureLog.i((String)"FTWealth", (String)"resume, serviceCurrentTime:%s, resultBeginTime:%s, timeSpace:%s", (Object[])new Object[]{serviceCurrentTime, resultBeginTime, timeSpace});
            List<GameResultInfo> gameResultInfoList = WealthDataService.INSTANCE.getWealthDataModel().getGameResult();
            if (timeSpace >= gameResultInfoList.size()) {
                if (wealthSeatItemList != null) {
                    int size = wealthSeatItemList.size();
                    block0: for (int i = 0; i < size; ++i) {
                        for (GameResultInfo gameResultInfo : gameResultInfoList) {
                            WealthSeatItem wealthSeatItem = wealthSeatItemList.get(i);
                            wealthSeatItem.setHasShowResult(false);
                            if (wealthSeatItem.uid != gameResultInfo.getUid()) continue;
                            wealthSeatItem.setDiamond(gameResultInfo.getPrice());
                            wealthSeatItem.setGameResultInfo(gameResultInfo);
                            wealthSeatItem.setHasShowResult(true);
                            wealthSeatItem.setFirstNumber(false);
                            wealthSeatItemList.set(i, wealthSeatItem);
                            this.mWealthSeatItems.add(wealthSeatItem);
                            if (!wealthSeatItem.hasShowResult() || wealthSeatItem.getDiamond() <= this.mCurrentMaxDiamond) continue block0;
                            this.mCurrentMaxDiamond = wealthSeatItem.getDiamond();
                            continue block0;
                        }
                    }
                    for (GameResultInfo gameResultInfo : gameResultInfoList) {
                        boolean isResultInSeat = false;
                        for (WealthSeatItem wealthSeatItem : wealthSeatItemList) {
                            if (gameResultInfo.getUid() != wealthSeatItem.uid) continue;
                            isResultInSeat = true;
                        }
                        if (isResultInSeat) continue;
                        this.mResultGameList.add(gameResultInfo);
                    }
                }
            } else {
                int gameResultIndex = 0;
                int size = wealthSeatItemList.size();
                block4: for (int j = 0; j < size; ++j) {
                    int length = gameResultInfoList.size();
                    for (int i = 0; i < length; ++i) {
                        GameResultInfo gameResultInfo = gameResultInfoList.get(i);
                        WealthSeatItem wealthSeatItem = wealthSeatItemList.get(j);
                        wealthSeatItem.setHasShowResult(false);
                        if (wealthSeatItem.uid != gameResultInfo.getUid()) continue;
                        wealthSeatItem.setDiamond(gameResultInfo.getPrice());
                        wealthSeatItem.setGameResultInfo(gameResultInfo);
                        if (gameResultIndex <= timeSpace) {
                            wealthSeatItem.setHasShowResult(true);
                        }
                        wealthSeatItem.setFirstNumber(false);
                        wealthSeatItemList.set(j, wealthSeatItem);
                        ++gameResultIndex;
                        this.mWealthSeatItems.add(wealthSeatItem);
                        if (!wealthSeatItem.hasShowResult() || wealthSeatItem.getDiamond() <= this.mCurrentMaxDiamond) continue block4;
                        this.mCurrentMaxDiamond = wealthSeatItem.getDiamond();
                        continue block4;
                    }
                }
                for (GameResultInfo gameResultInfo : gameResultInfoList) {
                    boolean bl = false;
                    for (WealthSeatItem wealthSeatItem : wealthSeatItemList) {
                        if (gameResultInfo.getUid() != wealthSeatItem.uid) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    this.mResultGameList.add(gameResultInfo);
                }
                FeatureLog.i((String)"FTWealth", (String)"resumeData:%s", (Object[])new Object[]{this.mWealthSeatItems});
            }
        }
        FeatureLog.i((String)"FTWealth", (String)"resumeData, currentDiamond:%s", (Object[])new Object[]{this.mCurrentMaxDiamond});
        for (WealthSeatItem wealthSeatItem : wealthSeatItemList) {
            if (wealthSeatItem.getDiamond() >= this.mCurrentMaxDiamond) {
                if (!wealthSeatItem.hasShowResult()) continue;
                wealthSeatItem.setFirstNumber(true);
                continue;
            }
            wealthSeatItem.setFirstNumber(false);
        }
        return wealthSeatItemList;
    }

    @Override
    public void init(AbsRoomPage page) {
        this.mAnimationManager.setRoomPage(page);
        if (this.mRoomPageContext.isDestroy()) {
            FeatureLog.i((String)"FTWealth", (String)"init roomPageContext destroy", (Object[])new Object[0]);
            return;
        }
        ((SeatLocationPresenter)this.mRoomPageContext.getPresenter(SeatLocationPresenter.class)).getSeatLocation(false).observe((LifecycleOwner)this.mLifeCycleOwner, locationMap -> {
            if (locationMap == null) {
                return;
            }
            if (this.mIsFromResume) {
                List wealthSeatItemList = ((NormalSeatViewWrapper)this.mSeatViewWrapper).getAdapter().getItems();
                if (wealthSeatItemList.size() > 0 && !(wealthSeatItemList.get(0) instanceof WealthSeatItem)) {
                    FeatureLog.i((String)"FTWealth", (String)"init type not right:%s", (Object[])new Object[]{wealthSeatItemList});
                    if (RuntimeContext.sIsDebuggable) {
                        throw new RuntimeException("init type not right");
                    }
                    return;
                }
                ArrayList<WealthSeatItem> tempDataList = new ArrayList<WealthSeatItem>();
                int size = wealthSeatItemList.size();
                for (int i = 0; i < size; ++i) {
                    if (!(wealthSeatItemList.get(i) instanceof WealthSeatItem)) continue;
                    tempDataList.add((WealthSeatItem)((Object)((Object)wealthSeatItemList.get(i))));
                }
                List<WealthSeatItem> wealthSeatItems = this.resumeUpdateData(tempDataList);
                if (this.mAnimationManager != null) {
                    ArrayList<GameResultInfo> showResultData = new ArrayList<GameResultInfo>();
                    ArrayList<WealthSeatItem> showAnimationData = new ArrayList<WealthSeatItem>();
                    if (this.mResultGameList.size() > 0) {
                        showResultData.addAll(this.mResultGameList);
                    }
                    for (WealthSeatItem wealthSeatItem : wealthSeatItems) {
                        if (wealthSeatItem.hasShowResult()) {
                            showResultData.add(wealthSeatItem.getGameResultInfo());
                            continue;
                        }
                        if (wealthSeatItem.getGameResultInfo() == null) continue;
                        showAnimationData.add(wealthSeatItem);
                    }
                    if (this.mCallback != null) {
                        this.mCallback.onShow(showResultData);
                    }
                    ((NormalSeatViewWrapper)this.mSeatViewWrapper).getAdapter().notifyDataSetChanged();
                    this.mAnimationManager.setGameResult(showAnimationData);
                    if (showAnimationData.size() > 0) {
                        this.mAnimationManager.showSeatAnimation((WealthSeatItem)((Object)((Object)showAnimationData.get(0))));
                    } else {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (WealthSeatPresenter.this.mCallback != null) {
                                    WealthSeatPresenter.this.mCallback.showWinner();
                                }
                            }
                        }, (long)1000L);
                    }
                }
                this.mResultGameList.clear();
                this.mIsFromResume = false;
            }
        });
        this.mLifeCycleOwner.onEvent(Lifecycle.Event.ON_START);
    }

    @Override
    public void setSeatLocationCallback(IChannelPageContext pageContext, ISeatLocationProvider callback) {
        if (this.mAnimationManager != null) {
            this.mAnimationManager.setSeatLocationCallback(pageContext, callback);
        }
    }

    @Override
    public void onFinished(WealthSeatItem wealthSeatItem, WealthSeatItem nextItem) {
        if (this.mRoomPageContext.isDestroy()) {
            FeatureLog.i((String)"FTWealthRoomPageContext", (String)"onFinished roomPageContext destroy", (Object[])new Object[0]);
            return;
        }
        FeatureLog.i((String)"FTWealth", (String)"onFinished, current:%s, next:%s", (Object[])new Object[]{wealthSeatItem, nextItem});
        if (this.mCallback != null && wealthSeatItem != null) {
            WealthSeatItem item;
            int i;
            List wealthSeatItemList;
            if (this.mCurrentMaxDiamond != -1 && wealthSeatItem.getDiamond() > this.mCurrentMaxDiamond) {
                this.mCurrentMaxDiamond = wealthSeatItem.getDiamond();
            }
            if ((wealthSeatItemList = ((NormalSeatViewWrapper)this.mSeatViewWrapper).getAdapter().getItems()).size() > 0 && !(wealthSeatItemList.get(0) instanceof WealthSeatItem)) {
                FeatureLog.i((String)"FTWealth", (String)"onFinished type not right:%s", (Object[])new Object[]{wealthSeatItemList});
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("onFinished type not right");
                }
                return;
            }
            FeatureLog.i((String)"FTWealth", (String)"onFinished list:%s", (Object[])new Object[]{wealthSeatItemList});
            int size = wealthSeatItemList.size();
            for (i = 0; i < size; ++i) {
                if (wealthSeatItemList.get(i) instanceof WealthSeatItem) {
                    item = (WealthSeatItem)((Object)wealthSeatItemList.get(i));
                    if (item.uid != wealthSeatItem.uid) continue;
                    wealthSeatItem.setHasShowResult(true);
                    if (this.mCurrentMaxDiamond != -1) break;
                    wealthSeatItem.setFirstNumber(true);
                    this.mCurrentMaxDiamond = wealthSeatItem.getDiamond();
                    break;
                }
                FeatureLog.i((String)"FTWealth", (String)"onFinished data type not right:%s", (Object[])new Object[]{wealthSeatItemList});
            }
            FeatureLog.i((String)"FTWealth", (String)"mCurrentDiamond:%s", (Object[])new Object[]{this.mCurrentMaxDiamond});
            size = wealthSeatItemList.size();
            for (i = 0; i < size; ++i) {
                if (wealthSeatItemList.get(i) instanceof WealthSeatItem) {
                    item = (WealthSeatItem)((Object)wealthSeatItemList.get(i));
                    if (item.getDiamond() < this.mCurrentMaxDiamond) {
                        if (!item.hasShowResult()) continue;
                        item.setFirstNumber(false);
                        continue;
                    }
                    if (!item.hasShowResult()) continue;
                    item.setFirstNumber(true);
                    this.mCurrentMaxDiamond = item.getDiamond();
                    continue;
                }
                FeatureLog.i((String)"FTWealth", (String)"onFinished data type not right:%s", (Object[])new Object[]{wealthSeatItemList});
            }
            FeatureLog.i((String)"FTWealth", (String)"onFinished size:%s, item:%s", (Object[])new Object[]{this.mWealthSeatItems.size(), this.mWealthSeatItems});
            ((NormalSeatViewWrapper)this.mSeatViewWrapper).getAdapter().notifyDataSetChanged();
            boolean isLast = false;
            isLast = nextItem == null;
            this.mCallback.onFinish(wealthSeatItem.getGameResultInfo(), isLast);
        }
    }

    @Override
    public void onNext(WealthSeatItem nextItem) {
        if (nextItem != null) {
            this.mAnimationManager.showSeatAnimation(nextItem);
        }
    }

    protected NormalSeatViewWrapper createSeatViewWrapper() {
        NormalSeatViewWrapper seatViewWrapper = new NormalSeatViewWrapper();
        seatViewWrapper.getAdapter().register(WealthSeatItem.class, (ItemViewBinder)new BaseItemBinder<WealthSeatItem, WealthSeatItemHolder>(){

            @NonNull
            protected WealthSeatItemHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new WealthSeatItemHolder(this.createItemView(inflater, parent, R.layout.voice_room_wealth_item_channel), (IChannelPageContext)WealthSeatPresenter.this.getMvpContext());
            }

            protected void onBindViewHolder(@NonNull WealthSeatItemHolder holder, @NonNull WealthSeatItem item) {
                super.onBindViewHolder((BaseItemBinder.ViewHolder)holder, (Object)item);
                if (WealthSeatPresenter.this.getMvpContext() == null) {
                    return;
                }
                if (((IChannelPageContext)WealthSeatPresenter.this.getMvpContext()).isDestroy()) {
                    return;
                }
                holder.setRoomId(WealthSeatPresenter.this.getRoomId());
                holder.setOnSeatItemListener((SeatMvp.IView.OnSeatItemListener)WealthSeatPresenter.this);
            }
        });
        return seatViewWrapper;
    }

    protected List<SeatItem> createSeatItems(List<SeatUser> seatList) {
        ArrayList<WealthSeatItem> wealthSeatItemList = new ArrayList<WealthSeatItem>();
        for (int i = 0; i < seatList.size(); ++i) {
            WealthSeatItem temp = new WealthSeatItem();
            super.initSeat((SeatItem)temp, seatList.get(i));
            wealthSeatItemList.add(temp);
        }
        FeatureLog.i((String)"FTWealth", (String)"intercept:%s", (Object[])new Object[]{this.mWealthSeatItems});
        if (this.mWealthSeatItems != null) {
            block1: for (WealthSeatItem wealthSeatItem : this.mWealthSeatItems) {
                int size = wealthSeatItemList.size();
                for (int i = 0; i < size; ++i) {
                    if (((WealthSeatItem)((Object)wealthSeatItemList.get((int)i))).uid == 0L || ((WealthSeatItem)((Object)wealthSeatItemList.get((int)i))).uid != wealthSeatItem.uid) continue;
                    wealthSeatItem.index = ((WealthSeatItem)((Object)wealthSeatItemList.get((int)i))).index;
                    wealthSeatItem.roleType = ((WealthSeatItem)((Object)wealthSeatItemList.get((int)i))).roleType;
                    wealthSeatItem.isSpeaking = ((WealthSeatItem)((Object)wealthSeatItemList.get((int)i))).isSpeaking;
                    wealthSeatItem.payLoad = ((WealthSeatItem)((Object)wealthSeatItemList.get((int)i))).payLoad;
                    wealthSeatItem.statusFlag = ((WealthSeatItem)((Object)wealthSeatItemList.get((int)i))).statusFlag;
                    wealthSeatItem.uid = ((WealthSeatItem)((Object)wealthSeatItemList.get((int)i))).uid;
                    wealthSeatItem.userInfo = ((WealthSeatItem)((Object)wealthSeatItemList.get((int)i))).userInfo;
                    wealthSeatItem.mCalculatorData.setNeedLarge(true);
                    wealthSeatItemList.set(i, wealthSeatItem);
                    continue block1;
                }
            }
            int size = wealthSeatItemList.size();
            block3: for (int i = 0; i < size; ++i) {
                for (WealthSeatItem wealthSeatItem : this.mWealthSeatItems) {
                    WealthSeatItem currentItem = (WealthSeatItem)((Object)wealthSeatItemList.get(i));
                    if (currentItem.uid == 0L || currentItem.uid != wealthSeatItem.uid) continue;
                    currentItem.setDiamond(wealthSeatItem.getDiamond());
                    currentItem.setHasShowResult(wealthSeatItem.hasShowResult());
                    currentItem.setFirstNumber(wealthSeatItem.isFirstNumber());
                    wealthSeatItemList.set(i, wealthSeatItem);
                    continue block3;
                }
            }
        }
        return new ArrayList<SeatItem>(wealthSeatItemList);
    }

    public static interface IGameResultAnimationCallback {
        public void onFinish(GameResultInfo var1, boolean var2);

        public void onShow(List<GameResultInfo> var1);

        public void showWinner();
    }
}

