/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.base;

import android.widget.FrameLayout;
import com.yy.base.featurelog.FeatureLog;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.tools.ISeatLocationProvider;
import com.yy.hiyo.channel.plugins.bocai.base.BocaiStatis;
import com.yy.hiyo.channel.plugins.bocai.base.IWealthViewManager;
import com.yy.hiyo.channel.plugins.bocai.data.WealthDataService;
import com.yy.hiyo.channel.plugins.bocai.data.bean.GameResultInfo;
import com.yy.hiyo.channel.plugins.bocai.data.bean.HistoryRecord;
import com.yy.hiyo.channel.plugins.bocai.seat.ISeatViewManager;
import com.yy.hiyo.channel.plugins.bocai.seat.WealthSeatPresenter;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.GameViewManager;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.IGameViewManager;
import com.yy.hiyo.channel.plugins.bocai.ui.view.history.HistoryDialog;
import com.yy.hiyo.channel.plugins.bocai.ui.view.history.HistoryViewManager;
import com.yy.hiyo.channel.plugins.bocai.ui.view.history.IHistoryViewManager;
import com.yy.hiyo.channel.plugins.bocai.ui.view.other.NoEnoughDialog;
import com.yy.hiyo.channel.plugins.bocai.ui.view.rule.IRuleViewManager;
import com.yy.hiyo.channel.plugins.bocai.ui.view.rule.RuleViewManager;
import com.yy.hiyo.channel.plugins.voiceroom.AbsRoomPage;
import java.util.List;

public class DefaultWealthViewManager
implements IWealthViewManager {
    protected IGameViewManager mGameViewManager;
    protected IRuleViewManager mRuleViewManager;
    protected IHistoryViewManager mHistoryViewManager;
    protected ISeatViewManager mSeatViewManager;
    protected IChannelPageContext mRoomPageContext;
    private WealthSeatPresenter.IGameResultAnimationCallback mGameResultAnimationCallback = new WealthSeatPresenter.IGameResultAnimationCallback(){

        @Override
        public void onFinish(GameResultInfo gameResultInfo, boolean isLast) {
            if (DefaultWealthViewManager.this.mGameViewManager != null) {
                DefaultWealthViewManager.this.mGameViewManager.showGameResult(gameResultInfo, isLast);
            }
        }

        @Override
        public void onShow(List<GameResultInfo> gameResultInfos) {
            if (DefaultWealthViewManager.this.mGameViewManager != null) {
                DefaultWealthViewManager.this.mGameViewManager.showGameResultList(gameResultInfos);
            }
        }

        @Override
        public void showWinner() {
            if (DefaultWealthViewManager.this.mGameViewManager != null) {
                DefaultWealthViewManager.this.mGameViewManager.showWinner();
            }
        }
    };

    public DefaultWealthViewManager(WealthSeatPresenter seatPresenter) {
        this.mSeatViewManager = seatPresenter;
    }

    @Override
    public void showHistoryView(List<HistoryRecord> data, String cursor, HistoryDialog.IHistoryLoadListener listener) {
        if (this.mHistoryViewManager != null) {
            this.mHistoryViewManager.show(data, cursor, listener);
        }
    }

    @Override
    public IGameViewManager getGameViewManager() {
        return this.mGameViewManager;
    }

    @Override
    public void showRuleView() {
        if (this.mRuleViewManager != null) {
            this.mRuleViewManager.show();
        }
    }

    @Override
    public void updateSeat(List<Long> memberList) {
        if (this.mSeatViewManager != null) {
            this.mSeatViewManager.updateSeat(memberList);
        }
    }

    @Override
    public void destroy() {
        FeatureLog.i((String)"FTWealth", (String)"WealthViewManager destroy", (Object[])new Object[0]);
        if (this.mSeatViewManager != null) {
            this.mSeatViewManager.destroy();
        }
        if (this.mGameViewManager != null) {
            this.mGameViewManager.destroy();
        }
    }

    @Override
    public void showResult() {
        if (this.mSeatViewManager != null) {
            this.mSeatViewManager.showResult(this.mGameResultAnimationCallback);
        }
    }

    @Override
    public void showNoEnoughView() {
        NoEnoughDialog noEnoughDialog = new NoEnoughDialog();
        this.mRoomPageContext.getDialogLinkManager().showDialog((BaseDialog)noEnoughDialog);
        String roomId = WealthDataService.INSTANCE.getWealthDataModel().getRoomId();
        BocaiStatis.reportLessPopShow(roomId);
    }

    @Override
    public void addHistoryRecord(List<HistoryRecord> list, String cursor) {
        if (this.mHistoryViewManager != null) {
            this.mHistoryViewManager.addHistoryRecord(list, cursor);
        }
    }

    @Override
    public void resume(IChannelPageContext pageContext) {
        if (this.mSeatViewManager != null) {
            this.mSeatViewManager.resume(pageContext, this.mGameResultAnimationCallback);
        }
    }

    @Override
    public void init(IChannelPageContext pageContext, FrameLayout gameContainer, AbsRoomPage page) {
        this.mRoomPageContext = pageContext;
        this.mGameViewManager = new GameViewManager(gameContainer);
        this.mRuleViewManager = new RuleViewManager(pageContext);
        this.mHistoryViewManager = new HistoryViewManager(pageContext);
        if (this.mSeatViewManager != null) {
            this.mSeatViewManager.initAdapter(pageContext);
            this.mSeatViewManager.init(page);
        }
    }

    @Override
    public void setSeatLocationCallback(IChannelPageContext pageContext, ISeatLocationProvider callback) {
        if (this.mSeatViewManager != null) {
            this.mSeatViewManager.setSeatLocationCallback(pageContext, callback);
        }
    }

    @Override
    public void reset(int gameStatus) {
        if (this.mGameViewManager != null) {
            this.mGameViewManager.reset(gameStatus);
        }
    }
}

