/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.history;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.data.bean.GameResultInfo;
import com.yy.hiyo.channel.plugins.bocai.data.bean.HistoryRecord;
import java.util.List;

public class HistoryAdapter
extends RecyclerView.Adapter<WealthHistoryViewHolder> {
    private List<HistoryRecord> mData;
    private Context mContext;

    public HistoryAdapter(Context context, List<HistoryRecord> data) {
        this.mData = data;
        this.mContext = context;
    }

    @NonNull
    public WealthHistoryViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = View.inflate((Context)parent.getContext(), (int)R.layout.layout_wealth_history_item_channel, null);
        WealthHistoryViewHolder viewHolder = new WealthHistoryViewHolder(view);
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull WealthHistoryViewHolder holder, int position) {
        if (this.mData == null) {
            return;
        }
        HistoryRecord historyRecord = this.mData.get(position);
        holder.tvDiamond.setText((CharSequence)(historyRecord.getTotalPrice() + ""));
        FontUtils.setFontType((TextView)holder.tvDiamond, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        holder.tvTime.setText((CharSequence)TimeUtils.getTimeStringFromMillis((long)(historyRecord.getTime() * 1000L), (String)"%04d-%02d-%02d %02d:%02d"));
        List<GameResultInfo> resultInfoList = historyRecord.getMemberInfoLit();
        holder.llContent.removeAllViews();
        if (resultInfoList != null) {
            for (GameResultInfo gameResultInfo : resultInfoList) {
                YYLinearLayout contentLayout = new YYLinearLayout(this.mContext);
                contentLayout.setOrientation(1);
                LinearLayout.LayoutParams contentLayoutParams = new LinearLayout.LayoutParams(-2, -2);
                contentLayoutParams.topMargin = ResolutionUtils.dip2Px((float)11.0f);
                contentLayoutParams.leftMargin = ResolutionUtils.dip2Px((float)10.0f);
                LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)contentLayoutParams);
                contentLayout.setLayoutParams((ViewGroup.LayoutParams)contentLayoutParams);
                RecycleImageView rvGift = new RecycleImageView(this.mContext);
                LinearLayout.LayoutParams giftParams = new LinearLayout.LayoutParams(ResolutionUtils.dip2Px((float)28.0f), ResolutionUtils.dip2Px((float)28.0f));
                ImageLoader.loadImage((RecycleImageView)rvGift, (String)gameResultInfo.getGiftUrl(), (int)R.drawable.default_history_gift);
                rvGift.setLayoutParams((ViewGroup.LayoutParams)giftParams);
                contentLayout.addView((View)rvGift);
                YYTextView tvPrice = new YYTextView(this.mContext);
                tvPrice.setText((CharSequence)("x" + gameResultInfo.getAmount()));
                FontUtils.setFontType((TextView)tvPrice, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
                tvPrice.setTextSize(10.0f);
                tvPrice.setIncludeFontPadding(false);
                tvPrice.setGravity(17);
                tvPrice.setTextColor(Color.parseColor((String)"#000000"));
                LinearLayout.LayoutParams priceLayoutParams = new LinearLayout.LayoutParams(-2, -2);
                priceLayoutParams.topMargin = ResolutionUtils.dip2Px((float)3.0f);
                priceLayoutParams.gravity = 1;
                tvPrice.setLayoutParams((ViewGroup.LayoutParams)priceLayoutParams);
                contentLayout.addView((View)tvPrice);
                holder.llContent.addView((View)contentLayout);
            }
        }
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public void addData(List<HistoryRecord> list) {
        if (this.mData != null) {
            this.mData.addAll(list);
        }
        FeatureLog.i((String)"FTWealth", (String)"addData, size:%s", (Object[])new Object[]{this.mData.size()});
        this.notifyDataSetChanged();
    }

    public class WealthHistoryViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvDiamond;
        TextView tvTime;
        LinearLayout llContent;

        public WealthHistoryViewHolder(View itemView) {
            super(itemView);
            this.tvDiamond = (TextView)itemView.findViewById(R.id.tv_wealth_history_diamond);
            this.tvTime = (TextView)itemView.findViewById(R.id.tv_wealth_history_time);
            this.llContent = (LinearLayout)itemView.findViewById(R.id.ll_wealth_content);
        }
    }
}

