/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessExtensionImpl;
import com.diffplug.gradle.spotless.SpotlessPluginRedirect;
import com.diffplug.spotless.SpotlessCache;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.BasePlugin;

public class SpotlessPlugin
implements Plugin<Project> {
    static final String SPOTLESS_MODERN = "spotlessModern";
    static final String MINIMUM_GRADLE = "6.1";

    public void apply(Project project) {
        if (SpotlessPluginRedirect.gradleIsTooOld(project)) {
            throw new GradleException("Spotless requires Gradle 6.1 or newer, this was " + project.getGradle().getGradleVersion());
        }
        if (project.hasProperty(SPOTLESS_MODERN)) {
            project.getLogger().warn("'spotlessModern' has no effect as of Spotless 5.0, recommend removing it.");
        }
        project.getPlugins().apply(BasePlugin.class);
        project.getExtensions().create(SpotlessExtension.class, "spotless", SpotlessExtensionImpl.class, new Object[]{project});
        int cacheKey = System.identityHashCode(project.getRootProject());
        project.getTasks().named("clean").configure(clean -> clean.doLast(unused -> SpotlessCache.clearOnce((Object)cacheKey)));
    }

    static String capitalize(String input) {
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }
}

