/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.ThrowingEx;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.concurrent.TimeoutException;

final class NpmResourceHelper {
    private NpmResourceHelper() {
    }

    static void writeUtf8StringToFile(File targetDir, String fileName, String stringToWrite) throws IOException {
        File packageJsonFile = new File(targetDir, fileName);
        Files.write(packageJsonFile.toPath(), stringToWrite.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    static void writeUtf8StringToOutputStream(String stringToWrite, OutputStream outputStream) throws IOException {
        byte[] bytes = stringToWrite.getBytes(StandardCharsets.UTF_8);
        outputStream.write(bytes);
    }

    static void deleteFileIfExists(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Failed to delete " + file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readUtf8StringFromClasspath(Class<?> clazz, String resourceName) {
        try (InputStream input = clazz.getResourceAsStream(resourceName);){
            String string = NpmResourceHelper.readUtf8StringFromInputStream(input);
            return string;
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    static String readUtf8StringFromFile(File file) {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(file.toPath()));
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    static String readUtf8StringFromInputStream(InputStream input) {
        try {
            int numRead;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((numRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, numRead);
            }
            return output.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    static void assertDirectoryExists(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("cannot create temp dir for node modules at " + directory);
        }
    }

    static void awaitReadableFile(File file, Duration maxWaitTime) throws TimeoutException {
        long startedAt = System.currentTimeMillis();
        while (!file.exists() || !file.canRead()) {
            if (System.currentTimeMillis() - startedAt <= maxWaitTime.toMillis()) continue;
            throw new TimeoutException("The file did not appear within " + maxWaitTime);
        }
    }
}

