/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.AbstractRefactoringCodeVisitor;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.ClassImport;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.StaticClassImport;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.StaticFieldImport;

public abstract class RefactoringCodeVisitorSupport
extends AbstractRefactoringCodeVisitor {
    protected ModuleNode rootNode;

    public RefactoringCodeVisitorSupport(ModuleNode rootNode) {
        this.rootNode = rootNode;
    }

    public void visitClassImport(ClassImport classImport) {
    }

    protected void analyzeNode(ASTNode node) {
    }

    protected void clear(ASTNode node) {
    }

    public void visitStaticClassImport(StaticClassImport staticClassImport) {
    }

    public void visitStaticFieldImport(StaticFieldImport staticAliasImport) {
    }

    public void scanAST() {
        this.analyseClassImports();
        this.analyseStaticClassImport();
        this.analyseStaticFieldImport();
        if (!this.rootNode.getStatementBlock().isEmpty()) {
            for (Statement statement : this.rootNode.getStatementBlock().getStatements()) {
                statement.visit(this);
            }
        }
        List<ClassNode> classes = this.rootNode.getClasses();
        for (ClassNode classNode : classes) {
            if (!classNode.isScript()) {
                this.visitClass(classNode);
                continue;
            }
            List<MethodNode> methods = this.rootNode.getMethods();
            for (MethodNode method : methods) {
                this.visitMethod(method);
            }
        }
    }

    private void analyseStaticFieldImport() {
        for (Map.Entry<String, ImportNode> aliasOrField : this.rootNode.getStaticImports().entrySet()) {
            StaticFieldImport staticAliasImport = new StaticFieldImport(aliasOrField.getValue().getType(), aliasOrField.getKey(), aliasOrField.getValue().getFieldName());
            staticAliasImport.setSourcePosition(aliasOrField.getValue());
            this.visitStaticFieldImport(staticAliasImport);
        }
    }

    private void analyseStaticClassImport() {
        Collection<ImportNode> staticImportClasses = this.rootNode.getStaticImports().values();
        for (ImportNode staticImp : staticImportClasses) {
            ClassNode type = staticImp.getType();
            StaticClassImport staticClassImport = new StaticClassImport(type);
            staticClassImport.setSourcePosition(type);
            this.visitStaticClassImport(staticClassImport);
        }
    }

    private void analyseClassImports() {
        List<ImportNode> imports = this.rootNode.getImports();
        for (ImportNode importNode : imports) {
            ClassImport classImport = new ClassImport(importNode);
            classImport.setSourcePosition(importNode.getType());
            this.visitClassImport(classImport);
        }
    }

    protected void analyzeNodes(ASTNode[] nodes) {
        if (nodes != null) {
            int i = 0;
            while (i < nodes.length) {
                this.analyzeNode(nodes[i]);
                this.clear(nodes[i]);
                ++i;
            }
        }
    }

    protected void analyzeTypes(ClassNode[] classNodes) {
        if (classNodes != null) {
            int i = 0;
            while (i < classNodes.length) {
                if (classNodes[i] != null) {
                    this.analyzeType(classNodes[i]);
                    this.clear(classNodes[i]);
                }
                ++i;
            }
        }
    }

    private void analyzeTypeInternal(ClassNode classNode) {
        ClassNode node = classNode;
        while (node.isArray()) {
            node = node.getComponentType();
        }
        this.analyzeNode(node);
        this.analyzeGenerics(node);
    }

    public void analyzeType(ClassNode node) {
        this.analyzeTypeInternal(node);
    }

    public void analyzeParameter(Parameter parameter) {
        this.analyzeNode(parameter);
    }

    protected void analyzeGenerics(ClassNode node) {
        if (node.getGenericsTypes() != null) {
            GenericsType[] generics = node.getGenericsTypes();
            int i = 0;
            while (i < generics.length) {
                GenericsType genericType = generics[i];
                if (!node.getName().equals(genericType.getType().getName())) {
                    this.analyzeType(genericType.getType());
                    this.clear(genericType.getType());
                    if (genericType.getLowerBound() != null) {
                        this.analyzeType(genericType.getLowerBound());
                        this.clear(genericType.getLowerBound());
                    }
                    if (genericType.getUpperBounds() != null) {
                        ClassNode[] upperBounds = (ClassNode[])genericType.getUpperBounds().clone();
                        int j = 0;
                        while (j < upperBounds.length) {
                            if (upperBounds[i].getName().equals(node.getName())) {
                                upperBounds[i] = null;
                            }
                            ++j;
                        }
                        this.analyzeTypes(upperBounds);
                    }
                }
                ++i;
            }
        }
    }

    protected void analyseParameters(Parameter[] parameters) {
        if (parameters != null) {
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                this.analyzeParameter(parameter);
                this.analyzeType(parameter.getOriginType());
                this.clear(parameter.getOriginType());
                if (parameter.hasInitialExpression()) {
                    parameter.getInitialExpression().visit(this);
                }
                this.clear(parameter);
                ++n2;
            }
        }
    }

    public void visitAnnotations(AnnotatedNode node) {
        List<AnnotationNode> annotionMap = node.getAnnotations();
        if (annotionMap.isEmpty()) {
            return;
        }
        for (AnnotationNode an : annotionMap) {
            if (an.isBuiltIn()) continue;
            for (Map.Entry entry : an.getMembers().entrySet()) {
                ((Expression)entry.getValue()).visit(this);
            }
        }
    }

    public void visitClass(ClassNode node) {
        this.analyzeTypeInternal(node);
        this.analyzeType(node.getUnresolvedSuperClass());
        this.clear(node.getUnresolvedSuperClass());
        this.analyzeTypes(node.getInterfaces());
        node.visitContents(this);
        this.clear(node);
    }

    public void visitField(FieldNode node) {
        this.analyzeNode(node);
        this.analyzeType(node.getOriginType());
        this.clear(node.getOriginType());
        Expression initExp = node.getInitialValueExpression();
        if (initExp != null) {
            this.analyzeNode(initExp);
            initExp.visit(this);
            this.clear(initExp);
        }
        this.clear(node);
    }

    protected void visitClassCodeContainer(Statement code) {
        if (code != null) {
            code.visit(this);
        }
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.visitAnnotations(node);
        this.analyseMethodHead(node);
        Statement code = node.getCode();
        this.visitClassCodeContainer(code);
    }

    public void visitConstructor(ConstructorNode node) {
        this.analyzeNode(node);
        this.visitConstructorOrMethod(node, true);
        this.clear(node);
    }

    public void visitMethod(MethodNode node) {
        this.analyzeNode(node);
        this.visitConstructorOrMethod(node, false);
        this.clear(node);
    }

    private void analyseMethodHead(MethodNode node) {
        this.analyzeType(node.getReturnType());
        this.clear(node.getReturnType());
        this.analyseParameters(node.getParameters());
        this.analyzeTypes(node.getExceptions());
    }

    public void visitProperty(PropertyNode node) {
    }

    public void visitVariableExpression(VariableExpression expression) {
        this.analyzeNode(expression);
        this.analyzeType(expression.getOriginType());
        this.clear(expression.getOriginType());
        super.visitVariableExpression(expression);
        this.clear(expression);
    }

    public void visitClosureExpression(ClosureExpression expression) {
        this.analyzeNode(expression);
        this.analyseParameters(expression.getParameters());
        super.visitClosureExpression(expression);
        this.clear(expression);
    }

    public void visitArgumentlistExpression(ArgumentListExpression ale) {
        this.analyzeNode(ale);
        super.visitArgumentlistExpression(ale);
        this.clear(ale);
    }

    public void visitArrayExpression(ArrayExpression expression) {
        this.analyzeNode(expression);
        this.analyzeType(expression.getElementType());
        this.clear(expression.getElementType());
        super.visitArrayExpression(expression);
        this.clear(expression);
    }

    public void visitAssertStatement(AssertStatement statement) {
        this.analyzeNode(statement);
        super.visitAssertStatement(statement);
        this.clear(statement);
    }

    public void visitAttributeExpression(AttributeExpression expression) {
        this.analyzeNode(expression);
        super.visitAttributeExpression(expression);
        this.clear(expression);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        this.analyzeNode(expression);
        super.visitBinaryExpression(expression);
        this.clear(expression);
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        this.analyzeNode(expression);
        super.visitBitwiseNegationExpression(expression);
        this.clear(expression);
    }

    public void visitBlockStatement(BlockStatement block) {
        this.analyzeNode(block);
        super.visitBlockStatement(block);
        this.clear(block);
    }

    public void visitBooleanExpression(BooleanExpression expression) {
        this.analyzeNode(expression);
        super.visitBooleanExpression(expression);
        this.clear(expression);
    }

    public void visitBreakStatement(BreakStatement statement) {
        this.analyzeNode(statement);
        super.visitBreakStatement(statement);
        this.clear(statement);
    }

    public void visitCaseStatement(CaseStatement statement) {
        this.analyzeNode(statement);
        super.visitCaseStatement(statement);
        this.clear(statement);
    }

    public void visitCastExpression(CastExpression expression) {
        this.analyzeNode(expression);
        this.analyzeType(expression.getType());
        this.clear(expression.getType());
        super.visitCastExpression(expression);
        this.clear(expression);
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.analyzeNode(statement);
        this.analyzeType(statement.getExceptionType());
        this.clear(statement.getExceptionType());
        super.visitCatchStatement(statement);
        this.clear(statement);
    }

    public void visitClassExpression(ClassExpression expression) {
        this.analyzeNode(expression);
        super.visitClassExpression(expression);
        this.clear(expression);
    }

    public void visitClosureListExpression(ClosureListExpression cle) {
        this.analyzeNode(cle);
        super.visitClosureListExpression(cle);
        this.clear(cle);
    }

    public void visitConstantExpression(ConstantExpression expression) {
        this.analyzeNode(expression);
        super.visitConstantExpression(expression);
        this.clear(expression);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        this.analyzeNode(call);
        this.analyzeType(call.getType());
        this.clear(call.getType());
        super.visitConstructorCallExpression(call);
        this.clear(call);
    }

    public void visitContinueStatement(ContinueStatement statement) {
        this.analyzeNode(statement);
        super.visitContinueStatement(statement);
        this.clear(statement);
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        super.visitDeclarationExpression(expression);
    }

    public void visitDoWhileLoop(DoWhileStatement loop) {
        this.analyzeNode(loop);
        super.visitDoWhileLoop(loop);
        this.clear(loop);
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        this.analyzeNode(statement);
        super.visitExpressionStatement(statement);
        this.clear(statement);
    }

    public void visitFieldExpression(FieldExpression expression) {
        if (!expression.getType().getNameWithoutPackage().equals("MetaClass")) {
            this.analyzeNode(expression);
            super.visitFieldExpression(expression);
            this.clear(expression);
        }
    }

    public void visitForLoop(ForStatement forLoop) {
        this.analyzeNode(forLoop);
        super.visitForLoop(forLoop);
        this.clear(forLoop);
    }

    public void visitGStringExpression(GStringExpression expression) {
        this.analyzeNode(expression);
        super.visitGStringExpression(expression);
        this.clear(expression);
    }

    public void visitIfElse(IfStatement ifElse) {
        this.analyzeNode(ifElse);
        super.visitIfElse(ifElse);
        this.clear(ifElse);
    }

    public void visitListExpression(ListExpression expression) {
        this.analyzeNode(expression);
        super.visitListExpression(expression);
        this.clear(expression);
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
        this.analyzeNode(expression);
        super.visitMapEntryExpression(expression);
        this.clear(expression);
    }

    public void visitMapExpression(MapExpression expression) {
        this.analyzeNode(expression);
        super.visitMapExpression(expression);
        this.clear(expression);
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        this.analyzeNode(call);
        super.visitMethodCallExpression(call);
        this.clear(call);
    }

    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        this.analyzeNode(expression);
        super.visitMethodPointerExpression(expression);
        this.clear(expression);
    }

    public void visitNotExpression(NotExpression expression) {
        this.analyzeNode(expression);
        super.visitNotExpression(expression);
        this.clear(expression);
    }

    public void visitPostfixExpression(PostfixExpression expression) {
        this.analyzeNode(expression);
        super.visitPostfixExpression(expression);
        this.clear(expression);
    }

    public void visitPrefixExpression(PrefixExpression expression) {
        this.analyzeNode(expression);
        super.visitPrefixExpression(expression);
        this.clear(expression);
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        this.analyzeNode(expression);
        super.visitPropertyExpression(expression);
        this.clear(expression);
    }

    public void visitRangeExpression(RangeExpression expression) {
        this.analyzeNode(expression);
        super.visitRangeExpression(expression);
        this.clear(expression);
    }

    public void visitReturnStatement(ReturnStatement statement) {
        this.analyzeNode(statement);
        super.visitReturnStatement(statement);
        this.clear(statement);
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression expression) {
        this.analyzeNode(expression);
        super.visitShortTernaryExpression(expression);
        this.clear(expression);
    }

    public void visitSpreadExpression(SpreadExpression expression) {
        this.analyzeNode(expression);
        super.visitSpreadExpression(expression);
        this.clear(expression);
    }

    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        this.analyzeNode(expression);
        super.visitSpreadMapExpression(expression);
        this.clear(expression);
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        this.analyzeNode(call);
        super.visitStaticMethodCallExpression(call);
        this.clear(call);
    }

    public void visitSwitch(SwitchStatement statement) {
        this.analyzeNode(statement);
        super.visitSwitch(statement);
        this.clear(statement);
    }

    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.analyzeNode(statement);
        super.visitSynchronizedStatement(statement);
        this.clear(statement);
    }

    public void visitTernaryExpression(TernaryExpression expression) {
        this.analyzeNode(expression);
        super.visitTernaryExpression(expression);
        this.clear(expression);
    }

    public void visitThrowStatement(ThrowStatement statement) {
        this.analyzeNode(statement);
        super.visitThrowStatement(statement);
        this.clear(statement);
    }

    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.analyzeNode(statement);
        super.visitTryCatchFinally(statement);
        this.clear(statement);
    }

    public void visitTupleExpression(TupleExpression expression) {
        super.visitTupleExpression(expression);
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        this.analyzeNode(expression);
        super.visitUnaryMinusExpression(expression);
        this.clear(expression);
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        this.analyzeNode(expression);
        super.visitUnaryPlusExpression(expression);
        this.clear(expression);
    }

    public void visitWhileLoop(WhileStatement loop) {
        this.analyzeNode(loop);
        super.visitWhileLoop(loop);
        this.clear(loop);
    }
}

