/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils;

import org.codehaus.groovy.ast.ASTNode;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCodePoint
implements Comparable<SourceCodePoint> {
    public static final int BEGIN = 0;
    public static final int END = 1;
    private final int row;
    private final int col;

    public SourceCodePoint(int row, int col) {
        assert (row > -1);
        assert (col > -1);
        this.row = row;
        this.col = col;
    }

    public SourceCodePoint(int offset, IDocument doc) {
        int row = 0;
        int col = 0;
        try {
            row = doc.getLineOfOffset(offset);
            col = offset - doc.getLineOffset(row);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.row = row + 1;
        this.col = col + 1;
    }

    public SourceCodePoint(ASTNode node, int pos) {
        switch (pos) {
            case 0: {
                this.row = node.getLineNumber();
                this.col = node.getColumnNumber();
                break;
            }
            case 1: {
                this.row = node.getLastLineNumber();
                this.col = node.getLastColumnNumber();
                break;
            }
            default: {
                this.col = -1;
                this.row = -1;
            }
        }
    }

    public boolean isAfter(SourceCodePoint p2) {
        if (this.row > p2.row) {
            return true;
        }
        return this.row == p2.row && this.col >= p2.col;
    }

    public boolean isBefore(SourceCodePoint p2) {
        if (this.row < p2.row) {
            return true;
        }
        return this.row == p2.row && this.col <= p2.col;
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    public int getOffset(IDocument doc) {
        try {
            return doc.getLineOffset(this.row - 1) + (this.col - 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static int getOffset(int row, int col, IDocument doc) {
        return new SourceCodePoint(row, col).getOffset(doc);
    }

    public static int getRow(int offset, IDocument doc) {
        return new SourceCodePoint(offset, doc).getRow();
    }

    public static int getCol(int offset, IDocument doc) {
        return new SourceCodePoint(offset, doc).getCol();
    }

    @Override
    public int compareTo(SourceCodePoint arg0) {
        if (this.row > arg0.row) {
            return 1;
        }
        if (this.row == arg0.row && this.col > arg0.col) {
            return 1;
        }
        if (this.row < arg0.row) {
            return -1;
        }
        if (this.row == arg0.row && this.col < arg0.col) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SourceCodePoint) {
            return ((SourceCodePoint)obj).col == this.col && ((SourceCodePoint)obj).row == this.row;
        }
        return false;
    }

    public int hashCode() {
        return (String.valueOf(String.valueOf(this.col)) + "/" + String.valueOf(this.row)).hashCode();
    }

    public boolean isInvalid() {
        return this.col < 1 || this.row < 1;
    }

    public boolean isValid() {
        return !this.isInvalid();
    }

    public String toString() {
        return "(" + this.row + " / " + this.col + ")";
    }
}

