/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InferParameterAndReturnTypesRequestor
implements ITypeRequestor {
    private Map<Variable, ClassNode> inferredTypes = new HashMap<Variable, ClassNode>();
    private final Region selectedText;

    public InferParameterAndReturnTypesRequestor(List<Variable> actualParameters, Set<Variable> returnParameters, Region selectedText) {
        for (Variable variable : actualParameters) {
            this.inferredTypes.put(variable, null);
        }
        for (Variable variable : returnParameters) {
            this.inferredTypes.put(variable, null);
        }
        this.selectedText = selectedText;
    }

    @Override
    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (!this.interestingElement(enclosingElement)) {
            return ITypeRequestor.VisitStatus.CANCEL_MEMBER;
        }
        if (node instanceof Variable) {
            Variable accessedVar;
            if (this.inferredTypes.containsKey(node)) {
                this.inferredTypes.put((Variable)((Object)node), this.extractType(result));
            } else if (node instanceof VariableExpression && this.inferredTypes.containsKey(accessedVar = ((VariableExpression)node).getAccessedVariable())) {
                this.inferredTypes.put(accessedVar, this.extractType(result));
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private ClassNode extractType(TypeLookupResult result) {
        ClassNode type = result.type.getPlainNodeReference();
        if (type.getName().equals(VariableScope.VOID_WRAPPER_CLASS_NODE.getName())) {
            type = VariableScope.OBJECT_CLASS_NODE;
        }
        return type;
    }

    public Map<Variable, ClassNode> getInferredTypes() {
        return this.inferredTypes;
    }

    private boolean interestingElement(IJavaElement enclosingElement) {
        if (enclosingElement.getElementName().equals("<clinit>")) {
            return true;
        }
        if (enclosingElement instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)((Object)enclosingElement)).getSourceRange();
                return range.getOffset() <= this.selectedText.getOffset() && range.getOffset() + range.getLength() >= this.selectedText.getEnd();
            }
            catch (JavaModelException e) {
                Util.log(e);
            }
        }
        return false;
    }
}

