/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.search;

import java.util.ArrayList;
import org.codehaus.groovy.eclipse.core.search.ISearchRequestor;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;

public class SyntheticAccessorSearchRequestor {
    public void findSyntheticMatches(IJavaElement element, ISearchRequestor uiRequestor, IProgressMonitor monitor) throws CoreException {
        this.findSyntheticMatches(element, 2, new SearchParticipant[]{new JavaSearchParticipant()}, SearchEngine.createWorkspaceScope(), uiRequestor, monitor);
    }

    public void findSyntheticMatches(IJavaElement element, int limitTo, SearchParticipant[] participants, IJavaSearchScope scope, ISearchRequestor uiRequestor, IProgressMonitor monitor) throws CoreException {
        if (!this.isInteresting(element)) {
            return;
        }
        if (limitTo == 0) {
            return;
        }
        SearchPattern pattern = this.createPattern(element);
        if (pattern == null) {
            return;
        }
        Requestor requestor = new Requestor(uiRequestor);
        SearchEngine engine = new SearchEngine();
        engine.search(pattern, participants, scope, requestor, monitor);
    }

    private SearchPattern createPattern(IJavaElement element) throws JavaModelException {
        ArrayList<IAnnotatable> toSearch = new ArrayList<IAnnotatable>(4);
        toSearch.add(this.findSyntheticMember(element, "is"));
        toSearch.add(this.findSyntheticMember(element, "get"));
        toSearch.add(this.findSyntheticMember(element, "set"));
        toSearch.add(this.findSyntheticProperty(element));
        SearchPattern pattern = null;
        for (IJavaElement iJavaElement : toSearch) {
            if (iJavaElement == null) continue;
            SearchPattern newPattern = SearchPattern.createPattern(iJavaElement, 35);
            pattern = pattern == null ? newPattern : SearchPattern.createOrPattern(pattern, newPattern);
        }
        return pattern;
    }

    private boolean isInteresting(IJavaElement element) {
        return element instanceof IMember && GroovyNature.hasGroovyNature(element.getJavaProject().getProject());
    }

    private IMethod findSyntheticMember(IJavaElement element, String prefix) throws JavaModelException {
        String[] names;
        String[] sigs;
        if (element.getElementType() != 8) {
            return null;
        }
        IType parent = (IType)element.getParent();
        if (prefix.equals("set")) {
            sigs = new String[]{((IField)element).getTypeSignature()};
            names = new String[]{element.getElementName()};
        } else {
            sigs = new String[]{};
            names = new String[]{};
        }
        MethodWrapper method = new MethodWrapper(parent.getMethod(this.convertName(prefix, element.getElementName()), sigs), names);
        return method.reallyExists() ? null : method;
    }

    private IField findSyntheticProperty(IJavaElement element) throws JavaModelException {
        int prefixLength;
        if (element.getElementType() != 9) {
            return null;
        }
        String name = element.getElementName();
        if (name.length() <= 2) {
            return null;
        }
        if (name.startsWith("is")) {
            prefixLength = 2;
        } else {
            if (name.length() == 3) {
                return null;
            }
            prefixLength = 3;
        }
        String fieldName = Character.toLowerCase(name.charAt(prefixLength)) + name.substring(prefixLength + 1);
        IType parent = (IType)element.getParent();
        IField field = parent.getField(fieldName);
        return field.exists() && Flags.isProtected(field.getFlags()) ? null : field;
    }

    private String convertName(String prefix, String elementName) {
        return String.valueOf(prefix) + Character.toUpperCase(elementName.charAt(0)) + elementName.subSequence(1, elementName.length());
    }

    public class MethodWrapper
    implements IMethod {
        private final IMethod delegate;
        private final String[] parameterNames;

        public MethodWrapper(IMethod method, String[] parameterNames) {
            this.delegate = method;
            this.parameterNames = parameterNames;
        }

        public String[] getCategories() throws JavaModelException {
            return ((IMember)this.delegate.getParent()).getCategories();
        }

        public IClassFile getClassFile() {
            return this.delegate.getClassFile();
        }

        public ICompilationUnit getCompilationUnit() {
            return this.delegate.getCompilationUnit();
        }

        public IType getDeclaringType() {
            return this.delegate.getDeclaringType();
        }

        public int getFlags() throws JavaModelException {
            return ((IMember)this.delegate.getParent()).getFlags();
        }

        public ISourceRange getJavadocRange() throws JavaModelException {
            return ((IMember)this.delegate.getParent()).getJavadocRange();
        }

        public int getOccurrenceCount() {
            return this.delegate.getOccurrenceCount();
        }

        public ITypeRoot getTypeRoot() {
            return this.delegate.getTypeRoot();
        }

        public IType getType(String name, int occurrenceCount) {
            return this.delegate.getType(name, occurrenceCount);
        }

        public boolean isBinary() {
            return this.delegate.isBinary();
        }

        public boolean exists() {
            return true;
        }

        public IJavaElement getAncestor(int ancestorType) {
            return this.delegate.getAncestor(ancestorType);
        }

        public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
            return this.delegate.getParent().getAttachedJavadoc(monitor);
        }

        public IResource getCorrespondingResource() throws JavaModelException {
            return this.delegate.getParent().getCorrespondingResource();
        }

        public int getElementType() {
            return this.delegate.getElementType();
        }

        public String getHandleIdentifier() {
            return this.delegate.getHandleIdentifier();
        }

        public IJavaModel getJavaModel() {
            return this.delegate.getJavaModel();
        }

        public IJavaProject getJavaProject() {
            return this.delegate.getJavaProject();
        }

        public IOpenable getOpenable() {
            return this.delegate.getOpenable();
        }

        public IJavaElement getParent() {
            return this.delegate.getParent();
        }

        public IPath getPath() {
            return this.delegate.getPath();
        }

        public IJavaElement getPrimaryElement() {
            return this.delegate.getPrimaryElement();
        }

        public IResource getResource() {
            return this.delegate.getResource();
        }

        public ISchedulingRule getSchedulingRule() {
            return this.delegate.getSchedulingRule();
        }

        public IResource getUnderlyingResource() throws JavaModelException {
            return this.delegate.getParent().getUnderlyingResource();
        }

        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        public boolean isStructureKnown() throws JavaModelException {
            return this.delegate.getParent().isStructureKnown();
        }

        public Object getAdapter(Class adapter) {
            return this.delegate.getAdapter(adapter);
        }

        public String getSource() throws JavaModelException {
            return ((ISourceReference)((Object)this.delegate.getParent())).getSource();
        }

        public ISourceRange getSourceRange() throws JavaModelException {
            return ((ISourceReference)((Object)this.delegate.getParent())).getSourceRange();
        }

        public ISourceRange getNameRange() throws JavaModelException {
            return ((IMethod)this.delegate.getParent()).getNameRange();
        }

        public void copy(IJavaElement container, IJavaElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws JavaModelException {
            this.delegate.copy(container, sibling, rename, replace, monitor);
        }

        public void delete(boolean force, IProgressMonitor monitor) throws JavaModelException {
            this.delegate.delete(force, monitor);
        }

        public void move(IJavaElement container, IJavaElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws JavaModelException {
            this.delegate.move(container, sibling, rename, replace, monitor);
        }

        public void rename(String name, boolean replace, IProgressMonitor monitor) throws JavaModelException {
            this.delegate.rename(name, replace, monitor);
        }

        public IJavaElement[] getChildren() throws JavaModelException {
            return new IJavaElement[0];
        }

        public boolean hasChildren() throws JavaModelException {
            return false;
        }

        public IAnnotation getAnnotation(String name) {
            return this.delegate.getAnnotation(name);
        }

        public IAnnotation[] getAnnotations() throws JavaModelException {
            return ((IAnnotatable)((Object)this.delegate.getParent())).getAnnotations();
        }

        public IMemberValuePair getDefaultValue() throws JavaModelException {
            return null;
        }

        public String getElementName() {
            return this.delegate.getElementName();
        }

        public String[] getExceptionTypes() throws JavaModelException {
            return new String[0];
        }

        public String[] getTypeParameterSignatures() throws JavaModelException {
            return new String[0];
        }

        public ITypeParameter[] getTypeParameters() throws JavaModelException {
            return new ITypeParameter[0];
        }

        public int getNumberOfParameters() {
            return this.delegate.getNumberOfParameters();
        }

        public ILocalVariable[] getParameters() throws JavaModelException {
            return new ILocalVariable[0];
        }

        public String getKey() {
            return this.delegate.getKey();
        }

        public String[] getParameterNames() throws JavaModelException {
            return this.parameterNames;
        }

        public String[] getParameterTypes() {
            return this.delegate.getParameterTypes();
        }

        public String[] getRawParameterNames() throws JavaModelException {
            return this.parameterNames;
        }

        public String getReturnType() throws JavaModelException {
            return this.delegate.getReturnType();
        }

        public String getSignature() throws JavaModelException {
            return this.delegate.getSignature();
        }

        public ITypeParameter getTypeParameter(String name) {
            return this.delegate.getTypeParameter(name);
        }

        public boolean isConstructor() throws JavaModelException {
            return false;
        }

        public boolean isMainMethod() throws JavaModelException {
            return false;
        }

        public boolean isResolved() {
            return false;
        }

        public boolean isSimilar(IMethod method) {
            return this.delegate.isSimilar(method);
        }

        public boolean reallyExists() {
            return this.delegate.exists();
        }

        public boolean isLambdaMethod() {
            return false;
        }
    }

    private class Requestor
    extends SearchRequestor {
        private final ISearchRequestor uiRequestor;

        public Requestor(ISearchRequestor uiRequestor) {
            this.uiRequestor = uiRequestor;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.uiRequestor.acceptMatch(match);
        }
    }
}

