/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.adapters;

import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;

public class GroovyFileAdapterFactory
implements IAdapterFactory {
    private static final Class[] classes = new Class[]{ClassNode.class, ClassNode[].class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IFile file;
        ClassNode[] returnValue = null;
        if (adaptableObject instanceof IFile && ContentTypeUtils.isGroovyLikeFileName((file = (IFile)adaptableObject).getName()) && (ClassNode.class.equals((Object)adapterType) || ClassNode[].class.equals((Object)adapterType))) {
            try {
                List<ClassNode> classNodeList;
                GroovyCompilationUnit unit = (GroovyCompilationUnit)JavaCore.createCompilationUnitFrom(file);
                ModuleNode module = unit.getModuleNode();
                if (module != null && (classNodeList = module.getClasses()) != null && !classNodeList.isEmpty()) {
                    if (ClassNode.class.equals((Object)adapterType)) {
                        returnValue = classNodeList.get(0);
                    } else if (ClassNode[].class.equals((Object)adapterType)) {
                        returnValue = classNodeList.toArray(new ClassNode[0]);
                    }
                }
            }
            catch (Exception ex) {
                GroovyCore.logException("error adapting file to ClassNode", ex);
            }
        }
        return returnValue;
    }

    public Class[] getAdapterList() {
        return classes;
    }
}

