/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindSurroundingNode;
import org.codehaus.groovy.eclipse.core.util.VisitCompleteException;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTTools;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferences;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.groovy.core.util.DepthFirstVisitor;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.PromoteTempToFieldRefactoring;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ConvertGroovyLocalToFieldRefactoring
extends PromoteTempToFieldRefactoring {
    private GroovyCompilationUnit unit;
    private String fieldName;
    private int fieldVisibility = -1;
    private int selectionStart;
    private int selectionLength;
    private IASTFragment selectionFragment;
    private VariableExpression variableExpressionInDeclaration;
    private DeclarationExpression declarationExpression;
    private ClassNode containingClassNode;
    private ModuleNode moduleNode;
    private MethodNode methodNode;
    private CompilationUnitChange change;

    public ConvertGroovyLocalToFieldRefactoring(GroovyCompilationUnit unit, int selectionStart, int selectionLength) {
        super((ICompilationUnit)unit, selectionStart, selectionLength);
        this.unit = unit;
        this.selectionStart = selectionStart;
        this.selectionLength = selectionLength;
    }

    public String getName() {
        return RefactoringCoreMessages.PromoteTempToFieldRefactoring_editName;
    }

    public int getVisibility() {
        if (this.fieldVisibility == -1) {
            this.fieldVisibility = (Integer)ReflectionUtils.getPrivateField(PromoteTempToFieldRefactoring.class, "fVisibility", this);
        }
        return this.fieldVisibility;
    }

    public boolean getDeclareFinal() {
        return false;
    }

    public boolean getDeclareStatic() {
        return false;
    }

    public String getFieldName() {
        if (this.fieldName == null) {
            this.fieldName = (String)ReflectionUtils.getPrivateField(PromoteTempToFieldRefactoring.class, "fFieldName", this);
        }
        if ((this.fieldName == null || this.fieldName.length() == 0) && this.variableExpressionInDeclaration != null) {
            this.fieldName = this.variableExpressionInDeclaration.getName();
        }
        return this.fieldName;
    }

    public int getInitializeIn() {
        return 1;
    }

    public void setVisibility(int accessModifier) {
        super.setVisibility(accessModifier);
        this.fieldVisibility = accessModifier;
    }

    public void setDeclareFinal(boolean declareFinal) {
    }

    public void setDeclareStatic(boolean declareStatic) {
    }

    public void setFieldName(String fieldName) {
        super.setFieldName(fieldName);
        this.fieldName = fieldName;
    }

    public void setInitializeIn(int initializeIn) {
    }

    public boolean canEnableSettingStatic() {
        return false;
    }

    public boolean canEnableSettingFinal() {
        return false;
    }

    public boolean canEnableSettingDeclareInConstructors() {
        return false;
    }

    public boolean canEnableSettingDeclareInMethod() {
        return true;
    }

    public boolean canEnableSettingDeclareInFieldDeclaration() {
        return false;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 5);
        RefactoringStatus result = Checks.validateEdit((ICompilationUnit)this.unit, (Object)this.getValidationContext());
        if (result.hasFatalError()) {
            return result;
        }
        monitor.worked(1);
        IASTFragment selectionFragment = this.getSelectionFragment();
        if (selectionFragment == null) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_select_declaration));
            return result;
        }
        Expression selectedExpression = selectionFragment.getAssociatedExpression();
        if (!(selectedExpression instanceof VariableExpression)) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_select_declaration));
            return result;
        }
        monitor.worked(1);
        VariableExpression selectedVariableExpression = (VariableExpression)selectedExpression;
        Variable declaredVariable = selectedVariableExpression.getAccessedVariable();
        if (declaredVariable instanceof DynamicVariable) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot convert dynamic variable."));
            return result;
        }
        if (declaredVariable instanceof Parameter || this.isTailRecursiveMethodParameter(selectedVariableExpression)) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_method_parameters));
            return result;
        }
        if (!(declaredVariable instanceof VariableExpression)) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_select_declaration));
            return result;
        }
        monitor.worked(1);
        VariableExpression variableExpressionInDeclaration = (VariableExpression)declaredVariable;
        DeclarationExpression declarationExpression = this.getDeclarationExpression(variableExpressionInDeclaration);
        if (declarationExpression == null) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot find variable declaration."));
            return result;
        }
        if (declarationExpression.isMultipleAssignmentDeclaration()) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot convert a variable declared using multiple assignment."));
            return result;
        }
        monitor.worked(1);
        this.variableExpressionInDeclaration = variableExpressionInDeclaration;
        ClassNode containingClass = this.getContainingClassNode();
        if (containingClass == null) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot find enclosing class declaration."));
            return result;
        }
        if (containingClass.isInterface() || containingClass.isAnnotationDefinition()) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot add field to an interface or annotation definition."));
            return result;
        }
        monitor.worked(1);
        return result;
    }

    public String[] guessFieldNames() {
        return new String[]{this.variableExpressionInDeclaration.getName()};
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        try {
            TextEdit edit;
            monitor.beginTask("", 4);
            FieldNode conflictingField = this.getContainingClassNode().getDeclaredField(this.getFieldName());
            if (conflictingField != null) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_Name_conflict_with_field);
            }
            monitor.worked(1);
            CompilationUnitChange change = new CompilationUnitChange("Convert Groovy Local Variable To Field", (ICompilationUnit)this.unit);
            change.setEdit((TextEdit)new MultiTextEdit());
            TextEditGroup group = this.createFieldTextEditGroup();
            change.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)change, group));
            TextEdit[] textEditArray = group.getTextEdits();
            int n = textEditArray.length;
            int n2 = 0;
            while (n2 < n) {
                edit = textEditArray[n2];
                change.addEdit(edit);
                ++n2;
            }
            monitor.worked(1);
            group = this.declarationToReferenceTextEditGroup();
            change.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)change, group));
            textEditArray = group.getTextEdits();
            n = textEditArray.length;
            n2 = 0;
            while (n2 < n) {
                edit = textEditArray[n2];
                change.addEdit(edit);
                ++n2;
            }
            monitor.worked(1);
            RefactoringStatus status = new RefactoringStatus();
            group = this.renameVariableReferencesTextEditGroup(status);
            change.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)change, group));
            TextEdit[] textEditArray2 = group.getTextEdits();
            int n3 = textEditArray2.length;
            n = 0;
            while (n < n3) {
                TextEdit edit2 = textEditArray2[n];
                change.addEdit(edit2);
                ++n;
            }
            monitor.worked(1);
            this.change = change;
            return status;
        }
        catch (BadLocationException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    private TextEditGroup createFieldTextEditGroup() throws BadLocationException {
        InsertEdit textEdit = null;
        ClassNode containingClass = this.getContainingClassNode();
        MethodNode containingMethod = this.getContainingMethodNode();
        if (containingMethod != null && containingMethod.isScriptBody() && this.getContainingClosureExpression() == null) {
            textEdit = new InsertEdit(this.getDeclarationOffset(), "@groovy.transform.Field ");
        } else if (containingClass != null && containingClass.isScript()) {
            textEdit = new InsertEdit(containingClass.getStart(), String.valueOf(this.createFieldText(0)) + ASTTools.getLineDelimeter(this.unit));
        } else {
            char[] contents = this.unit.getContents();
            int indentationLevel = 1;
            if (containingMethod != null && containingMethod.getEnd() > 0) {
                int methodLineOffset = containingMethod.getStart() - containingMethod.getColumnNumber() + 1;
                String methodIndentation = String.valueOf(CharOperation.subarray(contents, methodLineOffset, containingMethod.getStart()));
                indentationLevel = ASTTools.getCurrentIntentation(methodIndentation);
            }
            int insertOffset = CharOperation.indexOf('{', contents, containingClass.getStart()) + 1;
            String fieldText = this.createFieldText(indentationLevel);
            String newline = ASTTools.getLineDelimeter(this.unit);
            textEdit = new InsertEdit(insertOffset, String.valueOf(newline) + fieldText);
        }
        TextEditGroup group = new TextEditGroup("Create field.");
        if (textEdit != null) {
            group.addTextEdit((TextEdit)textEdit);
        }
        return group;
    }

    private String createFieldText(int indentLevel) throws BadLocationException, MalformedTreeException {
        StringBuilder sb = new StringBuilder();
        String indentation = CodeFormatterUtil.createIndentString((int)indentLevel, (IJavaProject)this.unit.getJavaProject());
        sb.append(indentation);
        if (this.getContainingClassNode().isScript()) {
            sb.append("@groovy.transform.Field ");
        } else {
            String visibility = JdtFlags.getVisibilityString((int)this.getVisibility());
            if (!"".equals(visibility)) {
                sb.append(visibility).append(' ');
            }
        }
        char[] typeOrDef = CharOperation.subarray(this.unit.getContents(), this.getDeclarationOffset(), this.variableExpressionInDeclaration.getStart());
        sb.append(typeOrDef).append(this.getFieldName());
        Document doc = new Document(sb.toString());
        DefaultGroovyFormatter formatter = new DefaultGroovyFormatter((IDocument)doc, new FormatterPreferences(this.unit), indentLevel);
        TextEdit edit = formatter.format();
        edit.apply((IDocument)doc);
        return doc.get();
    }

    private TextEditGroup declarationToReferenceTextEditGroup() {
        TextEditGroup group = new TextEditGroup("Convert local variable declaration to reference.");
        if (this.getContainingMethodNode() != null && !this.getContainingMethodNode().isScriptBody() || this.getContainingClosureExpression() != null) {
            int typeOrDefLength = this.variableExpressionInDeclaration.getStart() - this.getDeclarationOffset();
            group.addTextEdit((TextEdit)new ReplaceEdit(this.getDeclarationOffset(), typeOrDefLength, ""));
        }
        return group;
    }

    private TextEditGroup renameVariableReferencesTextEditGroup(RefactoringStatus status) {
        TextEditGroup group = new TextEditGroup("Update local variables to reference field.");
        if (this.getContainingMethodNode() != null && !this.getContainingMethodNode().isScriptBody() || this.getContainingClosureExpression() != null) {
            final HashSet references = new HashSet();
            DepthFirstVisitor referencesVisitor = new DepthFirstVisitor(){

                @Override
                public void visitVariableExpression(VariableExpression variableExpression) {
                    if (variableExpression.getAccessedVariable() == ConvertGroovyLocalToFieldRefactoring.this.variableExpressionInDeclaration && variableExpression.getLineNumber() >= 0) {
                        references.add(variableExpression);
                    }
                }
            };
            referencesVisitor.visitClass(this.getContainingClassNode());
            Iterator<InnerClassNode> it = this.getContainingClassNode().getInnerClasses();
            while (it.hasNext()) {
                InnerClassNode innerClass = it.next();
                referencesVisitor.visitClass(innerClass);
            }
            for (VariableExpression reference : references) {
                if (this.getUsedVariableAndFieldNames(reference).contains(this.getFieldName())) {
                    status.merge(RefactoringStatus.createWarningStatus((String)"New field conflicts with existing name."));
                }
                group.addTextEdit((TextEdit)new ReplaceEdit(reference.getStart(), reference.getLength(), this.getFieldName()));
            }
        }
        return group;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        return this.change;
    }

    private IASTFragment getSelectionFragment() {
        if (this.selectionFragment == null) {
            this.selectionFragment = ASTTools.getSelectionFragment(this.getModuleNode(), this.selectionStart, this.selectionLength);
        }
        return this.selectionFragment;
    }

    private ModuleNode getModuleNode() {
        if (this.moduleNode == null) {
            this.moduleNode = this.unit.getModuleNode();
        }
        return this.moduleNode;
    }

    private ClassNode getContainingClassNode() {
        if (this.containingClassNode == null) {
            if (this.getModuleNode() == null) {
                return null;
            }
            if (this.declarationExpression == null) {
                return null;
            }
            this.containingClassNode = ASTTools.getContainingClassNode(this.getModuleNode(), this.variableExpressionInDeclaration.getStart());
        }
        return this.containingClassNode;
    }

    private MethodNode getContainingMethodNode() {
        if (this.methodNode == null) {
            this.methodNode = (ConvertGroovyLocalToFieldRefactoring)this.new VariableExpressionFinder((VariableExpression)this.variableExpressionInDeclaration).method;
        }
        return this.methodNode;
    }

    private ClosureExpression getContainingClosureExpression() {
        return (ConvertGroovyLocalToFieldRefactoring)this.new VariableExpressionFinder((VariableExpression)this.variableExpressionInDeclaration).closure;
    }

    private DeclarationExpression getDeclarationExpression(VariableExpression variableExpressionInDeclaration) {
        if (this.declarationExpression == null) {
            this.declarationExpression = (ConvertGroovyLocalToFieldRefactoring)this.new VariableExpressionFinder((VariableExpression)variableExpressionInDeclaration).declaration;
        }
        return this.declarationExpression;
    }

    private int getDeclarationOffset() {
        if (this.declarationExpression.getEnd() > 0) {
            return this.declarationExpression.getStart();
        }
        if (!this.declarationExpression.getAnnotations().isEmpty()) {
            return this.declarationExpression.getAnnotations().get(0).getStart() - 1;
        }
        throw new IllegalStateException("No start offset for declaration expression on line " + this.variableExpressionInDeclaration.getLineNumber());
    }

    private Set<String> getUsedVariableAndFieldNames(VariableExpression variableExpression) {
        FindSurroundingNode find = new FindSurroundingNode(new Region((ASTNode)variableExpression), FindSurroundingNode.VisitKind.PARENT_STACK);
        find.doVisitSurroundingNode(this.moduleNode);
        ArrayList parentStack = new ArrayList(find.getParentStack());
        Collections.reverse(parentStack);
        HashSet<String> result = new HashSet<String>();
        for (IASTFragment fragment : parentStack) {
            ASTNode astNode = fragment.getAssociatedNode();
            VariableScope scope = null;
            if (astNode instanceof BlockStatement) {
                scope = ((BlockStatement)astNode).getVariableScope();
            } else if (astNode instanceof MethodNode) {
                scope = ((MethodNode)astNode).getVariableScope();
            } else if (astNode instanceof ClosureExpression) {
                scope = ((ClosureExpression)astNode).getVariableScope();
            } else if (astNode instanceof ClassNode) {
                for (FieldNode field : ((ClassNode)astNode).getFields()) {
                    if (field.getLineNumber() <= 0) continue;
                    result.add(field.getName());
                }
            }
            if (scope == null) continue;
            Iterator<Variable> declaredVariables = scope.getDeclaredVariablesIterator();
            while (declaredVariables.hasNext()) {
                Variable variable = declaredVariables.next();
                if (variable instanceof VariableExpression) {
                    VariableExpression varExpression = (VariableExpression)variable;
                    if (varExpression.getAccessedVariable() == variableExpression.getAccessedVariable()) continue;
                    result.add(variable.getName());
                    continue;
                }
                result.add(variable.getName());
            }
        }
        return result;
    }

    private boolean isTailRecursiveMethodParameter(VariableExpression variableExpression) {
        MethodNode method = (ConvertGroovyLocalToFieldRefactoring)this.new VariableExpressionFinder((VariableExpression)variableExpression).method;
        if (method != null) {
            for (AnnotationNode annotation : method.getAnnotations()) {
                if (!annotation.getClassNode().getName().equals("groovy.transform.TailRecursive")) continue;
                return variableExpression.getName().matches("_\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*_");
            }
        }
        return false;
    }

    private class VariableExpressionFinder
    extends DepthFirstVisitor {
        DeclarationExpression declaration;
        ClosureExpression closure;
        MethodNode method;

        VariableExpressionFinder(final VariableExpression variableExpressionInDeclaration) {
            DepthFirstVisitor visitor = new DepthFirstVisitor(){

                @Override
                public void visitMethod(MethodNode node) {
                    VariableExpressionFinder.this.method = node;
                    super.visitMethod(node);
                    VariableExpressionFinder.this.method = null;
                }

                @Override
                public void visitClosureExpression(ClosureExpression expr) {
                    VariableExpressionFinder.this.closure = expr;
                    super.visitClosureExpression(expr);
                    VariableExpressionFinder.this.closure = null;
                }

                @Override
                public void visitDeclarationExpression(DeclarationExpression expr) {
                    VariableExpressionFinder.this.declaration = expr;
                    super.visitDeclarationExpression(expr);
                    VariableExpressionFinder.this.declaration = null;
                }

                @Override
                public void visitVariableExpression(VariableExpression expr) {
                    if (expr == variableExpressionInDeclaration) {
                        throw new VisitCompleteException();
                    }
                    super.visitVariableExpression(expr);
                }
            };
            try {
                visitor.visitModule(ConvertGroovyLocalToFieldRefactoring.this.getModuleNode());
            }
            catch (VisitCompleteException visitCompleteException) {
                // empty catch block
            }
        }
    }
}

