/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.builder;

import java.util.ArrayList;
import org.codehaus.groovy.eclipse.core.builder.GroovyClasspathContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;

public class GroovyClasspathContainerInitializer
extends ClasspathContainerInitializer {
    @Override
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        GroovyClasspathContainer container = new GroovyClasspathContainer(project);
        JavaCore.setClasspathContainer(containerPath, new IJavaProject[]{project}, new IClasspathContainer[]{container}, null);
    }

    @Override
    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    @Override
    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        IClasspathContainer gcc;
        if (containerSuggestion instanceof GroovyClasspathContainer) {
            ((GroovyClasspathContainer)containerSuggestion).reset();
        }
        if ((gcc = JavaCore.getClasspathContainer(GroovyClasspathContainer.CONTAINER_ID, project)) instanceof GroovyClasspathContainer) {
            ((GroovyClasspathContainer)gcc).reset();
        }
    }

    public static void updateAllGroovyClasspathContainers() throws JavaModelException {
        IJavaProject[] projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
        GroovyClasspathContainerInitializer.updateSomeGroovyClasspathContainers(projects);
    }

    public static void updateGroovyClasspathContainer(IJavaProject project) throws JavaModelException {
        GroovyClasspathContainerInitializer.updateSomeGroovyClasspathContainers(project);
    }

    private static void updateSomeGroovyClasspathContainers(IJavaProject ... projects) throws JavaModelException {
        ArrayList<IJavaProject> affectedProjects = new ArrayList<IJavaProject>(projects.length);
        ArrayList affectedContainers = new ArrayList(projects.length);
        IJavaProject[] iJavaProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject elt = iJavaProjectArray[n2];
            IJavaProject project = elt;
            IClasspathContainer gcc = JavaCore.getClasspathContainer(GroovyClasspathContainer.CONTAINER_ID, project);
            if (gcc instanceof GroovyClasspathContainer) {
                ((GroovyClasspathContainer)gcc).reset();
                affectedProjects.add(project);
                affectedContainers.add(null);
            }
            ++n2;
        }
        JavaCore.setClasspathContainer(GroovyClasspathContainer.CONTAINER_ID, affectedProjects.toArray(new IJavaProject[0]), affectedContainers.toArray(new IClasspathContainer[0]), (IProgressMonitor)new NullProgressMonitor());
    }
}

