/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.operator;

import com.annimon.stream.internal.Compat;
import com.annimon.stream.iterator.LsaIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class ObjSlidingWindow<T>
extends LsaIterator<List<T>> {
    private final Queue<T> queue;
    private final Iterator<? extends T> iterator;
    private final int windowSize;
    private final int stepWidth;

    public ObjSlidingWindow(@NotNull Iterator<? extends T> iterator, int windowSize, int stepWidth) {
        this.iterator = iterator;
        this.windowSize = windowSize;
        this.stepWidth = stepWidth;
        this.queue = Compat.queue();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<T> nextIteration() {
        int j;
        for (int i = this.queue.size(); i < this.windowSize && this.iterator.hasNext(); ++i) {
            this.queue.offer(this.iterator.next());
        }
        ArrayList<T> list = new ArrayList<T>(this.queue);
        int pollCount = Math.min(this.queue.size(), this.stepWidth);
        for (j = 0; j < pollCount; ++j) {
            this.queue.poll();
        }
        for (j = this.windowSize; j < this.stepWidth && this.iterator.hasNext(); ++j) {
            this.iterator.next();
        }
        return list;
    }
}

