/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.internal;

import com.annimon.stream.function.IntFunction;
import com.annimon.stream.internal.Compat;
import com.annimon.stream.internal.SpinedBuffer;
import com.annimon.stream.iterator.PrimitiveIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Operators {
    private Operators() {
    }

    @NotNull
    public static <T> List<T> toList(@NotNull Iterator<? extends T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    @NotNull
    public static <T, R> R[] toArray(@NotNull Iterator<? extends T> iterator, @NotNull IntFunction<R[]> generator) {
        List<Object> container = Operators.toList(iterator);
        int size = container.size();
        Compat.checkMaxArraySize(size);
        Object[] source = container.toArray(Compat.newArray(size, new Object[0]));
        R[] boxed = generator.apply(size);
        System.arraycopy(source, 0, boxed, 0, size);
        return boxed;
    }

    @NotNull
    public static int[] toIntArray(@NotNull PrimitiveIterator.OfInt iterator) {
        SpinedBuffer.OfInt b = new SpinedBuffer.OfInt();
        while (iterator.hasNext()) {
            b.accept(iterator.nextInt());
        }
        return (int[])b.asPrimitiveArray();
    }

    @NotNull
    public static long[] toLongArray(@NotNull PrimitiveIterator.OfLong iterator) {
        SpinedBuffer.OfLong b = new SpinedBuffer.OfLong();
        while (iterator.hasNext()) {
            b.accept(iterator.nextLong());
        }
        return (long[])b.asPrimitiveArray();
    }

    @NotNull
    public static double[] toDoubleArray(@NotNull PrimitiveIterator.OfDouble iterator) {
        SpinedBuffer.OfDouble b = new SpinedBuffer.OfDouble();
        while (iterator.hasNext()) {
            b.accept(iterator.nextDouble());
        }
        return (double[])b.asPrimitiveArray();
    }
}

