/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.internal;

import java.io.Closeable;
import java.util.Iterator;
import java.util.List;

public final class Compose {
    private Compose() {
    }

    public static Runnable runnables(final Runnable a, final Runnable b) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    a.run();
                }
                catch (Throwable e1) {
                    try {
                        b.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Compose.handleException(e1);
                }
                b.run();
            }
        };
    }

    public static Runnable closeables(final Closeable a, final Closeable b) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    a.close();
                }
                finally {
                    try {
                        b.close();
                    }
                    catch (Throwable e2) {
                        Compose.handleException(e2);
                    }
                }
            }
        };
    }

    public static Runnable closeables(final List<? extends Closeable> closeables) {
        return new Runnable(){

            @Override
            public void run() {
                Iterator iterator = closeables.iterator();
                while (iterator.hasNext()) {
                    try {
                        ((Closeable)iterator.next()).close();
                    }
                    catch (Throwable currentExc) {
                        while (iterator.hasNext()) {
                            try {
                                ((Closeable)iterator.next()).close();
                            }
                            catch (Throwable throwable) {}
                        }
                        Compose.handleException(currentExc);
                    }
                }
            }
        };
    }

    private static Throwable handleException(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }
}

