/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableLongFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LongFunction<R> {
    public R apply(long var1);

    public static class Util {
        private Util() {
        }

        public static <R> LongFunction<R> safe(@NotNull ThrowableLongFunction<? extends R, Throwable> throwableFunction) {
            return Util.safe(throwableFunction, null);
        }

        public static <R> LongFunction<R> safe(final @NotNull ThrowableLongFunction<? extends R, Throwable> throwableFunction, final @Nullable R resultIfFailed) {
            Objects.requireNonNull(throwableFunction);
            return new LongFunction<R>(){

                @Override
                public R apply(long value) {
                    try {
                        return throwableFunction.apply(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

