/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableIntSupplier;
import org.jetbrains.annotations.NotNull;

public interface IntSupplier {
    public int getAsInt();

    public static class Util {
        private Util() {
        }

        public static IntSupplier safe(@NotNull ThrowableIntSupplier<Throwable> throwableSupplier) {
            return Util.safe(throwableSupplier, 0);
        }

        public static IntSupplier safe(final @NotNull ThrowableIntSupplier<Throwable> throwableSupplier, final int resultIfFailed) {
            Objects.requireNonNull(throwableSupplier);
            return new IntSupplier(){

                @Override
                public int getAsInt() {
                    try {
                        return throwableSupplier.getAsInt();
                    }
                    catch (Throwable ex) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

