/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableDoubleSupplier;
import org.jetbrains.annotations.NotNull;

public interface DoubleSupplier {
    public double getAsDouble();

    public static class Util {
        private Util() {
        }

        public static DoubleSupplier safe(@NotNull ThrowableDoubleSupplier<Throwable> throwableSupplier) {
            return Util.safe(throwableSupplier, 0.0);
        }

        public static DoubleSupplier safe(final @NotNull ThrowableDoubleSupplier<Throwable> throwableSupplier, final double resultIfFailed) {
            Objects.requireNonNull(throwableSupplier);
            return new DoubleSupplier(){

                @Override
                public double getAsDouble() {
                    try {
                        return throwableSupplier.getAsDouble();
                    }
                    catch (Throwable ex) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

