/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Objects;
import com.annimon.stream.OptionalBoolean;
import com.annimon.stream.OptionalDouble;
import com.annimon.stream.OptionalInt;
import com.annimon.stream.OptionalLong;
import com.annimon.stream.Stream;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Predicate;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToBooleanFunction;
import com.annimon.stream.function.ToDoubleFunction;
import com.annimon.stream.function.ToIntFunction;
import com.annimon.stream.function.ToLongFunction;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Optional<T> {
    private static final Optional<?> EMPTY = new Optional();
    @Nullable
    private final T value;

    @NotNull
    @Contract(value="_ -> new")
    public static <T> Optional<T> of(@NotNull T value) {
        return new Optional<T>(value);
    }

    @NotNull
    public static <T> Optional<T> ofNullable(@Nullable T value) {
        return value == null ? Optional.empty() : Optional.of(value);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    private Optional() {
        this.value = null;
    }

    private Optional(T value) {
        this.value = Objects.requireNonNull(value);
    }

    @NotNull
    public T get() {
        return this.orElseThrow();
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void ifPresent(@NotNull Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(@NotNull Consumer<? super T> consumer, @NotNull Runnable emptyAction) {
        if (this.value != null) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    @NotNull
    public Optional<T> executeIfPresent(@NotNull Consumer<? super T> consumer) {
        this.ifPresent(consumer);
        return this;
    }

    @NotNull
    public Optional<T> executeIfAbsent(@NotNull Runnable action) {
        if (this.value == null) {
            action.run();
        }
        return this;
    }

    @Nullable
    public <R> R custom(@NotNull Function<Optional<T>, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    @NotNull
    public Optional<T> filter(@NotNull Predicate<? super T> predicate) {
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : Optional.empty();
    }

    @NotNull
    public Optional<T> filterNot(@NotNull Predicate<? super T> predicate) {
        return this.filter(Predicate.Util.negate(predicate));
    }

    @NotNull
    public <U> Optional<U> map(@NotNull Function<? super T, ? extends U> mapper) {
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.value));
    }

    @NotNull
    public OptionalInt mapToInt(@NotNull ToIntFunction<? super T> mapper) {
        if (!this.isPresent()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(mapper.applyAsInt(this.value));
    }

    @NotNull
    public OptionalLong mapToLong(@NotNull ToLongFunction<? super T> mapper) {
        if (!this.isPresent()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(mapper.applyAsLong(this.value));
    }

    @NotNull
    public OptionalDouble mapToDouble(@NotNull ToDoubleFunction<? super T> mapper) {
        if (!this.isPresent()) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(mapper.applyAsDouble(this.value));
    }

    @NotNull
    public OptionalBoolean mapToBoolean(@NotNull ToBooleanFunction<? super T> mapper) {
        if (!this.isPresent()) {
            return OptionalBoolean.empty();
        }
        return OptionalBoolean.of(mapper.applyAsBoolean(this.value));
    }

    @NotNull
    public <U> Optional<U> flatMap(@NotNull Function<? super T, Optional<U>> mapper) {
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.value));
    }

    @NotNull
    public Stream<T> stream() {
        if (!this.isPresent()) {
            return Stream.empty();
        }
        return Stream.of(this.value);
    }

    @NotNull
    public <R> Optional<R> select(@NotNull Class<R> clazz) {
        Objects.requireNonNull(clazz);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(clazz.isInstance(this.value) ? (T)this.value : null);
    }

    @NotNull
    public Optional<T> or(@NotNull Supplier<Optional<T>> supplier) {
        if (this.isPresent()) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    @Nullable
    public T orElse(@Nullable T other) {
        return this.value != null ? this.value : other;
    }

    @Nullable
    public T orElseGet(@NotNull Supplier<? extends T> other) {
        return this.value != null ? this.value : other.get();
    }

    @NotNull
    public T orElseThrow() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    @NotNull
    public <X extends Throwable> T orElseThrow(@NotNull Supplier<? extends X> exc) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exc.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @NotNull
    public String toString() {
        return this.value != null ? String.format("Optional[%s]", this.value) : "Optional.empty";
    }
}

