/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Objects;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.ToDoubleFunction;
import com.annimon.stream.function.ToIntFunction;
import com.annimon.stream.function.ToLongFunction;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComparatorCompat<T>
implements Comparator<T> {
    private static final ComparatorCompat<Comparable<Object>> NATURAL_ORDER = new ComparatorCompat<Comparable<Object>>(new Comparator<Comparable<Object>>(){

        @Override
        public int compare(@NotNull Comparable<Object> o1, @NotNull Comparable<Object> o2) {
            return o1.compareTo(o2);
        }
    });
    private static final ComparatorCompat<Comparable<Object>> REVERSE_ORDER = new ComparatorCompat(Collections.reverseOrder());
    @NotNull
    private final Comparator<? super T> comparator;

    @NotNull
    public static <T extends Comparable<? super T>> ComparatorCompat<T> naturalOrder() {
        return NATURAL_ORDER;
    }

    @NotNull
    public static <T extends Comparable<? super T>> ComparatorCompat<T> reverseOrder() {
        return REVERSE_ORDER;
    }

    @NotNull
    public static <T> Comparator<T> reversed(@Nullable Comparator<T> comparator) {
        return Collections.reverseOrder(comparator);
    }

    @NotNull
    public static <T> Comparator<T> thenComparing(final @NotNull Comparator<? super T> c1, final @NotNull Comparator<? super T> c2) {
        Objects.requireNonNull(c1);
        Objects.requireNonNull(c2);
        return new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                int result = c1.compare(t1, t2);
                return result != 0 ? result : c2.compare(t1, t2);
            }
        };
    }

    @NotNull
    public static <T, U> ComparatorCompat<T> comparing(final @NotNull Function<? super T, ? extends U> keyExtractor, final @NotNull Comparator<? super U> keyComparator) {
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(keyComparator);
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                Object u1 = keyExtractor.apply(t1);
                Object u2 = keyExtractor.apply(t2);
                return keyComparator.compare(u1, u2);
            }
        });
    }

    @NotNull
    public static <T, U extends Comparable<? super U>> ComparatorCompat<T> comparing(final @NotNull Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                Comparable u1 = (Comparable)keyExtractor.apply(t1);
                Comparable u2 = (Comparable)keyExtractor.apply(t2);
                return u1.compareTo(u2);
            }
        });
    }

    @NotNull
    public static <T> ComparatorCompat<T> comparingInt(final @NotNull ToIntFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                int i1 = keyExtractor.applyAsInt(t1);
                int i2 = keyExtractor.applyAsInt(t2);
                return Objects.compareInt(i1, i2);
            }
        });
    }

    @NotNull
    public static <T> ComparatorCompat<T> comparingLong(final @NotNull ToLongFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                long l1 = keyExtractor.applyAsLong(t1);
                long l2 = keyExtractor.applyAsLong(t2);
                return Objects.compareLong(l1, l2);
            }
        });
    }

    @NotNull
    public static <T> ComparatorCompat<T> comparingDouble(final @NotNull ToDoubleFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                double d1 = keyExtractor.applyAsDouble(t1);
                double d2 = keyExtractor.applyAsDouble(t2);
                return Double.compare(d1, d2);
            }
        });
    }

    @NotNull
    public static <T> ComparatorCompat<T> nullsFirst() {
        return ComparatorCompat.nullsComparator(true, null);
    }

    @NotNull
    public static <T> ComparatorCompat<T> nullsFirst(@Nullable Comparator<? super T> comparator) {
        return ComparatorCompat.nullsComparator(true, comparator);
    }

    @NotNull
    public static <T> ComparatorCompat<T> nullsLast() {
        return ComparatorCompat.nullsComparator(false, null);
    }

    @NotNull
    public static <T> ComparatorCompat<T> nullsLast(@Nullable Comparator<? super T> comparator) {
        return ComparatorCompat.nullsComparator(false, comparator);
    }

    private static <T> ComparatorCompat<T> nullsComparator(final boolean nullFirst, final @Nullable Comparator<? super T> comparator) {
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(@Nullable T t1, @Nullable T t2) {
                if (t1 == null) {
                    return t2 == null ? 0 : (nullFirst ? -1 : 1);
                }
                if (t2 == null) {
                    return nullFirst ? 1 : -1;
                }
                return comparator == null ? 0 : comparator.compare(t1, t2);
            }
        });
    }

    @NotNull
    public static <T> ComparatorCompat<T> chain(@NotNull Comparator<T> comparator) {
        return new ComparatorCompat<T>(comparator);
    }

    public ComparatorCompat(@NotNull Comparator<? super T> comparator) {
        this.comparator = comparator;
    }

    @Override
    @NotNull
    public ComparatorCompat<T> reversed() {
        return new ComparatorCompat<T>(Collections.reverseOrder(this.comparator));
    }

    @Override
    @NotNull
    public ComparatorCompat<T> thenComparing(@NotNull Comparator<? super T> other) {
        return new ComparatorCompat<T>(ComparatorCompat.thenComparing(this.comparator, other));
    }

    @Override
    @NotNull
    public <U> ComparatorCompat<T> thenComparing(@NotNull Function<? super T, ? extends U> keyExtractor, @NotNull Comparator<? super U> keyComparator) {
        return this.thenComparing(ComparatorCompat.comparing(keyExtractor, keyComparator));
    }

    @Override
    @NotNull
    public <U extends Comparable<? super U>> ComparatorCompat<T> thenComparing(@NotNull Function<? super T, ? extends U> keyExtractor) {
        return this.thenComparing(ComparatorCompat.comparing(keyExtractor));
    }

    @Override
    @NotNull
    public ComparatorCompat<T> thenComparingInt(@NotNull ToIntFunction<? super T> keyExtractor) {
        return this.thenComparing(ComparatorCompat.comparingInt(keyExtractor));
    }

    @Override
    @NotNull
    public ComparatorCompat<T> thenComparingLong(@NotNull ToLongFunction<? super T> keyExtractor) {
        return this.thenComparing(ComparatorCompat.comparingLong(keyExtractor));
    }

    @Override
    @NotNull
    public ComparatorCompat<T> thenComparingDouble(@NotNull ToDoubleFunction<? super T> keyExtractor) {
        return this.thenComparing(ComparatorCompat.comparingDouble(keyExtractor));
    }

    @NotNull
    public Comparator<T> comparator() {
        return this.comparator;
    }

    @Override
    public int compare(T o1, T o2) {
        return this.comparator.compare(o1, o2);
    }
}

