/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.store.FeatureInfoList;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.tasks.databinding.ExportNamespacesParams;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.tooling.BuildException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/databinding/ExportNamespacesRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/databinding/ExportNamespacesParams;", "<init>", "()V", "run", "", "gradle-core"})
public abstract class ExportNamespacesRunnable
extends ProfileAwareWorkAction<ExportNamespacesParams> {
    @Override
    public void run() {
        Set packages = new LinkedHashSet();
        for (File featureSplitDeclaration : (Set)((ExportNamespacesParams)this.getParameters()).getFeatureDeclarations().get()) {
            try {
                FeatureSplitDeclaration loaded;
                Intrinsics.checkNotNullExpressionValue((Object)FeatureSplitDeclaration.load(featureSplitDeclaration), (String)"load(...)");
                String string = loaded.getNamespace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNamespace(...)");
                packages.add(string);
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Cannot read features split declaration file", (Throwable)e);
            }
        }
        File outputFolder = ((Directory)((ExportNamespacesParams)this.getParameters()).getPackageListOutFolder().get()).getAsFile();
        FileUtils.cleanOutputDir((File)outputFolder);
        outputFolder.mkdirs();
        new FeatureInfoList(packages).serialize(new File(outputFolder, "all_features.json"));
    }
}

