/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.component.features.OptimizationCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.MergeConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.OptimizationTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.OptimizationTaskCreationActionImpl;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Simple merging task")
@BuildAnalyzer(primaryTaskCategory=TaskCategory.OPTIMIZATION)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016R \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeConsumerProguardFilesTask;", "Lcom/android/build/gradle/internal/tasks/MergeFileTask;", "<init>", "()V", "value", "", "isDynamicFeature", "()Z", "isBaseModule", "consumerProguardFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getConsumerProguardFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "doTaskAction", "", "CreationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nMergeConsumerProguardFilesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeConsumerProguardFilesTask.kt\ncom/android/build/gradle/internal/tasks/MergeConsumerProguardFilesTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1863#2,2:129\n*S KotlinDebug\n*F\n+ 1 MergeConsumerProguardFilesTask.kt\ncom/android/build/gradle/internal/tasks/MergeConsumerProguardFilesTask\n*L\n73#1:129,2\n*E\n"})
public abstract class MergeConsumerProguardFilesTask
extends MergeFileTask {
    private boolean isDynamicFeature;
    private boolean isBaseModule;

    @Input
    public final boolean isDynamicFeature() {
        return this.isDynamicFeature;
    }

    @Input
    public final boolean isBaseModule() {
        return this.isBaseModule;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getConsumerProguardFiles();

    @Internal(value="only for task execution")
    @NotNull
    public abstract DirectoryProperty getBuildDirectory();

    @Override
    public void doTaskAction() throws IOException {
        Set consumerProguardFiles2 = this.getConsumerProguardFiles().getFiles();
        if (!this.isBaseModule) {
            DirectoryProperty directoryProperty = this.getBuildDirectory();
            Intrinsics.checkNotNull((Object)consumerProguardFiles2);
            ExportConsumerProguardFilesTask.Companion.checkProguardFiles(directoryProperty, this.isDynamicFeature, consumerProguardFiles2, doTaskAction.1.INSTANCE);
        }
        Intrinsics.checkNotNull((Object)consumerProguardFiles2);
        Iterable $this$forEach$iv = consumerProguardFiles2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            if (file.isFile()) continue;
            if (file.isDirectory()) {
                this.getLogger().warn("Directories as consumer proguard configuration are not supported: " + file.getPath());
                continue;
            }
            this.getLogger().warn("Supplied consumer proguard configuration does not exist: " + file.getPath());
        }
        super.doTaskAction();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0016\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeConsumerProguardFilesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/MergeConsumerProguardFilesTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "Lcom/android/build/gradle/internal/tasks/factory/features/OptimizationTaskCreationAction;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "optimizationCreationConfig", "Lcom/android/build/gradle/internal/component/features/OptimizationCreationConfig;", "getOptimizationCreationConfig", "()Lcom/android/build/gradle/internal/component/features/OptimizationCreationConfig;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<MergeConsumerProguardFilesTask, VariantCreationConfig>
    implements OptimizationTaskCreationAction {
        private final /* synthetic */ OptimizationTaskCreationActionImpl $$delegate_0;

        public CreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
            this.$$delegate_0 = new OptimizationTaskCreationActionImpl(creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("merge", "ConsumerProguardFiles");
        }

        @Override
        @NotNull
        public Class<MergeConsumerProguardFilesTask> getType() {
            return MergeConsumerProguardFilesTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<MergeConsumerProguardFilesTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("proguard.txt").on(InternalArtifactType.MERGED_CONSUMER_PROGUARD_FILE.INSTANCE);
        }

        @Override
        public void configure(@NotNull MergeConsumerProguardFilesTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.isBaseModule = ((VariantCreationConfig)this.creationConfig).getComponentType().isBaseModule();
            task.isDynamicFeature = ((VariantCreationConfig)this.creationConfig).getComponentType().isDynamicFeature();
            Object[] objectArray = new Object[]{this.getOptimizationCreationConfig().getConsumerProguardFiles()};
            task.getConsumerProguardFiles().from(objectArray);
            task.getConsumerProguardFiles().disallowChanges();
            Object[] objectArray2 = new Object[]{task.getConsumerProguardFiles(), ((VariantCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.GENERATED_PROGUARD_FILE.INSTANCE)};
            ConfigurableFileCollection inputFiles = ((VariantCreationConfig)this.creationConfig).getServices().fileCollection(objectArray2);
            objectArray2 = new Object[]{inputFiles};
            task.getInputFiles().from(objectArray2);
            task.getInputFiles().disallowChanges();
            Property property = (Property)task.getBuildDirectory();
            DirectoryProperty directoryProperty = task.getProject().getLayout().getBuildDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"getBuildDirectory(...)");
            HasConfigurableValuesKt.setDisallowChanges(property, (Provider)directoryProperty);
        }

        @Override
        @NotNull
        public OptimizationCreationConfig getOptimizationCreationConfig() {
            return this.$$delegate_0.getOptimizationCreationConfig();
        }
    }
}

