/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00052\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0005B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/services/LintParallelBuildService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "<init>", "()V", "Companion", "gradle-core"})
public abstract class LintParallelBuildService
implements BuildService<BuildServiceParameters.None> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/services/LintParallelBuildService$Companion;", "", "<init>", "()V", "calculateMaxParallelUsages", "", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "maxRuntimeMemory", "", "totalPhysicalMemory", "(Lcom/android/build/gradle/options/ProjectOptions;JLjava/lang/Long;)Ljava/lang/Integer;", "calculateMaxParallelUsagesInProcess", "calculateMaxParallelUsagesOutOfProcess", "calculateLintHeapSize", "", "userSpecifiedLintHeapSize", "parseMemorySize", "memorySize", "propertyName", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nLintParallelBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintParallelBuildService.kt\ncom/android/build/gradle/internal/services/LintParallelBuildService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Integer calculateMaxParallelUsages(@NotNull ProjectOptions projectOptions, long maxRuntimeMemory, @Nullable Long totalPhysicalMemory) {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
            if (projectOptions.get(BooleanOption.RUN_LINT_IN_PROCESS)) {
                n = this.calculateMaxParallelUsagesInProcess(projectOptions, maxRuntimeMemory);
            } else {
                Long l = totalPhysicalMemory;
                if (l == null) {
                    return null;
                }
                n = this.calculateMaxParallelUsagesOutOfProcess(projectOptions, maxRuntimeMemory, l);
            }
            return n;
        }

        private final int calculateMaxParallelUsagesInProcess(ProjectOptions projectOptions, long maxRuntimeMemory) {
            long l;
            String string = projectOptions.get(StringOption.LINT_RESERVED_MEMORY_PER_TASK);
            if (string != null) {
                String it = string;
                boolean bl = false;
                l = Companion.parseMemorySize(it, StringOption.LINT_RESERVED_MEMORY_PER_TASK.getPropertyName());
            } else {
                l = 0x20000000L;
            }
            long memoryPerLintTask = l;
            long maxLintMemory = (long)((double)maxRuntimeMemory * 0.75);
            return (int)RangesKt.coerceAtLeast((long)Math.floorDiv(maxLintMemory, memoryPerLintTask), (long)1L);
        }

        private final int calculateMaxParallelUsagesOutOfProcess(ProjectOptions projectOptions, long maxRuntimeMemory, long totalPhysicalMemory) {
            long maxParallelUsage = Math.floorDiv(totalPhysicalMemory, this.parseMemorySize(this.calculateLintHeapSize(projectOptions.get(StringOption.LINT_HEAP_SIZE), maxRuntimeMemory), StringOption.LINT_HEAP_SIZE.getPropertyName()));
            return (int)RangesKt.coerceAtLeast((long)(maxParallelUsage - (long)2), (long)1L);
        }

        @NotNull
        public final String calculateLintHeapSize(@Nullable String userSpecifiedLintHeapSize, long maxRuntimeMemory) {
            Object object = userSpecifiedLintHeapSize;
            if (object == null) {
                object = maxRuntimeMemory / (long)1024 / (long)1024 + "m";
            }
            return object;
        }

        private final long parseMemorySize(String memorySize, String propertyName) {
            Long longOrNull;
            long it;
            Long l;
            String string = memorySize;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String value = string2;
            if (StringsKt.toLongOrNull((String)value) != null) {
                l = StringsKt.toLongOrNull((String)value);
            } else if (StringsKt.endsWith$default((String)value, (String)"k", (boolean)false, (int)2, null)) {
                String string3 = value.substring(0, value.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                Long l2 = StringsKt.toLongOrNull((String)string3);
                if (l2 != null) {
                    it = ((Number)l2).longValue();
                    boolean bl = false;
                    l = it * (long)1024;
                } else {
                    l = null;
                }
            } else if (StringsKt.endsWith$default((String)value, (String)"m", (boolean)false, (int)2, null)) {
                String string4 = value.substring(0, value.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                Long l3 = StringsKt.toLongOrNull((String)string4);
                if (l3 != null) {
                    it = ((Number)l3).longValue();
                    boolean bl = false;
                    l = it * (long)1024 * (long)1024;
                } else {
                    l = null;
                }
            } else if (StringsKt.endsWith$default((String)value, (String)"g", (boolean)false, (int)2, null)) {
                String string5 = value.substring(0, value.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                Long l4 = StringsKt.toLongOrNull((String)string5);
                if (l4 != null) {
                    it = ((Number)l4).longValue();
                    boolean bl = false;
                    l = it * (long)1024 * (long)1024 * (long)1024;
                } else {
                    l = null;
                }
            } else {
                l = null;
            }
            Long l5 = longOrNull = l;
            if (l5 == null) {
                throw new RuntimeException("Failed to parse " + propertyName + " \"" + memorySize + "\".");
            }
            return l5;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

