/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.ShrinkerVersion;
import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"configDirRegex", "Lkotlin/text/Regex;", "configDirMatchesVersion", "", "dirName", "", "version", "Lcom/android/build/gradle/internal/dependency/ShrinkerVersion;", "gradle-core"})
public final class FilterShrinkerRulesTransformKt {
    @NotNull
    private static final Regex configDirRegex = new Regex("r8(?:-from-([^:@]+?))?(?:-upto-([^:@]+?))?");

    @VisibleForTesting
    public static final boolean configDirMatchesVersion(@NotNull String dirName2, @NotNull ShrinkerVersion version) {
        Intrinsics.checkNotNullParameter((Object)dirName2, (String)"dirName");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String string = dirName2;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        MatchResult matchResult = configDirRegex.matchEntire((CharSequence)string2);
        if (matchResult == null) {
            return false;
        }
        MatchResult matchResult2 = matchResult;
        MatchResult.Destructured destructured = matchResult2.getDestructured();
        String minVersionString = (String)destructured.getMatch().getGroupValues().get(1);
        String maxVersionString = (String)destructured.getMatch().getGroupValues().get(2);
        if (((CharSequence)minVersionString).length() == 0 && ((CharSequence)maxVersionString).length() == 0) {
            return true;
        }
        ShrinkerVersion minVersion = ShrinkerVersion.Companion.tryParse(minVersionString);
        if (minVersion != null && version.compareTo(minVersion) < 0) {
            return false;
        }
        ShrinkerVersion maxVersion = ShrinkerVersion.Companion.tryParse(maxVersionString);
        return maxVersion == null || maxVersion.compareTo(version) > 0;
    }
}

