/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.ConstraintHandler;
import com.android.builder.errors.IssueReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a8\u0006\t"}, d2={"checkConfigurationAlignments", "", "destConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "srcConfiguration", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "buildFile", "Ljava/io/File;", "gradle-core"})
@JvmName(name="ConstraintHandler")
public final class ConstraintHandler {
    public static final void checkConfigurationAlignments(@NotNull Configuration destConfiguration, @NotNull Configuration srcConfiguration, @NotNull IssueReporter issueReporter2, @NotNull File buildFile) {
        Intrinsics.checkNotNullParameter((Object)destConfiguration, (String)"destConfiguration");
        Intrinsics.checkNotNullParameter((Object)srcConfiguration, (String)"srcConfiguration");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        destConfiguration.getIncoming().afterResolve(new Action(srcConfiguration, issueReporter2, buildFile){
            final /* synthetic */ Configuration $srcConfiguration;
            final /* synthetic */ IssueReporter $issueReporter;
            final /* synthetic */ File $buildFile;
            {
                this.$srcConfiguration = $srcConfiguration;
                this.$issueReporter = $issueReporter;
                this.$buildFile = $buildFile;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(ResolvableDependencies dest) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                void $this$associateTo$iv$iv;
                void $this$filterTo$iv$iv2;
                Iterable $this$filterIsInstanceTo$iv$iv2;
                Set set = this.$srcConfiguration.getIncoming().getResolutionResult().getAllDependencies();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"srcConfiguration.incomin\u2026ionResult.allDependencies");
                Iterable $this$filterIsInstance$iv2 = set;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv2;
                Iterable<E> destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof ResolvedDependencyResult)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$filter$iv2 = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$filterIsInstanceTo$iv$iv2 = $this$filter$iv2;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv2) {
                    ResolvedDependencyResult it = (ResolvedDependencyResult)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getSelected().getId() instanceof ProjectComponentIdentifier && it.getRequested() instanceof ModuleComponentSelector)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$associate$iv = (List)destination$iv$iv;
                boolean $i$f$associate22 = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associate$iv;
                Object destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    Map bl = destination$iv$iv2;
                    ResolvedDependencyResult it = (ResolvedDependencyResult)element$iv$iv;
                    boolean bl2 = false;
                    ComponentSelector componentSelector = it.getRequested();
                    Intrinsics.checkNotNull((Object)componentSelector, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ModuleComponentSelector");
                    ModuleIdentifier moduleIdentifier = ((ModuleComponentSelector)componentSelector).getModuleIdentifier();
                    ComponentIdentifier componentIdentifier = it.getSelected().getId();
                    Intrinsics.checkNotNull((Object)componentIdentifier, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
                    it = TuplesKt.to((Object)moduleIdentifier, (Object)((ProjectComponentIdentifier)componentIdentifier).getProjectPath());
                    bl.put(it.getFirst(), it.getSecond());
                }
                Map moduleToProjectSubstitutionMap = destination$iv$iv2;
                Set set2 = dest.getResolutionResult().getAllDependencies();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"dest.resolutionResult.allDependencies");
                Iterable $i$f$associate22 = set2;
                boolean $i$f$filterIsInstance2 = false;
                $this$associateTo$iv$iv = $this$filterIsInstance$iv;
                destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ResolvedDependencyResult)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$filter2 = false;
                $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo2 = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ResolvedDependencyResult dependency = (ResolvedDependencyResult)element$iv$iv;
                    boolean bl = false;
                    ComponentIdentifier componentIdentifier = dependency.getSelected().getId();
                    boolean bl3 = componentIdentifier instanceof ModuleComponentIdentifier && moduleToProjectSubstitutionMap.containsKey(((ModuleComponentIdentifier)componentIdentifier).getModuleIdentifier());
                    if (!bl3) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    ResolvedDependencyResult dependency = (ResolvedDependencyResult)item$iv$iv;
                    Object object = destination$iv$iv2;
                    boolean bl = false;
                    ComponentIdentifier componentIdentifier = dependency.getSelected().getId();
                    Intrinsics.checkNotNull((Object)componentIdentifier, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ModuleComponentIdentifier");
                    ModuleComponentIdentifier componentIdentifier2 = (ModuleComponentIdentifier)componentIdentifier;
                    object.add((String)moduleToProjectSubstitutionMap.get(componentIdentifier2.getModuleIdentifier()));
                }
                Set neededAndroidTestProjectDeps = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                if (CollectionsKt.none((Iterable)neededAndroidTestProjectDeps)) {
                    return;
                }
                String dependencyNumber = neededAndroidTestProjectDeps.size() > 1 ? "dependencies" : "dependency";
                this.$issueReporter.reportError(IssueReporter.Type.DEPENDENCY_INTERNAL_CONFLICT, (Exception)new RuntimeException("Unable to align dependencies in configurations '" + this.$srcConfiguration.getName() + "' and '" + dest.getName() + "', as both require " + CollectionsKt.joinToString$default((Iterable)neededAndroidTestProjectDeps, (CharSequence)", ", null, null, (int)0, null, (Function1)checkConfigurationAlignments.1.INSTANCE, (int)30, null) + ".\n[Recommended action] Add the following " + dependencyNumber + " to " + this.$buildFile + ": \n" + CollectionsKt.joinToString$default((Iterable)neededAndroidTestProjectDeps, (CharSequence)"\n", null, null, (int)0, null, (Function1)checkConfigurationAlignments.2.INSTANCE, (int)30, null)));
            }
        });
    }
}

