/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.InstrumentedTestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.testing.screenshot.ImageDetails;
import com.android.build.gradle.internal.testing.screenshot.ImageDiffer;
import com.android.build.gradle.internal.testing.screenshot.PreviewResult;
import com.android.build.gradle.internal.testing.screenshot.PreviewResultKt;
import com.android.build.gradle.internal.testing.screenshot.Response;
import com.android.build.gradle.internal.testing.screenshot.ResponseProcessor;
import com.android.build.gradle.internal.testing.screenshot.SaveResultsUtilKt;
import com.android.build.gradle.internal.testing.screenshot.Verify;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.utils.FileUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.VerificationTask;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001e\u0010\f\u001a\u00020\r8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/PreviewScreenshotValidationTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "Lorg/gradle/api/tasks/VerificationTask;", "()V", "goldenImageDir", "Lorg/gradle/api/file/DirectoryProperty;", "getGoldenImageDir", "()Lorg/gradle/api/file/DirectoryProperty;", "imageOutputDir", "getImageOutputDir", "renderTaskOutputDir", "getRenderTaskOutputDir", "variantName", "", "getVariantName", "()Ljava/lang/String;", "setVariantName", "(Ljava/lang/String;)V", "compareImages", "Lcom/android/build/gradle/internal/testing/screenshot/PreviewResult;", "previewResult", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class PreviewScreenshotValidationTask
extends NonIncrementalTask
implements VerificationTask {
    @Internal
    public String variantName;

    @Override
    @NotNull
    public String getVariantName() {
        String string = this.variantName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"variantName");
        return null;
    }

    @Override
    public void setVariantName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.variantName = string;
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getGoldenImageDir();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getRenderTaskOutputDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getImageOutputDir();

    @Override
    protected void doTaskAction() {
        Path path = ((Directory)this.getRenderTaskOutputDir().get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"renderTaskOutputDir.get().asFile.toPath()");
        Response response = new ResponseProcessor(path).process();
        int verificationFailures = 0;
        List resultsToSave = new ArrayList();
        for (PreviewResult previewResult : response.getPreviewResults()) {
            PreviewResult imageComparison = this.compareImages(previewResult);
            resultsToSave.add(imageComparison);
            if (imageComparison.getResponseCode() == 0) continue;
            ++verificationFailures;
        }
        Path path2 = ((File)this.getImageOutputDir().getAsFile().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"imageOutputDir.asFile.get().toPath()");
        Path xmlFilePath = SaveResultsUtilKt.saveResults$default(resultsToSave, path2, null, 4, null);
        File reportDir = ((Directory)this.getImageOutputDir().get()).getAsFile();
        TestReport report = new TestReport(ReportType.SINGLE_FLAVOR, reportDir, reportDir);
        report.generateScreenshotTestReport(false);
        File xmlFile = xmlFilePath.toFile();
        xmlFile.delete();
        if (verificationFailures > 0) {
            String reportUrl = new File(reportDir, "index.html").toURI().toASCIIString();
            String message2 = "There were failing tests. See the report at: " + reportUrl;
            throw new GradleException(message2);
        }
    }

    private final PreviewResult compareImages(PreviewResult previewResult) {
        Verify.AnalysisResult result2;
        ImageDiffer.MSSIMMatcher imageDiffer = new ImageDiffer.MSSIMMatcher(0.0f, 1, null);
        String string = previewResult.getPreviewName().substring(StringsKt.lastIndexOf$default((CharSequence)previewResult.getPreviewName(), (String)".", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String screenshotName = string;
        String screenshotNamePng = screenshotName + ".png";
        Path goldenPath = ((File)this.getGoldenImageDir().getAsFile().get()).toPath().resolve(screenshotNamePng);
        String goldenMessage = null;
        Path actualPath = ((File)this.getImageOutputDir().getAsFile().get()).toPath().resolve(screenshotName + "_actual.png");
        Path diffPath = ((File)this.getImageOutputDir().getAsFile().get()).toPath().resolve(screenshotName + "_diff.png");
        String diffMessage = null;
        int code = 0;
        ImageDiffer imageDiffer2 = imageDiffer;
        Path path = diffPath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"diffPath");
        Verify verifier = new Verify(imageDiffer2, path);
        if (previewResult.getResponseCode() != 0) {
            if (!goldenPath.toFile().exists()) {
                goldenPath = null;
                goldenMessage = "Reference image missing";
            }
            return PreviewResult.copy$default(previewResult, previewResult.getResponseCode(), previewResult.getPreviewName(), previewResult.getMessage(), new ImageDetails(goldenPath, goldenMessage), new ImageDetails(null, previewResult.getMessage()), null, 32, null);
        }
        FileUtils.copyFile((File)((File)this.getRenderTaskOutputDir().getAsFile().get()).toPath().resolve(screenshotName + "_actual.png").toFile(), (File)actualPath.toFile());
        Path path2 = goldenPath;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"goldenPath");
        BufferedImage bufferedImage = ImageIO.read(actualPath.toFile());
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(actualPath.toFile())");
        Verify.AnalysisResult analysisResult = result2 = verifier.assertMatchGolden(path2, bufferedImage);
        if (analysisResult instanceof Verify.AnalysisResult.Failed) {
            code = 1;
        } else if (analysisResult instanceof Verify.AnalysisResult.Passed) {
            if (((Verify.AnalysisResult.Passed)result2).getImageDiff().getHighlights() == null) {
                diffPath = null;
                diffMessage = "Images match!";
            }
        } else if (analysisResult instanceof Verify.AnalysisResult.MissingGolden) {
            goldenPath = null;
            diffPath = null;
            goldenMessage = "Golden image missing";
            diffMessage = "No diff available";
            code = 1;
        } else if (analysisResult instanceof Verify.AnalysisResult.SizeMismatch) {
            diffMessage = result2.getMessage();
            diffPath = null;
            code = 1;
        }
        return PreviewResultKt.toPreviewResponse(result2, code, previewResult.getPreviewName(), new ImageDetails(goldenPath, goldenMessage), new ImageDetails(actualPath, null), new ImageDetails(diffPath, diffMessage));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/PreviewScreenshotValidationTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PreviewScreenshotValidationTask;", "Lcom/android/build/gradle/internal/component/InstrumentedTestCreationConfig;", "androidTestCreationConfig", "Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;", "imageOutputDir", "Ljava/io/File;", "goldenImageDir", "(Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;Ljava/io/File;Ljava/io/File;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PreviewScreenshotValidationTask, InstrumentedTestCreationConfig> {
        @NotNull
        private final AndroidTestCreationConfig androidTestCreationConfig;
        @NotNull
        private final File imageOutputDir;
        @NotNull
        private final File goldenImageDir;
        @NotNull
        private final String name;
        @NotNull
        private final Class<PreviewScreenshotValidationTask> type;

        public CreationAction(@NotNull AndroidTestCreationConfig androidTestCreationConfig, @NotNull File imageOutputDir, @NotNull File goldenImageDir) {
            Intrinsics.checkNotNullParameter((Object)androidTestCreationConfig, (String)"androidTestCreationConfig");
            Intrinsics.checkNotNullParameter((Object)imageOutputDir, (String)"imageOutputDir");
            Intrinsics.checkNotNullParameter((Object)goldenImageDir, (String)"goldenImageDir");
            super((ComponentCreationConfig)androidTestCreationConfig);
            this.androidTestCreationConfig = androidTestCreationConfig;
            this.imageOutputDir = imageOutputDir;
            this.goldenImageDir = goldenImageDir;
            this.name = VariantTaskCreationAction.computeTaskName$default(this, "previewScreenshot", null, 2, null);
            this.type = PreviewScreenshotValidationTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<PreviewScreenshotValidationTask> getType() {
            return this.type;
        }

        @Override
        public void configure(@NotNull PreviewScreenshotValidationTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            ComponentCreationConfig componentCreationConfig = this.creationConfig;
            AndroidTestCreationConfig androidTestCreationConfig = componentCreationConfig instanceof AndroidTestCreationConfig ? (AndroidTestCreationConfig)componentCreationConfig : null;
            VariantCreationConfig testedConfig = androidTestCreationConfig != null ? androidTestCreationConfig.getMainVariant() : null;
            Object object = testedConfig;
            if (object == null || (object = object.getName()) == null) {
                object = ((InstrumentedTestCreationConfig)this.creationConfig).getName();
            }
            task.setVariantName((String)object);
            VariantCreationConfig testedVariant = this.androidTestCreationConfig.getMainVariant();
            task.setDescription("Run screenshot tests for the " + testedVariant.getName() + " build.");
            task.setGroup("verification");
            task.getGoldenImageDir().set(this.goldenImageDir);
            task.getGoldenImageDir().disallowChanges();
            task.getImageOutputDir().set(this.imageOutputDir);
            task.getImageOutputDir().disallowChanges();
            ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.SCREENSHOTS_RENDERED.INSTANCE, (Property)task.getRenderTaskOutputDir());
        }
    }
}

