/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;

public class SdkAndroidManifestValidator
extends SubValidator {
    @Override
    public void validateModule(BundleModule module) {
        AndroidManifest manifest = module.getAndroidManifest();
        this.validateSingleSdkLibrary(manifest);
        this.validateVersioningTagsSet(manifest);
        this.validateInternalOnlyIfInstallLocationSet(manifest);
        this.validateNoPermissions(manifest);
        this.validateNoSharedUserId(manifest);
        this.validateNoComponents(manifest);
        this.validateNoSplitId(manifest);
    }

    private void validateSingleSdkLibrary(AndroidManifest manifest) {
        ImmutableList<XmlProtoElement> sdkLibraryTags = manifest.getSdkLibraryElements();
        if (sdkLibraryTags.size() != 1) {
            throw InvalidBundleException.builder().withUserMessage("There must be exactly one <%s> element. %d were found.", "sdk-library", sdkLibraryTags.size()).build();
        }
    }

    private void validateVersioningTagsSet(AndroidManifest manifest) {
        XmlProtoElement sdkLibraryTag = (XmlProtoElement)manifest.getSdkLibraryElements().get(0);
        if (!sdkLibraryTag.getAttribute("http://schemas.android.com/apk/res/android", "versionMajor").isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("SDK Major version must be set within the <%s> element.", "sdk-library").build();
        }
        try {
            Long.parseLong(((XmlProtoAttribute)sdkLibraryTag.getAttribute("http://schemas.android.com/apk/res/android", "versionMajor").get()).getValueAsString());
        }
        catch (NumberFormatException e5) {
            throw InvalidBundleException.builder().withCause(e5).withUserMessage("SDK Major version in <%s> cannot be parsed to a Long.", "sdk-library").build();
        }
        if (manifest.getMetadataValue("shadow.bundletool.com.android.vending.sdkPatchVersion").isPresent()) {
            try {
                Long.parseLong(manifest.getMetadataValue("shadow.bundletool.com.android.vending.sdkPatchVersion").get());
            }
            catch (NumberFormatException e6) {
                throw InvalidBundleException.builder().withCause(e6).withUserMessage("SDK Patch version in <%s> cannot be parsed to a Long.", "meta-data").build();
            }
        }
    }

    private void validateInternalOnlyIfInstallLocationSet(AndroidManifest manifest) {
        if (manifest.getInstallLocationValue().isPresent() && !manifest.getInstallLocationValue().get().equals("internalOnly")) {
            throw InvalidBundleException.builder().withUserMessage("'%s' in <manifest> must be 'internalOnly' for SDK bundles if it is set.", "installLocation").build();
        }
    }

    private void validateNoPermissions(AndroidManifest manifest) {
        if (!manifest.getPermissions().isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("<%s> cannot be declared in the manifest of an SDK bundle.", "permission").build();
        }
        if (!manifest.getPermissionGroups().isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("<%s> cannot be declared in the manifest of an SDK bundle.", "permission-group").build();
        }
        if (!manifest.getPermissionTrees().isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("<%s> cannot be declared in the manifest of an SDK bundle.", "permission-tree").build();
        }
    }

    private void validateNoSharedUserId(AndroidManifest manifest) {
        if (manifest.hasSharedUserId()) {
            throw InvalidBundleException.builder().withUserMessage("'%s' attribute cannot be used in the manifest of an SDK bundle.", "sharedUserId").build();
        }
    }

    private void validateNoComponents(AndroidManifest manifest) {
        if (manifest.hasComponents()) {
            throw InvalidBundleException.builder().withUserMessage("None of <%s>, <%s>, <%s>, or <%s> can be declared in the manifest of an SDK bundle.", "activity", "service", "provider", "receiver").build();
        }
    }

    private void validateNoSplitId(AndroidManifest manifest) {
        if (manifest.getSplitId().isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("'split' attribute cannot be used in the manifest of an SDK bundle.").build();
        }
    }
}

