/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.io.Aapt2ResourceConverter;
import com.android.tools.build.bundletool.io.ApkDescriptionHelper;
import com.android.tools.build.bundletool.io.ApkSerializer;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.io.ApkSigner;
import com.android.tools.build.bundletool.io.ConcurrencyUtils;
import com.android.tools.build.bundletool.io.ModuleEntriesPack;
import com.android.tools.build.bundletool.io.ModuleEntriesPacker;
import com.android.tools.build.bundletool.io.SerializationFilesManager;
import com.android.tools.build.bundletool.io.Zipper;
import com.android.tools.build.bundletool.model.ApkListener;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.PathMatcher;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import shadow.bundletool.com.android.zipflinger.Entry;
import shadow.bundletool.com.android.zipflinger.ZipArchive;
import shadow.bundletool.com.android.zipflinger.ZipSource;

public class ModuleSplitSerializer
extends ApkSerializer {
    private static final String NATIVE_LIBRARIES_SUFFIX = ".so";
    private static final Pattern NATIVE_LIBRARIES_PATTERN = Pattern.compile("lib/[^/]+/[^/]+\\.so");
    private final Aapt2ResourceConverter aapt2ResourceConverter;
    private final ApkSigner apkSigner;
    private final ImmutableList<PathMatcher> uncompressedPathMatchers;
    private final Version bundletoolVersion;
    private final ListeningExecutorService executorService;

    @Inject
    ModuleSplitSerializer(Optional<ApkListener> apkListener, @BuildApksModule.VerboseLogs boolean verbose, Aapt2ResourceConverter aapt2ResourceConverterFactory, ApkSigner apkSigner, Config.BundleConfig bundleConfig, Version bundletoolVersion, ListeningExecutorService executorService) {
        super(apkListener, verbose);
        this.aapt2ResourceConverter = aapt2ResourceConverterFactory;
        this.apkSigner = apkSigner;
        this.uncompressedPathMatchers = (ImmutableList)bundleConfig.getCompression().getUncompressedGlobList().stream().map(PathMatcher::createFromGlob).collect(ImmutableList.toImmutableList());
        this.bundletoolVersion = bundletoolVersion;
        this.executorService = executorService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImmutableMap<ZipPath, Commands.ApkDescription> serialize(Path outputDirectory, ImmutableMap<ZipPath, ModuleSplit> splitsByRelativePath) {
        ImmutableList preparedSplits = (ImmutableList)splitsByRelativePath.values().stream().map(this.apkSigner::signEmbeddedApks).map(ModuleSplitSerializer::injectManifestAndResourceTableAsEntries).collect(ImmutableList.toImmutableList());
        try (SerializationFilesManager filesManager = new SerializationFilesManager();){
            ImmutableList binarySplits = (ImmutableList)this.aapt2ResourceConverter.convert((Collection<ModuleSplit>)preparedSplits, filesManager).stream().map(this::applyUncompressedGlobsAndUncompressedNativeLibraries).collect(ImmutableList.toImmutableList());
            ModuleEntriesPack maybeCompressedEntriesPack = this.buildCompressedEntriesPack(filesManager.getCompressedResourceEntriesPackPath(), filesManager.getCompressedEntriesPackPath(), (Collection<ModuleSplit>)binarySplits);
            ModuleEntriesPack uncompressedEntriesPack = this.buildUncompressedEntriesPack(filesManager.getUncompressedEntriesPackPath(), (Collection<ModuleSplit>)binarySplits, maybeCompressedEntriesPack);
            filesManager.closeAndRemoveBinaryApks();
            ModuleEntriesPack allEntriesPack = maybeCompressedEntriesPack.mergeWith(uncompressedEntriesPack);
            ImmutableList apkDescriptions = (ImmutableList)Streams.zip((Stream)splitsByRelativePath.keySet().stream(), (Stream)binarySplits.stream(), (relativePath, split) -> this.executorService.submit(() -> this.serializeAndSignSplit(outputDirectory, (ZipPath)relativePath, (ModuleSplit)split, allEntriesPack, uncompressedEntriesPack))).collect(ImmutableList.toImmutableList());
            ImmutableMap immutableMap = (ImmutableMap)ConcurrencyUtils.waitForAll(apkDescriptions).stream().collect(ImmutableMap.toImmutableMap(apk -> ZipPath.create(apk.getPath()), Function.identity()));
            return immutableMap;
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
    }

    private ModuleEntriesPack buildCompressedEntriesPack(Path resourcesOutputPath, Path compressedOutputPath, Collection<ModuleSplit> splits) {
        ModuleEntriesPacker otherEntriesPacker = new ModuleEntriesPacker(compressedOutputPath, "c_");
        ModuleEntriesPacker resourceEntriesPacker = new ModuleEntriesPacker(resourcesOutputPath, "r_");
        splits.stream().flatMap(split -> split.getEntries().stream()).filter(entry -> !entry.getForceUncompressed()).forEach(entry -> {
            if (ApkSerializerHelper.requiresAapt2Conversion(ApkSerializerHelper.toApkEntryPath(entry.getPath()))) {
                resourceEntriesPacker.add((ModuleEntry)entry);
            } else {
                otherEntriesPacker.add((ModuleEntry)entry);
            }
        });
        ModuleEntriesPack resourceEntriesPack = resourceEntriesPacker.pack(Zipper.compressedZip(this.executorService, 9));
        ModuleEntriesPack otherEntriesPack = otherEntriesPacker.pack(Zipper.compressedZip(this.executorService, -1));
        return resourceEntriesPack.mergeWith(otherEntriesPack);
    }

    private ModuleEntriesPack buildUncompressedEntriesPack(Path outputPath, Collection<ModuleSplit> splits, ModuleEntriesPack compressedPack) {
        ModuleEntriesPacker entriesPacker = new ModuleEntriesPacker(outputPath, "u_");
        splits.stream().flatMap(split -> split.getEntries().stream()).filter(entry -> entry.getForceUncompressed() || this.shouldUncompressBecauseOfLowRatio((ModuleEntry)entry, compressedPack)).forEach(entriesPacker::add);
        return entriesPacker.pack(Zipper.uncompressedZip());
    }

    private Commands.ApkDescription serializeAndSignSplit(Path outputDirectory, ZipPath apkRelativePath, ModuleSplit split, ModuleEntriesPack allEntriesPack, ModuleEntriesPack uncompressedEntriesPack) {
        Path outputPath = outputDirectory.resolve(apkRelativePath.toString());
        Commands.ApkDescription apkDescription = ApkDescriptionHelper.createApkDescription(apkRelativePath, split);
        this.serializeSplit(outputPath, split, allEntriesPack, uncompressedEntriesPack);
        this.apkSigner.signApk(outputPath, split);
        this.notifyApkSerialized(apkDescription, split.getSplitType());
        return apkDescription;
    }

    private void serializeSplit(Path outputPath, ModuleSplit split, ModuleEntriesPack allEntriesPack, ModuleEntriesPack uncompressedEntriesPack) {
        FileUtils.createDirectories(outputPath.getParent());
        try (ZipArchive archive = new ZipArchive(outputPath);){
            ImmutableMap moduleEntriesByName = (ImmutableMap)split.getEntries().stream().collect(ImmutableMap.toImmutableMap(entry -> ApkSerializerHelper.toApkEntryPath(entry.getPath()), entry -> entry, (a5, b5) -> b5));
            ImmutableList sortedEntries = ImmutableList.sortedCopyOf(Comparator.comparing(e5 -> ApkSerializerHelper.toApkEntryPath(e5.getPath())), (Iterable)moduleEntriesByName.values());
            ZipSource zipSource = allEntriesPack.select((ImmutableList<ModuleEntry>)sortedEntries, entry -> ApkSerializerHelper.toApkEntryPath(entry.getPath(), true).toString(), entry -> ModuleSplitSerializer.alignmentForEntry(entry, uncompressedEntriesPack));
            archive.add(zipSource);
        }
        catch (IOException e6) {
            throw new UncheckedIOException(e6);
        }
    }

    private static long alignmentForEntry(ModuleEntry entry, ModuleEntriesPack uncompressedEntriesPack) {
        if (!uncompressedEntriesPack.hasEntry(entry)) {
            return 0L;
        }
        return entry.getPath().toString().endsWith(NATIVE_LIBRARIES_SUFFIX) ? 4096L : 4L;
    }

    private static ModuleSplit injectManifestAndResourceTableAsEntries(ModuleSplit split) {
        ImmutableList.Builder splitEntries = ImmutableList.builder();
        splitEntries.add((Object)ModuleEntry.builder().setForceUncompressed(false).setContent(ByteSource.wrap((byte[])split.getAndroidManifest().getManifestRoot().getProto().toByteArray())).setPath(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath()).build());
        if (split.getResourceTable().isPresent()) {
            splitEntries.add((Object)ModuleEntry.builder().setForceUncompressed(true).setContent(ByteSource.wrap((byte[])split.getResourceTable().get().toByteArray())).setPath(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath()).build());
        }
        split.getEntries().stream().filter(entry -> !BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath().equals(entry.getPath())).filter(entry -> !BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath().equals(entry.getPath())).forEach(arg_0 -> ((ImmutableList.Builder)splitEntries).add(arg_0));
        return split.toBuilder().setEntries((List<ModuleEntry>)splitEntries.build()).build();
    }

    private ModuleSplit applyUncompressedGlobsAndUncompressedNativeLibraries(ModuleSplit split) {
        boolean uncompressNativeLibs = split.getAndroidManifest().getExtractNativeLibsValue().orElse(true) == false;
        return split.toBuilder().setEntries((List)split.getEntries().stream().map(entry -> this.shouldUncompressEntry((ModuleEntry)entry, uncompressNativeLibs) ? entry.toBuilder().setForceUncompressed(true).build() : entry).collect(ImmutableList.toImmutableList())).build();
    }

    private boolean shouldUncompressEntry(ModuleEntry entry, boolean uncompressNativeLibs) {
        if (entry.getForceUncompressed()) {
            return false;
        }
        return this.matchesForceUncompressedPath(entry) || this.matchesUncompressedNativeLib(entry, uncompressNativeLibs);
    }

    private boolean matchesUncompressedNativeLib(ModuleEntry entry, boolean uncompressNativeLibs) {
        return uncompressNativeLibs && NATIVE_LIBRARIES_PATTERN.matcher(entry.getPath().toString()).matches();
    }

    private boolean matchesForceUncompressedPath(ModuleEntry entry) {
        if (entry.getPath().equals(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath())) {
            return false;
        }
        String path = ApkSerializerHelper.toApkEntryPath(entry.getPath()).toString();
        if (this.uncompressedPathMatchers.stream().anyMatch(pathMatcher -> pathMatcher.matches(path))) {
            return true;
        }
        return !VersionGuardedFeature.NO_DEFAULT_UNCOMPRESS_EXTENSIONS.enabledForVersion(this.bundletoolVersion) && ApkSerializerHelper.NO_COMPRESSION_EXTENSIONS.contains((Object)FileUtils.getFileExtension(ZipPath.create(path)));
    }

    private boolean shouldUncompressBecauseOfLowRatio(ModuleEntry moduleEntry, ModuleEntriesPack compressedPack) {
        Entry entry = compressedPack.getZipEntry(moduleEntry);
        long compressedSize = entry.getCompressedSize();
        long uncompressedSize = entry.getUncompressedSize();
        if (moduleEntry.getPath().startsWith("res")) {
            return compressedSize + compressedSize / 10L > uncompressedSize;
        }
        return compressedSize >= uncompressedSize;
    }
}

