/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.bundle.CodeTransparencyOuterClass;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.stream.Stream;

public final class CodeTransparencyFactory {
    public static CodeTransparencyOuterClass.CodeTransparency createCodeTransparencyMetadata(AppBundle bundle) {
        ImmutableList codeRelatedFiles = (ImmutableList)bundle.getFeatureModules().values().stream().flatMap(bundleModule -> CodeTransparencyFactory.getCodeRelatedFileEntries(bundleModule)).map(CodeTransparencyFactory::createCodeRelatedFile).sorted(Comparator.comparing(CodeTransparencyOuterClass.CodeRelatedFile::getPath)).collect(ImmutableList.toImmutableList());
        return CodeTransparencyOuterClass.CodeTransparency.newBuilder().addAllCodeRelatedFile((Iterable<? extends CodeTransparencyOuterClass.CodeRelatedFile>)codeRelatedFiles).build();
    }

    public static CodeTransparencyOuterClass.CodeTransparency parseFrom(String codeTransparency) {
        CodeTransparencyOuterClass.CodeTransparency.Builder codeTransparencyProto = CodeTransparencyOuterClass.CodeTransparency.newBuilder();
        try {
            JsonFormat.parser().merge(codeTransparency, (Message.Builder)codeTransparencyProto);
        }
        catch (IOException e5) {
            throw InvalidBundleException.builder().withUserMessage("Unable to parse code transparency file contents.").withCause(e5).build();
        }
        return codeTransparencyProto.build();
    }

    private static Stream<ModuleEntry> getCodeRelatedFileEntries(BundleModule module) {
        return module.getEntries().stream().filter(CodeTransparencyFactory::isCodeRelatedFile);
    }

    private static CodeTransparencyOuterClass.CodeRelatedFile createCodeRelatedFile(ModuleEntry moduleEntry) {
        Preconditions.checkArgument((boolean)moduleEntry.getBundleLocation().isPresent());
        CodeTransparencyOuterClass.CodeRelatedFile.Builder codeRelatedFile = CodeTransparencyOuterClass.CodeRelatedFile.newBuilder().setPath(moduleEntry.getBundleLocation().get().entryPathInBundle().toString());
        if (moduleEntry.getPath().startsWith(BundleModule.LIB_DIRECTORY)) {
            codeRelatedFile.setType(CodeTransparencyOuterClass.CodeRelatedFile.Type.NATIVE_LIBRARY);
            codeRelatedFile.setApkPath(moduleEntry.getPath().toString());
        } else {
            codeRelatedFile.setType(CodeTransparencyOuterClass.CodeRelatedFile.Type.DEX);
        }
        try {
            codeRelatedFile.setSha256(moduleEntry.getContent().hash(Hashing.sha256()).toString());
        }
        catch (IOException e5) {
            throw new UncheckedIOException("An error occurred when calculating file hash.", e5);
        }
        return codeRelatedFile.build();
    }

    private static boolean isCodeRelatedFile(ModuleEntry moduleEntry) {
        return moduleEntry.getPath().startsWith(BundleModule.DEX_DIRECTORY) || moduleEntry.getPath().startsWith(BundleModule.LIB_DIRECTORY) && moduleEntry.getPath().toString().endsWith(".so");
    }

    private CodeTransparencyFactory() {
    }
}

