/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.base.Preconditions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.BiFunction;
import javax.inject.Inject;

public class SplitApkSerializer {
    private final ApkSerializerHelper apkSerializerHelper;

    @Inject
    public SplitApkSerializer(ApkSerializerHelper apkSerializerHelper) {
        this.apkSerializerHelper = apkSerializerHelper;
    }

    public Commands.ApkDescription writeSplitToDisk(ModuleSplit split, Path outputDirectory, ZipPath apkPath) {
        return this.writeToDisk(split, outputDirectory, Commands.ApkDescription.Builder::setSplitApkMetadata, apkPath);
    }

    public Commands.ApkDescription writeInstantSplitToDisk(ModuleSplit split, Path outputDirectory, ZipPath apkPath) {
        return this.writeToDisk(split, outputDirectory, Commands.ApkDescription.Builder::setInstantApkMetadata, apkPath);
    }

    public Commands.ApkDescription writeAssetSliceToDisk(ModuleSplit split, Path outputDirectory, ZipPath apkPath) {
        return this.writeToDisk(split, outputDirectory, Commands.ApkDescription.Builder::setAssetSliceMetadata, apkPath);
    }

    private Commands.ApkDescription writeToDisk(ModuleSplit split, Path outputDirectory, BiFunction<Commands.ApkDescription.Builder, Commands.SplitApkMetadata, Commands.ApkDescription.Builder> setApkMetadata, ZipPath apkPath) {
        Preconditions.checkState((boolean)Files.isDirectory(outputDirectory, new LinkOption[0]), (Object)"Output directory does not exist.");
        this.apkSerializerHelper.writeToZipFile(split, outputDirectory.resolve(apkPath.toString()));
        Commands.ApkDescription.Builder builder = Commands.ApkDescription.newBuilder().setPath(apkPath.toString()).setTargeting(split.getApkTargeting());
        return setApkMetadata.apply(builder, Commands.SplitApkMetadata.newBuilder().setSplitId(split.getAndroidManifest().getSplitId().orElse("")).setIsMasterSplit(split.isMasterSplit()).build()).build();
    }
}

