/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import androidx.annotation.RestrictTo;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a8\u0006\u0006"}, d2={"getLastInsertedRowId", "", "connection", "Landroidx/sqlite/SQLiteConnection;", "getTotalChangedRows", "", "room-runtime_release"})
@JvmName(name="SQLiteConnectionUtil")
public final class SQLiteConnectionUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final long getLastInsertedRowId(@NotNull SQLiteConnection connection) {
        long l;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (SQLiteConnectionUtil.getTotalChangedRows(connection) == 0) {
            return -1L;
        }
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepare("SELECT last_insert_rowid()");
        Throwable throwable = null;
        try {
            SQLiteStatement it = (SQLiteStatement)autoCloseable;
            boolean bl = false;
            it.step();
            l = it.getLong(0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final int getTotalChangedRows(@NotNull SQLiteConnection connection) {
        int n;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepare("SELECT changes()");
        Throwable throwable = null;
        try {
            SQLiteStatement it = (SQLiteStatement)autoCloseable;
            boolean bl = false;
            it.step();
            n = (int)it.getLong(0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return n;
    }
}

