/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.support;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.database.SQLException;
import android.database.sqlite.SQLiteTransactionListener;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.util.Pair;
import androidx.annotation.RequiresApi;
import androidx.room.DelegatingOpenHelper;
import androidx.room.support.AutoCloser;
import androidx.room.support.AutoClosingRoomOpenHelper;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteProgram;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\u001d\u001e\u001fB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0011\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0001R\u0014\u0010\u0003\u001a\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Landroidx/room/support/AutoClosingRoomOpenHelper;", "Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "Landroidx/room/DelegatingOpenHelper;", "delegate", "autoCloser", "Landroidx/room/support/AutoCloser;", "<init>", "(Landroidx/sqlite/db/SupportSQLiteOpenHelper;Landroidx/room/support/AutoCloser;)V", "getDelegate", "()Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "getAutoCloser$room_runtime_release", "()Landroidx/room/support/AutoCloser;", "autoClosingDb", "Landroidx/room/support/AutoClosingRoomOpenHelper$AutoClosingSupportSQLiteDatabase;", "writableDatabase", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "getWritableDatabase", "()Landroidx/sqlite/db/SupportSQLiteDatabase;", "readableDatabase", "getReadableDatabase", "close", "", "setWriteAheadLoggingEnabled", "enabled", "", "databaseName", "", "getDatabaseName", "()Ljava/lang/String;", "AutoClosingSupportSQLiteDatabase", "KeepAliveCursor", "AutoClosingSupportSQLiteStatement", "room-runtime_release"})
public final class AutoClosingRoomOpenHelper
implements SupportSQLiteOpenHelper,
DelegatingOpenHelper {
    @NotNull
    private final SupportSQLiteOpenHelper delegate;
    @NotNull
    private final AutoCloser autoCloser;
    @NotNull
    private final AutoClosingSupportSQLiteDatabase autoClosingDb;

    public AutoClosingRoomOpenHelper(@NotNull SupportSQLiteOpenHelper delegate, @NotNull AutoCloser autoCloser) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)autoCloser, (String)"autoCloser");
        this.delegate = delegate;
        this.autoCloser = autoCloser;
        this.autoClosingDb = new AutoClosingSupportSQLiteDatabase(this.autoCloser);
        this.autoCloser.initOpenHelper(this.getDelegate());
    }

    @Override
    @NotNull
    public SupportSQLiteOpenHelper getDelegate() {
        return this.delegate;
    }

    @NotNull
    public final AutoCloser getAutoCloser$room_runtime_release() {
        return this.autoCloser;
    }

    @NotNull
    public SupportSQLiteDatabase getWritableDatabase() {
        this.autoClosingDb.pokeOpen();
        return this.autoClosingDb;
    }

    @NotNull
    public SupportSQLiteDatabase getReadableDatabase() {
        this.autoClosingDb.pokeOpen();
        return this.autoClosingDb;
    }

    public void close() {
        this.autoClosingDb.close();
    }

    public void setWriteAheadLoggingEnabled(boolean enabled) {
        this.delegate.setWriteAheadLoggingEnabled(enabled);
    }

    @Nullable
    public String getDatabaseName() {
        return this.delegate.getDatabaseName();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001aH\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010*\u001a\u00020\u000bH\u0016J'\u0010*\u001a\u00020+2\u0006\u0010*\u001a\u00020\u000b2\u0010\u0010,\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010.0-H\u0016\u00a2\u0006\u0002\u0010/J\u0010\u0010*\u001a\u00020+2\u0006\u0010*\u001a\u000200H\u0016J\u001a\u0010*\u001a\u00020+2\u0006\u0010*\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u0017J \u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u000207H\u0016J3\u00108\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u000b2\b\u00109\u001a\u0004\u0018\u00010\u000b2\u0012\u0010:\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010.\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010;JC\u0010<\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u0002072\b\u00109\u001a\u0004\u0018\u00010\u000b2\u0012\u0010:\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010.\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010=J\u0010\u0010>\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J'\u0010>\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010,\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010.0-H\u0016\u00a2\u0006\u0002\u0010?J\u0010\u0010B\u001a\u00020\u00152\u0006\u0010C\u001a\u00020\u001cH\u0016J\u0010\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u001cH\u0016J\u0010\u0010L\u001a\u00020\u00072\u0006\u0010M\u001a\u00020\u0015H\u0016J\b\u0010N\u001a\u00020\u0015H\u0016J\b\u0010O\u001a\u00020\u0007H\u0016J\b\u0010W\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R$\u0010&\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010#\"\u0004\b(\u0010)R\u0014\u0010@\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0017R\u0014\u0010A\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0017R\u0016\u0010D\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0014\u0010P\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010\u0017R(\u0010Q\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0S\u0018\u00010R8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010UR\u0014\u0010V\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010\u0017\u00a8\u0006X"}, d2={"Landroidx/room/support/AutoClosingRoomOpenHelper$AutoClosingSupportSQLiteDatabase;", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "autoCloser", "Landroidx/room/support/AutoCloser;", "<init>", "(Landroidx/room/support/AutoCloser;)V", "pokeOpen", "", "compileStatement", "Landroidx/sqlite/db/SupportSQLiteStatement;", "sql", "", "beginTransaction", "beginTransactionNonExclusive", "beginTransactionWithListener", "transactionListener", "Landroid/database/sqlite/SQLiteTransactionListener;", "beginTransactionWithListenerNonExclusive", "endTransaction", "setTransactionSuccessful", "inTransaction", "", "isDbLockedByCurrentThread", "()Z", "yieldIfContendedSafely", "sleepAfterYieldDelayMillis", "", "version", "", "getVersion", "()I", "setVersion", "(I)V", "maximumSize", "getMaximumSize", "()J", "setMaximumSize", "numBytes", "pageSize", "getPageSize", "setPageSize", "(J)V", "query", "Landroid/database/Cursor;", "bindArgs", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Landroid/database/Cursor;", "Landroidx/sqlite/db/SupportSQLiteQuery;", "cancellationSignal", "Landroid/os/CancellationSignal;", "insert", "table", "conflictAlgorithm", "values", "Landroid/content/ContentValues;", "delete", "whereClause", "whereArgs", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)I", "update", "(Ljava/lang/String;ILandroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/Object;)I", "execSQL", "(Ljava/lang/String;[Ljava/lang/Object;)V", "isReadOnly", "isOpen", "needUpgrade", "newVersion", "path", "getPath", "()Ljava/lang/String;", "setLocale", "locale", "Ljava/util/Locale;", "setMaxSqlCacheSize", "cacheSize", "setForeignKeyConstraintsEnabled", "enabled", "enableWriteAheadLogging", "disableWriteAheadLogging", "isWriteAheadLoggingEnabled", "attachedDbs", "", "Landroid/util/Pair;", "getAttachedDbs", "()Ljava/util/List;", "isDatabaseIntegrityOk", "close", "room-runtime_release"})
    public static final class AutoClosingSupportSQLiteDatabase
    implements SupportSQLiteDatabase {
        @NotNull
        private final AutoCloser autoCloser;

        public AutoClosingSupportSQLiteDatabase(@NotNull AutoCloser autoCloser) {
            Intrinsics.checkNotNullParameter((Object)autoCloser, (String)"autoCloser");
            this.autoCloser = autoCloser;
        }

        public final void pokeOpen() {
            this.autoCloser.executeRefCountingFunction(AutoClosingSupportSQLiteDatabase::pokeOpen$lambda$0);
        }

        @NotNull
        public SupportSQLiteStatement compileStatement(@NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            return new AutoClosingSupportSQLiteStatement(sql, this.autoCloser);
        }

        public void beginTransaction() {
            SupportSQLiteDatabase db = this.autoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransaction();
            }
            catch (Throwable t) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        public void beginTransactionNonExclusive() {
            SupportSQLiteDatabase db = this.autoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransactionNonExclusive();
            }
            catch (Throwable t) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        public void beginTransactionWithListener(@NotNull SQLiteTransactionListener transactionListener) {
            Intrinsics.checkNotNullParameter((Object)transactionListener, (String)"transactionListener");
            SupportSQLiteDatabase db = this.autoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransactionWithListener(transactionListener);
            }
            catch (Throwable t) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        public void beginTransactionWithListenerNonExclusive(@NotNull SQLiteTransactionListener transactionListener) {
            Intrinsics.checkNotNullParameter((Object)transactionListener, (String)"transactionListener");
            SupportSQLiteDatabase db = this.autoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransactionWithListenerNonExclusive(transactionListener);
            }
            catch (Throwable t) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endTransaction() {
            try {
                SupportSQLiteDatabase supportSQLiteDatabase = this.autoCloser.getDelegateDatabase$room_runtime_release();
                Intrinsics.checkNotNull((Object)supportSQLiteDatabase);
                supportSQLiteDatabase.endTransaction();
            }
            finally {
                this.autoCloser.decrementCountAndScheduleClose();
            }
        }

        public void setTransactionSuccessful() {
            SupportSQLiteDatabase supportSQLiteDatabase = this.autoCloser.getDelegateDatabase$room_runtime_release();
            Intrinsics.checkNotNull((Object)supportSQLiteDatabase);
            supportSQLiteDatabase.setTransactionSuccessful();
        }

        public boolean inTransaction() {
            return this.autoCloser.getDelegateDatabase$room_runtime_release() == null ? false : (Boolean)this.autoCloser.executeRefCountingFunction(inTransaction.1.INSTANCE);
        }

        public boolean isDbLockedByCurrentThread() {
            return this.autoCloser.getDelegateDatabase$room_runtime_release() == null ? false : (Boolean)this.autoCloser.executeRefCountingFunction((Function1)isDbLockedByCurrentThread.1.INSTANCE);
        }

        public boolean yieldIfContendedSafely() {
            return (Boolean)this.autoCloser.executeRefCountingFunction(yieldIfContendedSafely.1.INSTANCE);
        }

        public boolean yieldIfContendedSafely(long sleepAfterYieldDelayMillis) {
            return (Boolean)this.autoCloser.executeRefCountingFunction(yieldIfContendedSafely.2.INSTANCE);
        }

        public int getVersion() {
            return ((Number)this.autoCloser.executeRefCountingFunction((Function1)version.1.INSTANCE)).intValue();
        }

        public void setVersion(int version2) {
            this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase._set_version_$lambda$1(version2, arg_0));
        }

        public long getMaximumSize() {
            return ((Number)this.autoCloser.executeRefCountingFunction((Function1)maximumSize.1.INSTANCE)).longValue();
        }

        public long setMaximumSize(long numBytes) {
            return ((Number)this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase.setMaximumSize$lambda$2(numBytes, arg_0))).longValue();
        }

        public long getPageSize() {
            return ((Number)this.autoCloser.executeRefCountingFunction((Function1)pageSize.1.INSTANCE)).longValue();
        }

        public void setPageSize(long numBytes) {
            this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase._set_pageSize_$lambda$3(numBytes, arg_0));
        }

        @NotNull
        public Cursor query(@NotNull String query2) {
            Cursor cursor;
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            try {
                cursor = this.autoCloser.incrementCountAndEnsureDbIsOpen().query(query2);
            }
            catch (Throwable throwable) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            Cursor result2 = cursor;
            return new KeepAliveCursor(result2, this.autoCloser);
        }

        @NotNull
        public Cursor query(@NotNull String query2, @NotNull Object[] bindArgs) {
            Cursor cursor;
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            Intrinsics.checkNotNullParameter((Object)bindArgs, (String)"bindArgs");
            try {
                cursor = this.autoCloser.incrementCountAndEnsureDbIsOpen().query(query2, bindArgs);
            }
            catch (Throwable throwable) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            Cursor result2 = cursor;
            return new KeepAliveCursor(result2, this.autoCloser);
        }

        @NotNull
        public Cursor query(@NotNull SupportSQLiteQuery query2) {
            Cursor cursor;
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            try {
                cursor = this.autoCloser.incrementCountAndEnsureDbIsOpen().query(query2);
            }
            catch (Throwable throwable) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            Cursor result2 = cursor;
            return new KeepAliveCursor(result2, this.autoCloser);
        }

        @RequiresApi(api=24)
        @NotNull
        public Cursor query(@NotNull SupportSQLiteQuery query2, @Nullable CancellationSignal cancellationSignal) {
            Cursor cursor;
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            try {
                cursor = this.autoCloser.incrementCountAndEnsureDbIsOpen().query(query2, cancellationSignal);
            }
            catch (Throwable throwable) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            Cursor result2 = cursor;
            return new KeepAliveCursor(result2, this.autoCloser);
        }

        public long insert(@NotNull String table, int conflictAlgorithm, @NotNull ContentValues values) throws SQLException {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            return ((Number)this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase.insert$lambda$4(table, conflictAlgorithm, values, arg_0))).longValue();
        }

        public int delete(@NotNull String table, @Nullable String whereClause, @Nullable Object[] whereArgs) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            return ((Number)this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase.delete$lambda$5(table, whereClause, whereArgs, arg_0))).intValue();
        }

        public int update(@NotNull String table, int conflictAlgorithm, @NotNull ContentValues values, @Nullable String whereClause, @Nullable Object[] whereArgs) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            return ((Number)this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase.update$lambda$6(table, conflictAlgorithm, values, whereClause, whereArgs, arg_0))).intValue();
        }

        public void execSQL(@NotNull String sql) throws SQLException {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase.execSQL$lambda$7(sql, arg_0));
        }

        public void execSQL(@NotNull String sql, @NotNull Object[] bindArgs) throws SQLException {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter((Object)bindArgs, (String)"bindArgs");
            this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase.execSQL$lambda$8(sql, bindArgs, arg_0));
        }

        public boolean isReadOnly() {
            return (Boolean)this.autoCloser.executeRefCountingFunction((Function1)isReadOnly.1.INSTANCE);
        }

        public boolean isOpen() {
            SupportSQLiteDatabase supportSQLiteDatabase = this.autoCloser.getDelegateDatabase$room_runtime_release();
            if (supportSQLiteDatabase == null) {
                return false;
            }
            return supportSQLiteDatabase.isOpen();
        }

        public boolean needUpgrade(int newVersion) {
            return (Boolean)this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase.needUpgrade$lambda$9(newVersion, arg_0));
        }

        @Nullable
        public String getPath() {
            return (String)this.autoCloser.executeRefCountingFunction((Function1)path.1.INSTANCE);
        }

        public void setLocale(@NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase.setLocale$lambda$10(locale, arg_0));
        }

        public void setMaxSqlCacheSize(int cacheSize) {
            this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase.setMaxSqlCacheSize$lambda$11(cacheSize, arg_0));
        }

        public void setForeignKeyConstraintsEnabled(boolean enabled) {
            this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteDatabase.setForeignKeyConstraintsEnabled$lambda$12(enabled, arg_0));
        }

        public boolean enableWriteAheadLogging() {
            throw new UnsupportedOperationException("Enable/disable write ahead logging on the OpenHelper instead of on the database directly.");
        }

        public void disableWriteAheadLogging() {
            throw new UnsupportedOperationException("Enable/disable write ahead logging on the OpenHelper instead of on the database directly.");
        }

        public boolean isWriteAheadLoggingEnabled() {
            return (Boolean)this.autoCloser.executeRefCountingFunction((Function1)isWriteAheadLoggingEnabled.1.INSTANCE);
        }

        @Nullable
        public List<Pair<String, String>> getAttachedDbs() {
            return (List)this.autoCloser.executeRefCountingFunction((Function1)attachedDbs.1.INSTANCE);
        }

        public boolean isDatabaseIntegrityOk() {
            return (Boolean)this.autoCloser.executeRefCountingFunction((Function1)isDatabaseIntegrityOk.1.INSTANCE);
        }

        public void close() throws IOException {
            this.autoCloser.closeDatabaseIfOpen();
        }

        private static final Object pokeOpen$lambda$0(SupportSQLiteDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return null;
        }

        private static final Unit _set_version_$lambda$1(int $version, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            db.setVersion($version);
            return Unit.INSTANCE;
        }

        private static final long setMaximumSize$lambda$2(long $numBytes, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            return db.setMaximumSize($numBytes);
        }

        private static final Object _set_pageSize_$lambda$3(long $numBytes, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            db.setPageSize($numBytes);
            return null;
        }

        private static final long insert$lambda$4(String $table, int $conflictAlgorithm, ContentValues $values, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            return db.insert($table, $conflictAlgorithm, $values);
        }

        private static final int delete$lambda$5(String $table, String $whereClause, Object[] $whereArgs, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            return db.delete($table, $whereClause, $whereArgs);
        }

        private static final int update$lambda$6(String $table, int $conflictAlgorithm, ContentValues $values, String $whereClause, Object[] $whereArgs, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            return db.update($table, $conflictAlgorithm, $values, $whereClause, $whereArgs);
        }

        private static final Unit execSQL$lambda$7(String $sql, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            db.execSQL($sql);
            return Unit.INSTANCE;
        }

        private static final Unit execSQL$lambda$8(String $sql, Object[] $bindArgs, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            db.execSQL($sql, $bindArgs);
            return Unit.INSTANCE;
        }

        private static final boolean needUpgrade$lambda$9(int $newVersion, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            return db.needUpgrade($newVersion);
        }

        private static final Unit setLocale$lambda$10(Locale $locale, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            db.setLocale($locale);
            return Unit.INSTANCE;
        }

        private static final Unit setMaxSqlCacheSize$lambda$11(int $cacheSize, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            db.setMaxSqlCacheSize($cacheSize);
            return Unit.INSTANCE;
        }

        private static final Unit setForeignKeyConstraintsEnabled$lambda$12(boolean $enabled, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            db.setForeignKeyConstraintsEnabled($enabled);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J'\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\u001e0 H\u0002\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0018H\u0016J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u001aH\u0016J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00182\u0006\u0010%\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0012H\u0016J\b\u0010*\u001a\u00020\u0015H\u0016J\u0018\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0018H\u0002J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u00061"}, d2={"Landroidx/room/support/AutoClosingRoomOpenHelper$AutoClosingSupportSQLiteStatement;", "Landroidx/sqlite/db/SupportSQLiteStatement;", "sql", "", "autoCloser", "Landroidx/room/support/AutoCloser;", "<init>", "(Ljava/lang/String;Landroidx/room/support/AutoCloser;)V", "bindingTypes", "", "longBindings", "", "doubleBindings", "", "stringBindings", "", "[Ljava/lang/String;", "blobBindings", "", "[[B", "close", "", "execute", "executeUpdateDelete", "", "executeInsert", "", "simpleQueryForLong", "simpleQueryForString", "executeWithRefCount", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "bindNull", "index", "bindLong", "value", "bindDouble", "", "bindString", "bindBlob", "clearBindings", "ensureCapacity", "columnType", "bindTo", "query", "Landroidx/sqlite/db/SupportSQLiteProgram;", "Companion", "room-runtime_release"})
    private static final class AutoClosingSupportSQLiteStatement
    implements SupportSQLiteStatement {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String sql;
        @NotNull
        private final AutoCloser autoCloser;
        @NotNull
        private int[] bindingTypes;
        @NotNull
        private long[] longBindings;
        @NotNull
        private double[] doubleBindings;
        @NotNull
        private String[] stringBindings;
        @NotNull
        private byte[][] blobBindings;
        private static final int COLUMN_TYPE_LONG = 1;
        private static final int COLUMN_TYPE_DOUBLE = 2;
        private static final int COLUMN_TYPE_STRING = 3;
        private static final int COLUMN_TYPE_BLOB = 4;
        private static final int COLUMN_TYPE_NULL = 5;

        public AutoClosingSupportSQLiteStatement(@NotNull String sql, @NotNull AutoCloser autoCloser) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter((Object)autoCloser, (String)"autoCloser");
            this.sql = sql;
            this.autoCloser = autoCloser;
            this.bindingTypes = new int[0];
            this.longBindings = new long[0];
            this.doubleBindings = new double[0];
            this.stringBindings = new String[0];
            this.blobBindings = new byte[0][];
        }

        public void close() {
            this.clearBindings();
        }

        public void execute() {
            this.executeWithRefCount(AutoClosingSupportSQLiteStatement::execute$lambda$0);
        }

        public int executeUpdateDelete() {
            return ((Number)this.executeWithRefCount(AutoClosingSupportSQLiteStatement::executeUpdateDelete$lambda$1)).intValue();
        }

        public long executeInsert() {
            return ((Number)this.executeWithRefCount(AutoClosingSupportSQLiteStatement::executeInsert$lambda$2)).longValue();
        }

        public long simpleQueryForLong() {
            return ((Number)this.executeWithRefCount(AutoClosingSupportSQLiteStatement::simpleQueryForLong$lambda$3)).longValue();
        }

        @Nullable
        public String simpleQueryForString() {
            return (String)this.executeWithRefCount(AutoClosingSupportSQLiteStatement::simpleQueryForString$lambda$4);
        }

        private final <T> T executeWithRefCount(Function1<? super SupportSQLiteStatement, ? extends T> block) {
            return (T)this.autoCloser.executeRefCountingFunction(arg_0 -> AutoClosingSupportSQLiteStatement.executeWithRefCount$lambda$5(this, block, arg_0));
        }

        public void bindNull(int index) {
            this.ensureCapacity(5, index);
            this.bindingTypes[index] = 5;
        }

        public void bindLong(int index, long value) {
            this.ensureCapacity(1, index);
            this.bindingTypes[index] = 1;
            this.longBindings[index] = value;
        }

        public void bindDouble(int index, double value) {
            this.ensureCapacity(2, index);
            this.bindingTypes[index] = 2;
            this.doubleBindings[index] = value;
        }

        public void bindString(int index, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.ensureCapacity(3, index);
            this.bindingTypes[index] = 3;
            this.stringBindings[index] = value;
        }

        public void bindBlob(int index, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.ensureCapacity(4, index);
            this.bindingTypes[index] = 4;
            this.blobBindings[index] = value;
        }

        public void clearBindings() {
            this.bindingTypes = new int[0];
            this.longBindings = new long[0];
            this.doubleBindings = new double[0];
            this.stringBindings = new String[0];
            this.blobBindings = new byte[0][];
        }

        private final void ensureCapacity(int columnType, int index) {
            int requiredSize = index + 1;
            if (this.bindingTypes.length < requiredSize) {
                int[] nArray = Arrays.copyOf(this.bindingTypes, requiredSize);
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
                this.bindingTypes = nArray;
            }
            switch (columnType) {
                case 1: {
                    if (this.longBindings.length >= requiredSize) break;
                    long[] lArray = Arrays.copyOf(this.longBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
                    this.longBindings = lArray;
                    break;
                }
                case 2: {
                    if (this.doubleBindings.length >= requiredSize) break;
                    double[] dArray = Arrays.copyOf(this.doubleBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
                    this.doubleBindings = dArray;
                    break;
                }
                case 3: {
                    if (this.stringBindings.length >= requiredSize) break;
                    String[] stringArray = Arrays.copyOf(this.stringBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(...)");
                    this.stringBindings = stringArray;
                    break;
                }
                case 4: {
                    if (((Object[])this.blobBindings).length >= requiredSize) break;
                    Object[] objectArray = Arrays.copyOf((Object[])this.blobBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
                    this.blobBindings = (byte[][])objectArray;
                }
            }
        }

        private final void bindTo(SupportSQLiteProgram query2) {
            int n = this.bindingTypes.length;
            block7: for (int index = 1; index < n; ++index) {
                switch (this.bindingTypes[index]) {
                    case 1: {
                        query2.bindLong(index, this.longBindings[index]);
                        continue block7;
                    }
                    case 2: {
                        query2.bindDouble(index, this.doubleBindings[index]);
                        continue block7;
                    }
                    case 3: {
                        String string = this.stringBindings[index];
                        Intrinsics.checkNotNull((Object)string);
                        query2.bindString(index, string);
                        continue block7;
                    }
                    case 4: {
                        byte[] byArray = this.blobBindings[index];
                        Intrinsics.checkNotNull((Object)byArray);
                        query2.bindBlob(index, byArray);
                        continue block7;
                    }
                    case 5: {
                        query2.bindNull(index);
                    }
                }
            }
        }

        private static final Unit execute$lambda$0(SupportSQLiteStatement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            statement.execute();
            return Unit.INSTANCE;
        }

        private static final int executeUpdateDelete$lambda$1(SupportSQLiteStatement obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.executeUpdateDelete();
        }

        private static final long executeInsert$lambda$2(SupportSQLiteStatement obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.executeInsert();
        }

        private static final long simpleQueryForLong$lambda$3(SupportSQLiteStatement obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.simpleQueryForLong();
        }

        private static final String simpleQueryForString$lambda$4(SupportSQLiteStatement obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.simpleQueryForString();
        }

        private static final Object executeWithRefCount$lambda$5(AutoClosingSupportSQLiteStatement this$0, Function1 $block, SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            SupportSQLiteStatement actualStatement = db.compileStatement(this$0.sql);
            this$0.bindTo((SupportSQLiteProgram)actualStatement);
            return $block.invoke((Object)actualStatement);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/room/support/AutoClosingRoomOpenHelper$AutoClosingSupportSQLiteStatement$Companion;", "", "<init>", "()V", "COLUMN_TYPE_LONG", "", "COLUMN_TYPE_DOUBLE", "COLUMN_TYPE_STRING", "COLUMN_TYPE_BLOB", "COLUMN_TYPE_NULL", "room-runtime_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rH\u0096\u0001\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0010\u001a\u00020\bH\u0097\u0001J\u001e\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\u00120\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010\u0013J\t\u0010\u0014\u001a\u00020\u000bH\u0096\u0001J\u001e\u0010\u0015\u001a\u00020\u000b2\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u00020\u000b2\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0019\u001a\n \u000e*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010\u001aJ4\u0010\u001b\u001a(\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00160\u0016 \u000e*\u0014\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\u001c0\u001cH\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ\t\u0010\u001e\u001a\u00020\u000bH\u0096\u0001J\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001J\u0016\u0010!\u001a\n \u000e*\u0004\u0018\u00010\"0\"H\u0096\u0001\u00a2\u0006\u0002\u0010#J\u0011\u0010$\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001J\u0011\u0010&\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001J\u0011\u0010'\u001a\u00020(2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001J\u0016\u0010)\u001a\n \u000e*\u0004\u0018\u00010*0*H\u0096\u0001\u00a2\u0006\u0002\u0010+J\t\u0010,\u001a\u00020\u000bH\u0096\u0001J\u0011\u0010-\u001a\u00020.2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001J\u001e\u0010/\u001a\n \u000e*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0011\u00100\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001J\t\u00101\u001a\u000202H\u0096\u0001J\t\u00103\u001a\u000202H\u0096\u0001J\t\u00104\u001a\u000202H\u0096\u0001J\t\u00105\u001a\u000202H\u0096\u0001J\t\u00106\u001a\u000202H\u0096\u0001J\t\u00107\u001a\u000202H\u0096\u0001J\u0011\u00108\u001a\u0002022\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001J\u0011\u00109\u001a\u0002022\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001J\t\u0010:\u001a\u000202H\u0096\u0001J\t\u0010;\u001a\u000202H\u0096\u0001J\t\u0010<\u001a\u000202H\u0096\u0001J\u0011\u0010=\u001a\u0002022\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001J\t\u0010>\u001a\u000202H\u0096\u0001J\u001e\u0010?\u001a\u00020\b2\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010@0@H\u0096\u0001\u00a2\u0006\u0002\u0010AJ\u001e\u0010B\u001a\u00020\b2\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010C0CH\u0096\u0001\u00a2\u0006\u0002\u0010DJ\t\u0010E\u001a\u000202H\u0097\u0001J&\u0010F\u001a\n \u000e*\u0004\u0018\u00010\"0\"2\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010\"0\"H\u0096\u0001\u00a2\u0006\u0002\u0010GJ\u001e\u0010H\u001a\u00020\b2\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010\"0\"H\u0096\u0001\u00a2\u0006\u0002\u0010IJ.\u0010J\u001a\u00020\b2\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010K0K2\u000e\u0010\f\u001a\n \u000e*\u0004\u0018\u00010*0*H\u0096\u0001\u00a2\u0006\u0002\u0010LJ\u001e\u0010M\u001a\u00020\b2\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010@0@H\u0096\u0001\u00a2\u0006\u0002\u0010AJ\u001e\u0010N\u001a\u00020\b2\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010C0CH\u0096\u0001\u00a2\u0006\u0002\u0010DR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Landroidx/room/support/AutoClosingRoomOpenHelper$KeepAliveCursor;", "Landroid/database/Cursor;", "delegate", "autoCloser", "Landroidx/room/support/AutoCloser;", "<init>", "(Landroid/database/Cursor;Landroidx/room/support/AutoCloser;)V", "close", "", "copyStringToBuffer", "p0", "", "p1", "Landroid/database/CharArrayBuffer;", "kotlin.jvm.PlatformType", "(ILandroid/database/CharArrayBuffer;)V", "deactivate", "getBlob", "", "(I)[B", "getColumnCount", "getColumnIndex", "", "(Ljava/lang/String;)I", "getColumnIndexOrThrow", "getColumnName", "(I)Ljava/lang/String;", "getColumnNames", "", "()[Ljava/lang/String;", "getCount", "getDouble", "", "getExtras", "Landroid/os/Bundle;", "()Landroid/os/Bundle;", "getFloat", "", "getInt", "getLong", "", "getNotificationUri", "Landroid/net/Uri;", "()Landroid/net/Uri;", "getPosition", "getShort", "", "getString", "getType", "getWantsAllOnMoveCalls", "", "isAfterLast", "isBeforeFirst", "isClosed", "isFirst", "isLast", "isNull", "move", "moveToFirst", "moveToLast", "moveToNext", "moveToPosition", "moveToPrevious", "registerContentObserver", "Landroid/database/ContentObserver;", "(Landroid/database/ContentObserver;)V", "registerDataSetObserver", "Landroid/database/DataSetObserver;", "(Landroid/database/DataSetObserver;)V", "requery", "respond", "(Landroid/os/Bundle;)Landroid/os/Bundle;", "setExtras", "(Landroid/os/Bundle;)V", "setNotificationUri", "Landroid/content/ContentResolver;", "(Landroid/content/ContentResolver;Landroid/net/Uri;)V", "unregisterContentObserver", "unregisterDataSetObserver", "room-runtime_release"})
    private static final class KeepAliveCursor
    implements Cursor {
        @NotNull
        private final Cursor delegate;
        @NotNull
        private final AutoCloser autoCloser;

        public KeepAliveCursor(@NotNull Cursor delegate, @NotNull AutoCloser autoCloser) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)autoCloser, (String)"autoCloser");
            this.delegate = delegate;
            this.autoCloser = autoCloser;
        }

        public void close() {
            this.delegate.close();
            this.autoCloser.decrementCountAndScheduleClose();
        }

        public int getCount() {
            return this.delegate.getCount();
        }

        public int getPosition() {
            return this.delegate.getPosition();
        }

        public boolean move(int p0) {
            return this.delegate.move(p0);
        }

        public boolean moveToPosition(int p0) {
            return this.delegate.moveToPosition(p0);
        }

        public boolean moveToFirst() {
            return this.delegate.moveToFirst();
        }

        public boolean moveToLast() {
            return this.delegate.moveToLast();
        }

        public boolean moveToNext() {
            return this.delegate.moveToNext();
        }

        public boolean moveToPrevious() {
            return this.delegate.moveToPrevious();
        }

        public boolean isFirst() {
            return this.delegate.isFirst();
        }

        public boolean isLast() {
            return this.delegate.isLast();
        }

        public boolean isBeforeFirst() {
            return this.delegate.isBeforeFirst();
        }

        public boolean isAfterLast() {
            return this.delegate.isAfterLast();
        }

        public int getColumnIndex(String p0) {
            return this.delegate.getColumnIndex(p0);
        }

        public int getColumnIndexOrThrow(String p0) {
            return this.delegate.getColumnIndexOrThrow(p0);
        }

        public String getColumnName(int p0) {
            return this.delegate.getColumnName(p0);
        }

        public String[] getColumnNames() {
            return this.delegate.getColumnNames();
        }

        public int getColumnCount() {
            return this.delegate.getColumnCount();
        }

        public byte[] getBlob(int p0) {
            return this.delegate.getBlob(p0);
        }

        public String getString(int p0) {
            return this.delegate.getString(p0);
        }

        public void copyStringToBuffer(int p0, CharArrayBuffer p1) {
            this.delegate.copyStringToBuffer(p0, p1);
        }

        public short getShort(int p0) {
            return this.delegate.getShort(p0);
        }

        public int getInt(int p0) {
            return this.delegate.getInt(p0);
        }

        public long getLong(int p0) {
            return this.delegate.getLong(p0);
        }

        public float getFloat(int p0) {
            return this.delegate.getFloat(p0);
        }

        public double getDouble(int p0) {
            return this.delegate.getDouble(p0);
        }

        public int getType(int p0) {
            return this.delegate.getType(p0);
        }

        public boolean isNull(int p0) {
            return this.delegate.isNull(p0);
        }

        @Deprecated(message="Deprecated in Java")
        public void deactivate() {
            this.delegate.deactivate();
        }

        @Deprecated(message="Deprecated in Java")
        public boolean requery() {
            return this.delegate.requery();
        }

        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        public void registerContentObserver(ContentObserver p0) {
            this.delegate.registerContentObserver(p0);
        }

        public void unregisterContentObserver(ContentObserver p0) {
            this.delegate.unregisterContentObserver(p0);
        }

        public void registerDataSetObserver(DataSetObserver p0) {
            this.delegate.registerDataSetObserver(p0);
        }

        public void unregisterDataSetObserver(DataSetObserver p0) {
            this.delegate.unregisterDataSetObserver(p0);
        }

        public void setNotificationUri(ContentResolver p0, Uri p1) {
            this.delegate.setNotificationUri(p0, p1);
        }

        public Uri getNotificationUri() {
            return this.delegate.getNotificationUri();
        }

        public boolean getWantsAllOnMoveCalls() {
            return this.delegate.getWantsAllOnMoveCalls();
        }

        public void setExtras(Bundle p0) {
            this.delegate.setExtras(p0);
        }

        public Bundle getExtras() {
            return this.delegate.getExtras();
        }

        public Bundle respond(Bundle p0) {
            return this.delegate.respond(p0);
        }
    }
}

