/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.support;

import android.os.SystemClock;
import androidx.annotation.GuardedBy;
import androidx.room.support.AutoClosingRoomOpenHelper;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 82\u00020\u0001:\u000278B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010!\u001a\u00020\u0010H\u0002J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010#\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ%\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H%0'\u00a2\u0006\u0002\u0010(J\u0006\u0010)\u001a\u00020\u0018J\u0006\u0010*\u001a\u00020\u0010J\u0006\u0010+\u001a\u00020\u0010J\u0014\u0010.\u001a\u00020\u00102\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001c\u00100\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u0002048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u00069"}, d2={"Landroidx/room/support/AutoCloser;", "", "timeoutAmount", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "watch", "Landroidx/room/support/AutoCloser$Watch;", "<init>", "(JLjava/util/concurrent/TimeUnit;Landroidx/room/support/AutoCloser$Watch;)V", "delegateOpenHelper", "Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "onAutoCloseCallback", "Lkotlin/Function0;", "", "lock", "autoCloseTimeoutInMs", "referenceCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "lastDecrementRefCountTimeStamp", "Ljava/util/concurrent/atomic/AtomicLong;", "delegateDatabase", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "getDelegateDatabase$room_runtime_release", "()Landroidx/sqlite/db/SupportSQLiteDatabase;", "setDelegateDatabase$room_runtime_release", "(Landroidx/sqlite/db/SupportSQLiteDatabase;)V", "manuallyClosed", "", "autoCloseJob", "Lkotlinx/coroutines/Job;", "autoCloseDatabase", "initOpenHelper", "initCoroutineScope", "executeRefCountingFunction", "V", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "incrementCountAndEnsureDbIsOpen", "decrementCountAndScheduleClose", "closeDatabaseIfOpen", "isActive", "()Z", "setAutoCloseCallback", "onAutoClose", "autoCloseCallbackForTest", "getAutoCloseCallbackForTest$room_runtime_release", "()Lkotlin/jvm/functions/Function0;", "refCountForTest", "", "getRefCountForTest$room_runtime_release", "()I", "Watch", "Companion", "room-runtime_release"})
@SourceDebugExtension(value={"SMAP\nAutoCloser.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoCloser.android.kt\nandroidx/room/support/AutoCloser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
public final class AutoCloser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Watch watch;
    private SupportSQLiteOpenHelper delegateOpenHelper;
    private CoroutineScope coroutineScope;
    @Nullable
    private Function0<Unit> onAutoCloseCallback;
    @NotNull
    private final Object lock;
    private final long autoCloseTimeoutInMs;
    @NotNull
    private final AtomicInteger referenceCount;
    @NotNull
    private AtomicLong lastDecrementRefCountTimeStamp;
    @GuardedBy(value="lock")
    @Nullable
    private SupportSQLiteDatabase delegateDatabase;
    private boolean manuallyClosed;
    @Nullable
    private Job autoCloseJob;
    @NotNull
    public static final String BUG_LINK = "https://issuetracker.google.com/issues/new?component=413107&template=1096568";

    public AutoCloser(long timeoutAmount, @NotNull TimeUnit timeUnit, @NotNull Watch watch) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Intrinsics.checkNotNullParameter((Object)watch, (String)"watch");
        this.watch = watch;
        this.lock = new Object();
        this.autoCloseTimeoutInMs = timeUnit.toMillis(timeoutAmount);
        this.referenceCount = new AtomicInteger(0);
        this.lastDecrementRefCountTimeStamp = new AtomicLong(this.watch.getMillis());
    }

    public /* synthetic */ AutoCloser(long l, TimeUnit timeUnit, Watch watch, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            watch = AutoCloser::_init_$lambda$0;
        }
        this(l, timeUnit, watch);
    }

    @Nullable
    public final SupportSQLiteDatabase getDelegateDatabase$room_runtime_release() {
        return this.delegateDatabase;
    }

    public final void setDelegateDatabase$room_runtime_release(@Nullable SupportSQLiteDatabase supportSQLiteDatabase) {
        this.delegateDatabase = supportSQLiteDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void autoCloseDatabase() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.watch.getMillis() - this.lastDecrementRefCountTimeStamp.get() < this.autoCloseTimeoutInMs) {
                return;
            }
            if (this.referenceCount.get() != 0) {
                return;
            }
            Function0<Unit> function0 = this.onAutoCloseCallback;
            if (function0 == null) {
                throw new IllegalStateException("onAutoCloseCallback is null but it should  have been set before use. Please file a bug against Room at: https://issuetracker.google.com/issues/new?component=413107&template=1096568".toString());
            }
            function0.invoke();
            SupportSQLiteDatabase supportSQLiteDatabase = this.delegateDatabase;
            if (supportSQLiteDatabase != null) {
                SupportSQLiteDatabase it = supportSQLiteDatabase;
                boolean bl2 = false;
                if (it.isOpen()) {
                    it.close();
                }
            }
            this.delegateDatabase = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void initOpenHelper(@NotNull SupportSQLiteOpenHelper delegateOpenHelper) {
        Intrinsics.checkNotNullParameter((Object)delegateOpenHelper, (String)"delegateOpenHelper");
        if (!(!(delegateOpenHelper instanceof AutoClosingRoomOpenHelper))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.delegateOpenHelper = delegateOpenHelper;
    }

    public final void initCoroutineScope(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <V> V executeRefCountingFunction(@NotNull Function1<? super SupportSQLiteDatabase, ? extends V> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            object = block.invoke((Object)this.incrementCountAndEnsureDbIsOpen());
        }
        finally {
            this.decrementCountAndScheduleClose();
        }
        return (V)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final SupportSQLiteDatabase incrementCountAndEnsureDbIsOpen() {
        Job job2 = this.autoCloseJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.autoCloseJob = null;
        this.referenceCount.incrementAndGet();
        if (!(!this.manuallyClosed)) {
            boolean bl = false;
            String string = "Attempting to open already closed database.";
            throw new IllegalStateException(string.toString());
        }
        Object object = this.lock;
        synchronized (object) {
            SupportSQLiteDatabase supportSQLiteDatabase;
            SupportSQLiteOpenHelper supportSQLiteOpenHelper;
            boolean bl = false;
            SupportSQLiteDatabase supportSQLiteDatabase2 = this.delegateDatabase;
            if (supportSQLiteDatabase2 != null) {
                SupportSQLiteDatabase it = supportSQLiteDatabase2;
                boolean bl2 = false;
                if (it.isOpen()) {
                    return it;
                }
            }
            if ((supportSQLiteOpenHelper = this.delegateOpenHelper) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegateOpenHelper");
                supportSQLiteOpenHelper = null;
            }
            SupportSQLiteDatabase it = supportSQLiteDatabase = supportSQLiteOpenHelper.getWritableDatabase();
            boolean bl3 = false;
            this.delegateDatabase = it;
            return supportSQLiteDatabase;
        }
    }

    public final void decrementCountAndScheduleClose() {
        int newCount = this.referenceCount.decrementAndGet();
        if (!(newCount >= 0)) {
            boolean bl = false;
            String string = "Unbalanced reference count.";
            throw new IllegalStateException(string.toString());
        }
        this.lastDecrementRefCountTimeStamp.set(this.watch.getMillis());
        if (newCount == 0) {
            CoroutineScope coroutineScope = this.coroutineScope;
            if (coroutineScope == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"coroutineScope");
                coroutineScope = null;
            }
            this.autoCloseJob = BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ AutoCloser this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay((long)AutoCloser.access$getAutoCloseTimeoutInMs$p(this.this$0), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            AutoCloser.access$autoCloseDatabase(this.this$0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeDatabaseIfOpen() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.manuallyClosed = true;
            Job job2 = this.autoCloseJob;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            this.autoCloseJob = null;
            SupportSQLiteDatabase supportSQLiteDatabase = this.delegateDatabase;
            if (supportSQLiteDatabase != null) {
                supportSQLiteDatabase.close();
            }
            this.delegateDatabase = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isActive() {
        return !this.manuallyClosed;
    }

    public final void setAutoCloseCallback(@NotNull Function0<Unit> onAutoClose) {
        Intrinsics.checkNotNullParameter(onAutoClose, (String)"onAutoClose");
        this.onAutoCloseCallback = onAutoClose;
    }

    @Nullable
    public final Function0<Unit> getAutoCloseCallbackForTest$room_runtime_release() {
        return this.onAutoCloseCallback;
    }

    public final int getRefCountForTest$room_runtime_release() {
        return this.referenceCount.get();
    }

    private static final long _init_$lambda$0() {
        return SystemClock.uptimeMillis();
    }

    public static final /* synthetic */ long access$getAutoCloseTimeoutInMs$p(AutoCloser $this) {
        return $this.autoCloseTimeoutInMs;
    }

    public static final /* synthetic */ void access$autoCloseDatabase(AutoCloser $this) {
        $this.autoCloseDatabase();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/room/support/AutoCloser$Companion;", "", "<init>", "()V", "BUG_LINK", "", "room-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Landroidx/room/support/AutoCloser$Watch;", "", "getMillis", "", "room-runtime_release"})
    public static interface Watch {
        public long getMillis();
    }
}

