/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.driver;

import android.database.Cursor;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.sqlite.SQLite;
import androidx.sqlite.SQLiteStatement;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteProgram;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.util.Arrays;
import java.util.Locale;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Landroidx/room/driver/SupportSQLiteStatement;", "Landroidx/sqlite/SQLiteStatement;", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "sql", "", "<init>", "(Landroidx/sqlite/db/SupportSQLiteDatabase;Ljava/lang/String;)V", "getDb", "()Landroidx/sqlite/db/SupportSQLiteDatabase;", "getSql", "()Ljava/lang/String;", "isClosed", "", "()Z", "setClosed", "(Z)V", "throwIfClosed", "", "Companion", "SupportAndroidSQLiteStatement", "SupportOtherAndroidSQLiteStatement", "Landroidx/room/driver/SupportSQLiteStatement$SupportAndroidSQLiteStatement;", "Landroidx/room/driver/SupportSQLiteStatement$SupportOtherAndroidSQLiteStatement;", "room-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class SupportSQLiteStatement
implements SQLiteStatement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SupportSQLiteDatabase db;
    @NotNull
    private final String sql;
    private boolean isClosed;

    private SupportSQLiteStatement(SupportSQLiteDatabase db, String sql) {
        this.db = db;
        this.sql = sql;
    }

    @NotNull
    protected final SupportSQLiteDatabase getDb() {
        return this.db;
    }

    @NotNull
    protected final String getSql() {
        return this.sql;
    }

    protected final boolean isClosed() {
        return this.isClosed;
    }

    protected final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    protected final void throwIfClosed() {
        if (this.isClosed) {
            SQLite.throwSQLiteException((int)21, (String)"statement is closed");
            throw new KotlinNothingValueException();
        }
    }

    public /* synthetic */ SupportSQLiteStatement(SupportSQLiteDatabase db, String sql, DefaultConstructorMarker $constructor_marker) {
        this(db, sql);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0017\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Landroidx/room/driver/SupportSQLiteStatement$Companion;", "", "<init>", "()V", "create", "Landroidx/room/driver/SupportSQLiteStatement;", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "sql", "", "isRowStatement", "", "prefix", "getStatementPrefix", "getStatementPrefix$room_runtime_release", "getStatementPrefixIndex", "", "s", "room-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SupportSQLiteStatement create(@NotNull SupportSQLiteDatabase db, @NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            String string = ((Object)StringsKt.trim((CharSequence)sql)).toString().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String sqlString = string;
            String sqlPrefix = this.getStatementPrefix$room_runtime_release(sqlString);
            if (sqlPrefix == null) {
                return new SupportOtherAndroidSQLiteStatement(db, sql);
            }
            return this.isRowStatement(sqlPrefix) ? (SupportSQLiteStatement)new SupportAndroidSQLiteStatement(db, sql) : (SupportSQLiteStatement)new SupportOtherAndroidSQLiteStatement(db, sql);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isRowStatement(String prefix) {
            String string = prefix;
            switch (string.hashCode()) {
                case 85954: {
                    if (string.equals("WIT")) return true;
                    return false;
                }
                case 81978: {
                    if (string.equals("SEL")) return true;
                    return false;
                }
                case 79487: {
                    if (!string.equals("PRA")) return false;
                    return true;
                }
            }
            return false;
        }

        @VisibleForTesting
        @Nullable
        public final String getStatementPrefix$room_runtime_release(@NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            int index = this.getStatementPrefixIndex(sql);
            if (index < 0 || index > sql.length()) {
                return null;
            }
            String string = sql.substring(index, Math.min(index + 3, sql.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        private final int getStatementPrefixIndex(String s) {
            int limit = s.length() - 2;
            if (limit < 0) {
                return -1;
            }
            int i = 0;
            while (i < limit) {
                char c = s.charAt(i);
                if (Intrinsics.compare((int)c, (int)32) <= 0) {
                    ++i;
                    continue;
                }
                if (c == '-') {
                    if (s.charAt(i + 1) != '-') {
                        return i;
                    }
                    if ((i = StringsKt.indexOf$default((CharSequence)s, (char)'\n', (int)(i + 2), (boolean)false, (int)4, null)) < 0) {
                        return -1;
                    }
                    ++i;
                    continue;
                }
                if (c == '/') {
                    if (s.charAt(i + 1) != '*') {
                        return i;
                    }
                    ++i;
                    do {
                        if ((i = StringsKt.indexOf$default((CharSequence)s, (char)'*', (int)(i + 1), (boolean)false, (int)4, null)) >= 0) continue;
                        return -1;
                    } while (i + 1 < limit && s.charAt(i + 1) != '/');
                    i += 2;
                    continue;
                }
                return i;
            }
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0002\u0018\u0000 42\u00020\u0001:\u00014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010'\u001a\u00020\u0019H\u0016J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010*\u001a\u00020&H\u0016J\b\u0010+\u001a\u00020\u0017H\u0016J\b\u0010,\u001a\u00020\u0017H\u0016J\b\u0010-\u001a\u00020\u0017H\u0016J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u00100\u001a\u00020\u0017H\u0002J\b\u00101\u001a\u00020\u0015H\u0002J\u0018\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Landroidx/room/driver/SupportSQLiteStatement$SupportAndroidSQLiteStatement;", "Landroidx/room/driver/SupportSQLiteStatement;", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "sql", "", "<init>", "(Landroidx/sqlite/db/SupportSQLiteDatabase;Ljava/lang/String;)V", "bindingTypes", "", "longBindings", "", "doubleBindings", "", "stringBindings", "", "[Ljava/lang/String;", "blobBindings", "", "[[B", "cursor", "Landroid/database/Cursor;", "bindBlob", "", "index", "", "value", "bindDouble", "", "bindLong", "", "bindText", "bindNull", "getBlob", "getDouble", "getLong", "getText", "isNull", "", "getColumnCount", "getColumnName", "getColumnType", "step", "reset", "clearBindings", "close", "ensureCapacity", "columnType", "ensureCursor", "throwIfNoRow", "throwIfInvalidColumn", "c", "Companion", "room-runtime_release"})
    private static final class SupportAndroidSQLiteStatement
    extends SupportSQLiteStatement {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private int[] bindingTypes;
        @NotNull
        private long[] longBindings;
        @NotNull
        private double[] doubleBindings;
        @NotNull
        private String[] stringBindings;
        @NotNull
        private byte[][] blobBindings;
        @Nullable
        private Cursor cursor;

        public SupportAndroidSQLiteStatement(@NotNull SupportSQLiteDatabase db, @NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            super(db, sql, null);
            this.bindingTypes = new int[0];
            this.longBindings = new long[0];
            this.doubleBindings = new double[0];
            this.stringBindings = new String[0];
            this.blobBindings = new byte[0][];
        }

        public void bindBlob(int index, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.throwIfClosed();
            this.ensureCapacity(4, index);
            this.bindingTypes[index] = 4;
            this.blobBindings[index] = value;
        }

        public void bindDouble(int index, double value) {
            this.throwIfClosed();
            this.ensureCapacity(2, index);
            this.bindingTypes[index] = 2;
            this.doubleBindings[index] = value;
        }

        public void bindLong(int index, long value) {
            this.throwIfClosed();
            this.ensureCapacity(1, index);
            this.bindingTypes[index] = 1;
            this.longBindings[index] = value;
        }

        public void bindText(int index, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.throwIfClosed();
            this.ensureCapacity(3, index);
            this.bindingTypes[index] = 3;
            this.stringBindings[index] = value;
        }

        public void bindNull(int index) {
            this.throwIfClosed();
            this.ensureCapacity(5, index);
            this.bindingTypes[index] = 5;
        }

        @NotNull
        public byte[] getBlob(int index) {
            this.throwIfClosed();
            Cursor c = this.throwIfNoRow();
            this.throwIfInvalidColumn(c, index);
            byte[] byArray = c.getBlob(index);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBlob(...)");
            return byArray;
        }

        public double getDouble(int index) {
            this.throwIfClosed();
            Cursor c = this.throwIfNoRow();
            this.throwIfInvalidColumn(c, index);
            return c.getDouble(index);
        }

        public long getLong(int index) {
            this.throwIfClosed();
            Cursor c = this.throwIfNoRow();
            this.throwIfInvalidColumn(c, index);
            return c.getLong(index);
        }

        @NotNull
        public String getText(int index) {
            this.throwIfClosed();
            Cursor c = this.throwIfNoRow();
            this.throwIfInvalidColumn(c, index);
            String string = c.getString(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return string;
        }

        public boolean isNull(int index) {
            this.throwIfClosed();
            Cursor c = this.throwIfNoRow();
            this.throwIfInvalidColumn(c, index);
            return c.isNull(index);
        }

        public int getColumnCount() {
            this.throwIfClosed();
            this.ensureCursor();
            Cursor cursor = this.cursor;
            return cursor != null ? cursor.getColumnCount() : 0;
        }

        @NotNull
        public String getColumnName(int index) {
            this.throwIfClosed();
            this.ensureCursor();
            Cursor cursor = this.cursor;
            if (cursor == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Cursor c = cursor;
            this.throwIfInvalidColumn(c, index);
            String string = c.getColumnName(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getColumnName(...)");
            return string;
        }

        public int getColumnType(int index) {
            this.throwIfClosed();
            this.ensureCursor();
            Cursor cursor = this.cursor;
            if (cursor == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Cursor c = cursor;
            this.throwIfInvalidColumn(c, index);
            return SupportAndroidSQLiteStatement.Companion.getDataType(c, index);
        }

        public boolean step() {
            this.throwIfClosed();
            this.ensureCursor();
            Cursor cursor = this.cursor;
            if (cursor == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            return cursor.moveToNext();
        }

        public void reset() {
            this.throwIfClosed();
            Cursor cursor = this.cursor;
            if (cursor != null) {
                cursor.close();
            }
            this.cursor = null;
        }

        public void clearBindings() {
            this.throwIfClosed();
            this.bindingTypes = new int[0];
            this.longBindings = new long[0];
            this.doubleBindings = new double[0];
            this.stringBindings = new String[0];
            this.blobBindings = new byte[0][];
        }

        public void close() {
            if (!this.isClosed()) {
                this.clearBindings();
                this.reset();
            }
            this.setClosed(true);
        }

        private final void ensureCapacity(int columnType, int index) {
            int requiredSize = index + 1;
            if (this.bindingTypes.length < requiredSize) {
                int[] nArray = Arrays.copyOf(this.bindingTypes, requiredSize);
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
                this.bindingTypes = nArray;
            }
            switch (columnType) {
                case 1: {
                    if (this.longBindings.length >= requiredSize) break;
                    long[] lArray = Arrays.copyOf(this.longBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
                    this.longBindings = lArray;
                    break;
                }
                case 2: {
                    if (this.doubleBindings.length >= requiredSize) break;
                    double[] dArray = Arrays.copyOf(this.doubleBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
                    this.doubleBindings = dArray;
                    break;
                }
                case 3: {
                    if (this.stringBindings.length >= requiredSize) break;
                    String[] stringArray = Arrays.copyOf(this.stringBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(...)");
                    this.stringBindings = stringArray;
                    break;
                }
                case 4: {
                    if (((Object[])this.blobBindings).length >= requiredSize) break;
                    Object[] objectArray = Arrays.copyOf((Object[])this.blobBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
                    this.blobBindings = (byte[][])objectArray;
                }
            }
        }

        private final void ensureCursor() {
            if (this.cursor == null) {
                this.cursor = this.getDb().query(new SupportSQLiteQuery(this){
                    final /* synthetic */ SupportAndroidSQLiteStatement this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public String getSql() {
                        return this.this$0.getSql();
                    }

                    public void bindTo(SupportSQLiteProgram statement) {
                        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                        int n = SupportAndroidSQLiteStatement.access$getBindingTypes$p(this.this$0).length;
                        block7: for (int index = 1; index < n; ++index) {
                            switch (SupportAndroidSQLiteStatement.access$getBindingTypes$p(this.this$0)[index]) {
                                case 1: {
                                    statement.bindLong(index, SupportAndroidSQLiteStatement.access$getLongBindings$p(this.this$0)[index]);
                                    continue block7;
                                }
                                case 2: {
                                    statement.bindDouble(index, SupportAndroidSQLiteStatement.access$getDoubleBindings$p(this.this$0)[index]);
                                    continue block7;
                                }
                                case 3: {
                                    String string = SupportAndroidSQLiteStatement.access$getStringBindings$p(this.this$0)[index];
                                    Intrinsics.checkNotNull((Object)string);
                                    statement.bindString(index, string);
                                    continue block7;
                                }
                                case 4: {
                                    byte[] byArray = SupportAndroidSQLiteStatement.access$getBlobBindings$p(this.this$0)[index];
                                    Intrinsics.checkNotNull((Object)byArray);
                                    statement.bindBlob(index, byArray);
                                    continue block7;
                                }
                                case 5: {
                                    statement.bindNull(index);
                                }
                            }
                        }
                    }

                    public int getArgCount() {
                        return SupportAndroidSQLiteStatement.access$getBindingTypes$p(this.this$0).length;
                    }
                });
            }
        }

        private final Cursor throwIfNoRow() {
            Cursor cursor = this.cursor;
            if (cursor == null) {
                SQLite.throwSQLiteException((int)21, (String)"no row");
                throw new KotlinNothingValueException();
            }
            return cursor;
        }

        private final void throwIfInvalidColumn(Cursor c, int index) {
            if (index < 0 || index >= c.getColumnCount()) {
                SQLite.throwSQLiteException((int)25, (String)"column index out of range");
                throw new KotlinNothingValueException();
            }
        }

        public static final /* synthetic */ int[] access$getBindingTypes$p(SupportAndroidSQLiteStatement $this) {
            return $this.bindingTypes;
        }

        public static final /* synthetic */ long[] access$getLongBindings$p(SupportAndroidSQLiteStatement $this) {
            return $this.longBindings;
        }

        public static final /* synthetic */ double[] access$getDoubleBindings$p(SupportAndroidSQLiteStatement $this) {
            return $this.doubleBindings;
        }

        public static final /* synthetic */ String[] access$getStringBindings$p(SupportAndroidSQLiteStatement $this) {
            return $this.stringBindings;
        }

        public static final /* synthetic */ byte[][] access$getBlobBindings$p(SupportAndroidSQLiteStatement $this) {
            return $this.blobBindings;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Landroidx/room/driver/SupportSQLiteStatement$SupportAndroidSQLiteStatement$Companion;", "", "<init>", "()V", "getDataType", "", "Landroid/database/Cursor;", "index", "room-runtime_release"})
        public static final class Companion {
            private Companion() {
            }

            private final int getDataType(Cursor $this$getDataType, int index) {
                int n;
                int fieldType = $this$getDataType.getType(index);
                switch ($this$getDataType.getType(index)) {
                    case 0: {
                        n = 5;
                        break;
                    }
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 2;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    case 4: {
                        n = 4;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Unknown field type: " + fieldType).toString());
                    }
                }
                return n;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\fH\u0016J\b\u0010#\u001a\u00020\fH\u0016R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/room/driver/SupportSQLiteStatement$SupportOtherAndroidSQLiteStatement;", "Landroidx/room/driver/SupportSQLiteStatement;", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "sql", "", "<init>", "(Landroidx/sqlite/db/SupportSQLiteDatabase;Ljava/lang/String;)V", "delegate", "Landroidx/sqlite/db/SupportSQLiteStatement;", "Landroidx/room/driver/SupportStatement;", "bindBlob", "", "index", "", "value", "", "bindDouble", "", "bindLong", "", "bindText", "bindNull", "getBlob", "getDouble", "getLong", "getText", "isNull", "", "getColumnCount", "getColumnName", "getColumnType", "step", "reset", "clearBindings", "close", "room-runtime_release"})
    private static final class SupportOtherAndroidSQLiteStatement
    extends SupportSQLiteStatement {
        @NotNull
        private final androidx.sqlite.db.SupportSQLiteStatement delegate;

        public SupportOtherAndroidSQLiteStatement(@NotNull SupportSQLiteDatabase db, @NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            super(db, sql, null);
            this.delegate = db.compileStatement(sql);
        }

        public void bindBlob(int index, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.throwIfClosed();
            this.delegate.bindBlob(index, value);
        }

        public void bindDouble(int index, double value) {
            this.throwIfClosed();
            this.delegate.bindDouble(index, value);
        }

        public void bindLong(int index, long value) {
            this.throwIfClosed();
            this.delegate.bindLong(index, value);
        }

        public void bindText(int index, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.throwIfClosed();
            this.delegate.bindString(index, value);
        }

        public void bindNull(int index) {
            this.throwIfClosed();
            this.delegate.bindNull(index);
        }

        @NotNull
        public byte[] getBlob(int index) {
            this.throwIfClosed();
            SQLite.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        public double getDouble(int index) {
            this.throwIfClosed();
            SQLite.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        public long getLong(int index) {
            this.throwIfClosed();
            SQLite.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getText(int index) {
            this.throwIfClosed();
            SQLite.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        public boolean isNull(int index) {
            this.throwIfClosed();
            SQLite.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        public int getColumnCount() {
            this.throwIfClosed();
            return 0;
        }

        @NotNull
        public String getColumnName(int index) {
            this.throwIfClosed();
            SQLite.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        public int getColumnType(int index) {
            this.throwIfClosed();
            SQLite.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        public boolean step() {
            this.throwIfClosed();
            this.delegate.execute();
            return false;
        }

        public void reset() {
        }

        public void clearBindings() {
            this.throwIfClosed();
            this.delegate.clearBindings();
        }

        public void close() {
            this.delegate.close();
            this.setClosed(true);
        }
    }
}

