/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.concurrent;

import androidx.room.concurrent.FileLock;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/room/concurrent/ExclusiveLock;", "", "filename", "", "useFileLock", "", "<init>", "(Ljava/lang/String;Z)V", "threadLock", "Ljava/util/concurrent/locks/ReentrantLock;", "Landroidx/room/concurrent/ReentrantLock;", "Ljava/util/concurrent/locks/ReentrantLock;", "fileLock", "Landroidx/room/concurrent/FileLock;", "withLock", "T", "onLocked", "Lkotlin/Function0;", "onLockError", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "room-runtime_release"})
public final class ExclusiveLock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReentrantLock threadLock;
    @Nullable
    private final FileLock fileLock;
    @NotNull
    private static final Map<String, ReentrantLock> threadLocksMap = new LinkedHashMap();

    public ExclusiveLock(@NotNull String filename, boolean useFileLock) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.threadLock = ExclusiveLock.Companion.getThreadLock(filename);
        this.fileLock = useFileLock ? ExclusiveLock.Companion.getFileLock(filename) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withLock(@NotNull Function0<? extends T> onLocked, @NotNull Function1 onLockError) {
        Intrinsics.checkNotNullParameter(onLocked, (String)"onLocked");
        Intrinsics.checkNotNullParameter((Object)onLockError, (String)"onLockError");
        boolean locked = false;
        this.threadLock.lock();
        try {
            FileLock fileLock;
            Object object;
            FileLock fileLock2 = this.fileLock;
            if (fileLock2 != null) {
                fileLock2.lock();
            }
            try {
                locked = true;
                object = onLocked.invoke();
                fileLock = this.fileLock;
            }
            catch (Throwable throwable) {
                try {
                    FileLock fileLock3 = this.fileLock;
                    if (fileLock3 != null) {
                        fileLock3.unlock();
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    if (locked) {
                        throw t;
                    }
                    onLockError.invoke((Object)t);
                    throw new KotlinNothingValueException();
                }
            }
            if (fileLock != null) {
                fileLock.unlock();
            }
            return (T)object;
        }
        finally {
            this.threadLock.unlock();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0019\u0010\n\u001a\u00060\bj\u0002`\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bj\u0002`\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/room/concurrent/ExclusiveLock$Companion;", "", "Landroidx/room/concurrent/SynchronizedObject;", "<init>", "()V", "threadLocksMap", "", "", "Ljava/util/concurrent/locks/ReentrantLock;", "Landroidx/room/concurrent/ReentrantLock;", "getThreadLock", "key", "(Ljava/lang/String;)Ljava/util/concurrent/locks/ReentrantLock;", "getFileLock", "Landroidx/room/concurrent/FileLock;", "room-runtime_release"})
    @SourceDebugExtension(value={"SMAP\nExclusiveLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExclusiveLock.kt\nandroidx/room/concurrent/ExclusiveLock$Companion\n+ 2 Synchronized.jvmAndroid.kt\nandroidx/room/concurrent/Synchronized_jvmAndroidKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,77:1\n22#2:78\n381#3,7:79\n*S KotlinDebug\n*F\n+ 1 ExclusiveLock.kt\nandroidx/room/concurrent/ExclusiveLock$Companion\n*L\n70#1:78\n71#1:79,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ReentrantLock getThreadLock(String key) {
            boolean $i$f$synchronized = false;
            Companion companion = this;
            synchronized (companion) {
                Object object;
                boolean bl = false;
                Map $this$getOrPut$iv = threadLocksMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key);
                if (value$iv == null) {
                    boolean bl2 = false;
                    ReentrantLock answer$iv = new ReentrantLock();
                    $this$getOrPut$iv.put(key, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ReentrantLock reentrantLock = (ReentrantLock)object;
                return reentrantLock;
            }
        }

        private final FileLock getFileLock(String key) {
            return new FileLock(key);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

