/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.RestrictTo;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH$J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Landroidx/room/SharedSQLiteStatement;", "", "database", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "lock", "Ljava/util/concurrent/atomic/AtomicBoolean;", "stmt", "Landroidx/sqlite/db/SupportSQLiteStatement;", "getStmt", "()Landroidx/sqlite/db/SupportSQLiteStatement;", "stmt$delegate", "Lkotlin/Lazy;", "createQuery", "", "assertNotMainThread", "", "createNewStatement", "canUseCached", "", "acquire", "release", "statement", "room-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public abstract class SharedSQLiteStatement {
    @NotNull
    private final RoomDatabase database;
    @NotNull
    private final AtomicBoolean lock;
    @NotNull
    private final Lazy stmt$delegate;

    public SharedSQLiteStatement(@NotNull RoomDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
        this.lock = new AtomicBoolean(false);
        this.stmt$delegate = LazyKt.lazy(() -> SharedSQLiteStatement.stmt_delegate$lambda$0(this));
    }

    private final SupportSQLiteStatement getStmt() {
        Lazy lazy = this.stmt$delegate;
        return (SupportSQLiteStatement)lazy.getValue();
    }

    @NotNull
    protected abstract String createQuery();

    protected void assertNotMainThread() {
        this.database.assertNotMainThread();
    }

    private final SupportSQLiteStatement createNewStatement() {
        String query2 = this.createQuery();
        return this.database.compileStatement(query2);
    }

    private final SupportSQLiteStatement getStmt(boolean canUseCached) {
        SupportSQLiteStatement stmt = canUseCached ? this.getStmt() : this.createNewStatement();
        return stmt;
    }

    @NotNull
    public SupportSQLiteStatement acquire() {
        this.assertNotMainThread();
        return this.getStmt(this.lock.compareAndSet(false, true));
    }

    public void release(@NotNull SupportSQLiteStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        if (statement == this.getStmt()) {
            this.lock.set(false);
        }
    }

    private static final SupportSQLiteStatement stmt_delegate$lambda$0(SharedSQLiteStatement this$0) {
        return this$0.createNewStatement();
    }
}

