/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.annotation.SuppressLint;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.room.RoomRawQuery;
import androidx.sqlite.SQLiteStatement;
import androidx.sqlite.db.SupportSQLiteProgram;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.lang.annotation.RetentionPolicy;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\b\u0007\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u00029:B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0004J\u0006\u0010#\u001a\u00020!J\u0006\u0010$\u001a\u00020%J\u0010\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020\u0002H\u0016J\u000e\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u0004H\u0016J\u0018\u0010.\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0016\u00103\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\nJ\u0018\u00104\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u00105\u001a\u00020!H\u0016J\u000e\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020\u0000J\b\u00108\u001a\u00020!H\u0016R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u000eR \u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00138\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u0012\u0004\b\u0014\u0010\u000eR \u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00138\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u0012\u0004\b\u0018\u0010\u000eR\u0014\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001c\u0010\u000eR\u001e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\bR\u0014\u0010&\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006;"}, d2={"Landroidx/room/RoomSQLiteQuery;", "Landroidx/sqlite/db/SupportSQLiteQuery;", "Landroidx/sqlite/db/SupportSQLiteProgram;", "capacity", "", "<init>", "(I)V", "getCapacity", "()I", "query", "", "longBindings", "", "getLongBindings$annotations", "()V", "doubleBindings", "", "getDoubleBindings$annotations", "stringBindings", "", "getStringBindings$annotations", "[Ljava/lang/String;", "blobBindings", "", "getBlobBindings$annotations", "[[B", "bindingTypes", "", "getBindingTypes$annotations", "value", "argCount", "getArgCount", "init", "", "initArgCount", "release", "toRoomRawQuery", "Landroidx/room/RoomRawQuery;", "sql", "getSql", "()Ljava/lang/String;", "bindTo", "statement", "Landroidx/sqlite/SQLiteStatement;", "bindNull", "index", "bindLong", "", "bindDouble", "", "bindString", "bindText", "bindBlob", "close", "copyArgumentsFrom", "other", "clearBindings", "Binding", "Companion", "room-runtime_release"})
@SuppressLint(value={"WrongConstant"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class RoomSQLiteQuery
implements SupportSQLiteQuery,
SupportSQLiteProgram {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @VisibleForTesting
    private final int capacity;
    @Nullable
    private volatile String query;
    @JvmField
    @NotNull
    public final long[] longBindings;
    @JvmField
    @NotNull
    public final double[] doubleBindings;
    @JvmField
    @NotNull
    public final String[] stringBindings;
    @JvmField
    @NotNull
    public final byte[][] blobBindings;
    @NotNull
    private final int[] bindingTypes;
    private int argCount;
    public static final int POOL_LIMIT = 15;
    public static final int DESIRED_POOL_SIZE = 10;
    @JvmField
    @NotNull
    public static final TreeMap<Integer, RoomSQLiteQuery> queryPool = new TreeMap();
    private static final int NULL = 1;
    private static final int LONG = 2;
    private static final int DOUBLE = 3;
    private static final int STRING = 4;
    private static final int BLOB = 5;

    private RoomSQLiteQuery(int capacity) {
        this.capacity = capacity;
        int limit = this.capacity + 1;
        this.bindingTypes = new int[limit];
        this.longBindings = new long[limit];
        this.doubleBindings = new double[limit];
        this.stringBindings = new String[limit];
        this.blobBindings = new byte[limit][];
    }

    public final int getCapacity() {
        return this.capacity;
    }

    @VisibleForTesting
    public static /* synthetic */ void getLongBindings$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getDoubleBindings$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getStringBindings$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getBlobBindings$annotations() {
    }

    private static /* synthetic */ void getBindingTypes$annotations() {
    }

    public int getArgCount() {
        return this.argCount;
    }

    public final void init(@NotNull String query2, int initArgCount) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        this.query = query2;
        this.argCount = initArgCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        TreeMap<Integer, RoomSQLiteQuery> treeMap = queryPool;
        synchronized (treeMap) {
            boolean bl = false;
            ((Map)queryPool).put(this.capacity, this);
            Companion.prunePoolLocked$room_runtime_release();
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final RoomRawQuery toRoomRawQuery() {
        return new RoomRawQuery(this.getSql(), (Function1<? super SQLiteStatement, Unit>)((Function1)arg_0 -> RoomSQLiteQuery.toRoomRawQuery$lambda$1(this, arg_0)));
    }

    @NotNull
    public String getSql() {
        String string = this.query;
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        return string;
    }

    public void bindTo(@NotNull SupportSQLiteProgram statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        int index = 1;
        int n = this.getArgCount();
        if (index <= n) {
            while (true) {
                switch (this.bindingTypes[index]) {
                    case 1: {
                        statement.bindNull(index);
                        break;
                    }
                    case 2: {
                        statement.bindLong(index, this.longBindings[index]);
                        break;
                    }
                    case 3: {
                        statement.bindDouble(index, this.doubleBindings[index]);
                        break;
                    }
                    case 4: {
                        String string = this.stringBindings[index];
                        if (string == null) {
                            String string2 = "Required value was null.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        statement.bindString(index, string);
                        break;
                    }
                    case 5: {
                        byte[] byArray = this.blobBindings[index];
                        if (byArray == null) {
                            String string = "Required value was null.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        statement.bindBlob(index, byArray);
                    }
                }
                if (index == n) break;
                ++index;
            }
        }
    }

    public final void bindTo(@NotNull SQLiteStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        int index = 1;
        int n = this.getArgCount();
        if (index <= n) {
            while (true) {
                switch (this.bindingTypes[index]) {
                    case 1: {
                        statement.bindNull(index);
                        break;
                    }
                    case 2: {
                        statement.bindLong(index, this.longBindings[index]);
                        break;
                    }
                    case 3: {
                        statement.bindDouble(index, this.doubleBindings[index]);
                        break;
                    }
                    case 4: {
                        String string = this.stringBindings[index];
                        if (string == null) {
                            String string2 = "Required value was null.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        statement.bindText(index, string);
                        break;
                    }
                    case 5: {
                        byte[] byArray = this.blobBindings[index];
                        if (byArray == null) {
                            String string = "Required value was null.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        statement.bindBlob(index, byArray);
                    }
                }
                if (index == n) break;
                ++index;
            }
        }
    }

    public void bindNull(int index) {
        this.bindingTypes[index] = 1;
    }

    public void bindLong(int index, long value) {
        this.bindingTypes[index] = 2;
        this.longBindings[index] = value;
    }

    public void bindDouble(int index, double value) {
        this.bindingTypes[index] = 3;
        this.doubleBindings[index] = value;
    }

    public void bindString(int index, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bindingTypes[index] = 4;
        this.stringBindings[index] = value;
    }

    public final void bindText(int index, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bindString(index, value);
    }

    public void bindBlob(int index, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bindingTypes[index] = 5;
        this.blobBindings[index] = value;
    }

    public void close() {
    }

    public final void copyArgumentsFrom(@NotNull RoomSQLiteQuery other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int argCount = other.getArgCount() + 1;
        System.arraycopy(other.bindingTypes, 0, this.bindingTypes, 0, argCount);
        System.arraycopy(other.longBindings, 0, this.longBindings, 0, argCount);
        System.arraycopy(other.stringBindings, 0, this.stringBindings, 0, argCount);
        System.arraycopy(other.blobBindings, 0, this.blobBindings, 0, argCount);
        System.arraycopy(other.doubleBindings, 0, this.doubleBindings, 0, argCount);
    }

    public void clearBindings() {
        ArraysKt.fill$default((int[])this.bindingTypes, (int)1, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((Object[])this.stringBindings, null, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((Object[])((Object[])this.blobBindings), null, (int)0, (int)0, (int)6, null);
        this.query = null;
    }

    private static final Unit toRoomRawQuery$lambda$1(RoomSQLiteQuery this$0, SQLiteStatement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.bindTo(it);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final RoomSQLiteQuery copyFrom(@NotNull SupportSQLiteQuery supportSQLiteQuery) {
        return Companion.copyFrom(supportSQLiteQuery);
    }

    @JvmStatic
    @NotNull
    public static final RoomSQLiteQuery acquire(@NotNull String query2, int argumentCount) {
        return Companion.acquire(query2, argumentCount);
    }

    public /* synthetic */ RoomSQLiteQuery(int capacity, DefaultConstructorMarker $constructor_marker) {
        this(capacity);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/room/RoomSQLiteQuery$Binding;", "", "room-runtime_release"})
    public static @interface Binding {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\"\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/room/RoomSQLiteQuery$Companion;", "", "<init>", "()V", "POOL_LIMIT", "", "getPOOL_LIMIT$annotations", "DESIRED_POOL_SIZE", "getDESIRED_POOL_SIZE$annotations", "queryPool", "Ljava/util/TreeMap;", "Landroidx/room/RoomSQLiteQuery;", "getQueryPool$annotations", "copyFrom", "supportSQLiteQuery", "Landroidx/sqlite/db/SupportSQLiteQuery;", "acquire", "query", "", "argumentCount", "prunePoolLocked", "", "prunePoolLocked$room_runtime_release", "NULL", "LONG", "DOUBLE", "STRING", "BLOB", "room-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPOOL_LIMIT$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getDESIRED_POOL_SIZE$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getQueryPool$annotations() {
        }

        @JvmStatic
        @NotNull
        public final RoomSQLiteQuery copyFrom(@NotNull SupportSQLiteQuery supportSQLiteQuery) {
            Intrinsics.checkNotNullParameter((Object)supportSQLiteQuery, (String)"supportSQLiteQuery");
            RoomSQLiteQuery query2 = this.acquire(supportSQLiteQuery.getSql(), supportSQLiteQuery.getArgCount());
            supportSQLiteQuery.bindTo(new SupportSQLiteProgram(query2){
                private final /* synthetic */ RoomSQLiteQuery $$delegate_0;
                {
                    this.$$delegate_0 = $query;
                }

                public void bindNull(int index) {
                    this.$$delegate_0.bindNull(index);
                }

                public void bindLong(int index, long value) {
                    this.$$delegate_0.bindLong(index, value);
                }

                public void bindDouble(int index, double value) {
                    this.$$delegate_0.bindDouble(index, value);
                }

                public void bindString(int index, String value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    this.$$delegate_0.bindString(index, value);
                }

                public void bindBlob(int index, byte[] value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    this.$$delegate_0.bindBlob(index, value);
                }

                public void clearBindings() {
                    this.$$delegate_0.clearBindings();
                }

                public void close() {
                    this.$$delegate_0.close();
                }
            });
            return query2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final RoomSQLiteQuery acquire(@NotNull String query2, int argumentCount) {
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            TreeMap<Integer, RoomSQLiteQuery> treeMap = queryPool;
            synchronized (treeMap) {
                block4: {
                    boolean bl = false;
                    Map.Entry<Integer, RoomSQLiteQuery> entry = queryPool.ceilingEntry(argumentCount);
                    if (entry == null) break block4;
                    queryPool.remove(entry.getKey());
                    RoomSQLiteQuery sqliteQuery = entry.getValue();
                    sqliteQuery.init(query2, argumentCount);
                    Intrinsics.checkNotNull((Object)sqliteQuery);
                    RoomSQLiteQuery roomSQLiteQuery = sqliteQuery;
                    return roomSQLiteQuery;
                }
                Unit unit = Unit.INSTANCE;
            }
            RoomSQLiteQuery sqLiteQuery = new RoomSQLiteQuery(argumentCount, null);
            sqLiteQuery.init(query2, argumentCount);
            return sqLiteQuery;
        }

        public final void prunePoolLocked$room_runtime_release() {
            if (queryPool.size() > 15) {
                int toBeRemoved = queryPool.size() - 10;
                Iterator<Integer> iterator = queryPool.descendingKeySet().iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<Integer> iterator2 = iterator;
                while (toBeRemoved-- > 0) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

