/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.database.Cursor;
import androidx.annotation.RestrictTo;
import androidx.room.DatabaseConfiguration;
import androidx.room.RoomDatabase;
import androidx.room.RoomMasterTable;
import androidx.room.driver.SupportSQLiteConnection;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.io.Closeable;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Replaced by RoomConnectionManager and no longer used in generated code.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001d\u001e\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J \u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/room/RoomOpenHelper;", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;", "configuration", "Landroidx/room/DatabaseConfiguration;", "delegate", "Landroidx/room/RoomOpenHelper$Delegate;", "identityHash", "", "legacyHash", "<init>", "(Landroidx/room/DatabaseConfiguration;Landroidx/room/RoomOpenHelper$Delegate;Ljava/lang/String;Ljava/lang/String;)V", "(Landroidx/room/DatabaseConfiguration;Landroidx/room/RoomOpenHelper$Delegate;Ljava/lang/String;)V", "callbacks", "", "Landroidx/room/RoomDatabase$Callback;", "onConfigure", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "onCreate", "onUpgrade", "oldVersion", "", "newVersion", "onDowngrade", "onOpen", "checkIdentity", "updateIdentity", "createMasterTableIfNotExists", "Delegate", "ValidationResult", "Companion", "room-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@SourceDebugExtension(value={"SMAP\nRoomOpenHelper.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomOpenHelper.android.kt\nandroidx/room/RoomOpenHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CursorUtil.android.kt\nandroidx/room/util/CursorUtil\n*L\n1#1,278:1\n1863#2,2:279\n1863#2,2:281\n1863#2,2:283\n1863#2,2:285\n146#3:287\n*S KotlinDebug\n*F\n+ 1 RoomOpenHelper.android.kt\nandroidx/room/RoomOpenHelper\n*L\n81#1:279,2\n90#1:281,2\n112#1:283,2\n135#1:285,2\n143#1:287\n*E\n"})
public class RoomOpenHelper
extends SupportSQLiteOpenHelper.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private DatabaseConfiguration configuration;
    @Nullable
    private final List<RoomDatabase.Callback> callbacks;
    @NotNull
    private final Delegate delegate;
    @NotNull
    private final String identityHash;
    @NotNull
    private final String legacyHash;

    public RoomOpenHelper(@NotNull DatabaseConfiguration configuration2, @NotNull Delegate delegate, @NotNull String identityHash, @NotNull String legacyHash) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)identityHash, (String)"identityHash");
        Intrinsics.checkNotNullParameter((Object)legacyHash, (String)"legacyHash");
        super(delegate.version);
        this.callbacks = configuration2.callbacks;
        this.configuration = configuration2;
        this.delegate = delegate;
        this.identityHash = identityHash;
        this.legacyHash = legacyHash;
    }

    public RoomOpenHelper(@NotNull DatabaseConfiguration configuration2, @NotNull Delegate delegate, @NotNull String legacyHash) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)legacyHash, (String)"legacyHash");
        this(configuration2, delegate, "", legacyHash);
    }

    public void onConfigure(@NotNull SupportSQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        super.onConfigure(db);
    }

    public void onCreate(@NotNull SupportSQLiteDatabase db) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            boolean isEmptyDatabase = Companion.hasEmptySchema$room_runtime_release(db);
            this.delegate.createAllTables(db);
            if (!isEmptyDatabase) {
                ValidationResult result2 = this.delegate.onValidateSchema(db);
                if (!result2.isValid) {
                    throw new IllegalStateException("Pre-packaged database has an invalid schema: " + result2.expectedFoundMsg);
                }
            }
            this.updateIdentity(db);
            this.delegate.onCreate(db);
            List<RoomDatabase.Callback> list = this.callbacks;
            if (list == null) break block3;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RoomDatabase.Callback it = (RoomDatabase.Callback)element$iv;
                boolean bl = false;
                it.onCreate(db);
            }
        }
    }

    public void onUpgrade(@NotNull SupportSQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        boolean migrated = false;
        DatabaseConfiguration databaseConfiguration = this.configuration;
        if (databaseConfiguration != null) {
            DatabaseConfiguration config = databaseConfiguration;
            boolean bl = false;
            List<Migration> migrations = config.migrationContainer.findMigrationPath(oldVersion, newVersion);
            if (migrations != null) {
                this.delegate.onPreMigrate(db);
                Iterable $this$forEach$iv = migrations;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Migration it = (Migration)element$iv;
                    boolean bl2 = false;
                    it.migrate(new SupportSQLiteConnection(db));
                }
                ValidationResult result2 = this.delegate.onValidateSchema(db);
                if (!result2.isValid) {
                    throw new IllegalStateException("Migration didn't properly handle: " + result2.expectedFoundMsg);
                }
                this.delegate.onPostMigrate(db);
                this.updateIdentity(db);
                migrated = true;
            }
        }
        if (!migrated) {
            DatabaseConfiguration config = this.configuration;
            if (config != null && !config.isMigrationRequired(oldVersion, newVersion)) {
                if (config.allowDestructiveMigrationForAllTables) {
                    Companion.dropAllTables$room_runtime_release(db);
                } else {
                    this.delegate.dropAllTables(db);
                }
                List<RoomDatabase.Callback> list = this.callbacks;
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RoomDatabase.Callback it = (RoomDatabase.Callback)element$iv;
                        boolean bl = false;
                        it.onDestructiveMigration(db);
                    }
                }
                this.delegate.createAllTables(db);
            } else {
                throw new IllegalStateException("A migration from " + oldVersion + " to " + newVersion + " was required but not found. Please provide the necessary Migration path via RoomDatabase.Builder.addMigration(Migration ...) or allow for destructive migrations via one of the RoomDatabase.Builder.fallbackToDestructiveMigration* methods.");
            }
        }
    }

    public void onDowngrade(@NotNull SupportSQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.onUpgrade(db, oldVersion, newVersion);
    }

    public void onOpen(@NotNull SupportSQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        super.onOpen(db);
        this.checkIdentity(db);
        this.delegate.onOpen(db);
        List<RoomDatabase.Callback> list = this.callbacks;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RoomDatabase.Callback it = (RoomDatabase.Callback)element$iv;
                boolean bl = false;
                it.onOpen(db);
            }
        }
        this.configuration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkIdentity(SupportSQLiteDatabase db) {
        if (Companion.hasRoomMasterTable$room_runtime_release(db)) {
            String string;
            Cursor $this$useCursor$iv = db.query((SupportSQLiteQuery)new SimpleSQLiteQuery("SELECT identity_hash FROM room_master_table WHERE id = 42 LIMIT 1"));
            boolean $i$f$useCursor = false;
            Closeable closeable = (Closeable)$this$useCursor$iv;
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                string = cursor.moveToFirst() ? cursor.getString(0) : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String identityHash = string;
            if (!Intrinsics.areEqual((Object)this.identityHash, (Object)identityHash) && !Intrinsics.areEqual((Object)this.legacyHash, (Object)identityHash)) {
                throw new IllegalStateException("Room cannot verify the data integrity. Looks like you've changed schema but forgot to update the version number. You can simply fix this by increasing the version number. Expected identity hash: " + this.identityHash + ", found: " + identityHash);
            }
        } else {
            ValidationResult result2 = this.delegate.onValidateSchema(db);
            if (!result2.isValid) {
                throw new IllegalStateException("Pre-packaged database has an invalid schema: " + result2.expectedFoundMsg);
            }
            this.delegate.onPostMigrate(db);
            this.updateIdentity(db);
        }
    }

    private final void updateIdentity(SupportSQLiteDatabase db) {
        this.createMasterTableIfNotExists(db);
        db.execSQL(RoomMasterTable.createInsertQuery((String)this.identityHash));
    }

    private final void createMasterTableIfNotExists(SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0015\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Landroidx/room/RoomOpenHelper$Companion;", "", "<init>", "()V", "hasRoomMasterTable", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "hasRoomMasterTable$room_runtime_release", "hasEmptySchema", "hasEmptySchema$room_runtime_release", "dropAllTables", "", "dropAllTables$room_runtime_release", "room-runtime_release"})
    @SourceDebugExtension(value={"SMAP\nRoomOpenHelper.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomOpenHelper.android.kt\nandroidx/room/RoomOpenHelper$Companion\n+ 2 CursorUtil.android.kt\nandroidx/room/util/CursorUtil\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n146#2:279\n146#2:280\n146#2:281\n1863#3,2:282\n*S KotlinDebug\n*F\n+ 1 RoomOpenHelper.android.kt\nandroidx/room/RoomOpenHelper$Companion\n*L\n242#1:279\n249#1:280\n256#1:281\n268#1:282,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean hasRoomMasterTable$room_runtime_release(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Cursor $this$useCursor$iv = db.query("SELECT 1 FROM sqlite_master WHERE type = 'table' AND name='room_master_table'");
            boolean $i$f$useCursor = false;
            Closeable closeable = (Closeable)$this$useCursor$iv;
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                boolean bl2 = cursor.moveToFirst() && cursor.getInt(0) != 0;
                return bl2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean hasEmptySchema$room_runtime_release(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Cursor $this$useCursor$iv = db.query("SELECT count(*) FROM sqlite_master WHERE name != 'android_metadata'");
            boolean $i$f$useCursor = false;
            Closeable closeable = (Closeable)$this$useCursor$iv;
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                boolean bl2 = cursor.moveToFirst() && cursor.getInt(0) == 0;
                return bl2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dropAllTables$room_runtime_release(@NotNull SupportSQLiteDatabase db) {
            List list;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Cursor $this$useCursor$iv = db.query("SELECT name, type FROM sqlite_master WHERE type = 'table' OR type = 'view'");
            boolean $i$f$useCursor = false;
            Closeable closeable = (Closeable)$this$useCursor$iv;
            Throwable throwable = null;
            try {
                List list2;
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                List $this$dropAllTables_u24lambda_u243_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
                boolean bl2 = false;
                while (cursor.moveToNext()) {
                    String name = cursor.getString(0);
                    Intrinsics.checkNotNull((Object)name);
                    if (StringsKt.startsWith$default((String)name, (String)"sqlite_", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"android_metadata")) continue;
                    boolean isView = Intrinsics.areEqual((Object)cursor.getString(1), (Object)"view");
                    $this$dropAllTables_u24lambda_u243_u24lambda_u242.add(TuplesKt.to((Object)name, (Object)isView));
                }
                list = CollectionsKt.build((List)list2);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                list = (Pair)element$iv;
                boolean bl = false;
                String name = (String)list.component1();
                boolean isView = (Boolean)list.component2();
                if (isView) {
                    db.execSQL("DROP VIEW IF EXISTS " + name);
                    continue;
                }
                db.execSQL("DROP TABLE IF EXISTS " + name);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Deprecated(message="Replaced by OpenDelegate  and no longer used in generated code.")
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0015J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/room/RoomOpenHelper$Delegate;", "", "version", "", "<init>", "(I)V", "dropAllTables", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "createAllTables", "onOpen", "onCreate", "validateMigration", "onValidateSchema", "Landroidx/room/RoomOpenHelper$ValidationResult;", "onPreMigrate", "onPostMigrate", "room-runtime_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static abstract class Delegate {
        @JvmField
        public final int version;

        public Delegate(int version2) {
            this.version = version2;
        }

        public abstract void dropAllTables(@NotNull SupportSQLiteDatabase var1);

        public abstract void createAllTables(@NotNull SupportSQLiteDatabase var1);

        public abstract void onOpen(@NotNull SupportSQLiteDatabase var1);

        public abstract void onCreate(@NotNull SupportSQLiteDatabase var1);

        @Deprecated(message="Use [onValidateSchema(SupportSQLiteDatabase)]")
        protected void validateMigration(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            throw new UnsupportedOperationException("validateMigration is deprecated");
        }

        @NotNull
        public ValidationResult onValidateSchema(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            this.validateMigration(db);
            return new ValidationResult(true, null);
        }

        public void onPreMigrate(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        }

        public void onPostMigrate(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        }
    }

    @Deprecated(message="Replaced by OpenDelegate.ValidationResult and no longer used in generated code.")
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/room/RoomOpenHelper$ValidationResult;", "", "isValid", "", "expectedFoundMsg", "", "<init>", "(ZLjava/lang/String;)V", "room-runtime_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static class ValidationResult {
        @JvmField
        public final boolean isValid;
        @JvmField
        @Nullable
        public final String expectedFoundMsg;

        public ValidationResult(boolean isValid, @Nullable String expectedFoundMsg) {
            this.isValid = isValid;
            this.expectedFoundMsg = expectedFoundMsg;
        }
    }
}

